/*! @license


 SoundManager 2: JavaScript Sound for the Web
 ----------------------------------------------
 http://schillmania.com/projects/soundmanager2/

 Copyright (c) 2007, Scott Schiller. All rights reserved.
 Code provided under the BSD License:
 http://schillmania.com/projects/soundmanager2/license.txt

 V2.97a.20170601
*/
!function(e,t){function n(n,o){function i(e){return _e.preferFlash&&le&&!_e.ignoreFlash&&_e.flash[e]!==t&&_e.flash[e]}function a(e){return function(t){var n=this._s;return n&&n._a?t=e.call(this,t):(n&&n.id?_e._wD(n.id+": Ignoring "+t.type):_e._wD("HTML5::Ignoring "+t.type),t=null),t}}this.setupOptions={url:n||null,flashVersion:8,debugMode:!0,debugFlash:!1,useConsole:!0,consoleOnly:!0,waitForWindowLoad:!1,bgColor:"#ffffff",useHighPerformance:!1,flashPollingInterval:null,html5PollingInterval:null,flashLoadTimeout:1e3,wmode:null,allowScriptAccess:"always",useFlashBlock:!1,useHTML5Audio:!0,forceUseGlobalHTML5Audio:!1,ignoreMobileRestrictions:!1,html5Test:/^(probably|maybe)$/i,preferFlash:!1,noSWFCache:!1,idPrefix:"sound"},this.defaultOptions={autoLoad:!1,autoPlay:!1,from:null,loops:1,onid3:null,onerror:null,onload:null,whileloading:null,onplay:null,onpause:null,onresume:null,whileplaying:null,onposition:null,onstop:null,onfinish:null,multiShot:!0,multiShotEvents:!1,position:null,pan:0,playbackRate:1,stream:!0,to:null,type:null,usePolicyFile:!1,volume:100},this.flash9Options={onfailure:null,isMovieStar:null,usePeakData:!1,useWaveformData:!1,useEQData:!1,onbufferchange:null,ondataerror:null},this.movieStarOptions={bufferTime:3,serverURL:null,onconnect:null,duration:null},this.audioFormats={mp3:{type:['audio/mpeg; codecs="mp3"',"audio/mpeg","audio/mp3","audio/MPA","audio/mpa-robust"],required:!0},mp4:{related:["aac","m4a","m4b"],type:['audio/mp4; codecs="mp4a.40.2"',"audio/aac","audio/x-m4a","audio/MP4A-LATM","audio/mpeg4-generic"],required:!1},ogg:{type:["audio/ogg; codecs=vorbis"],required:!1},opus:{type:["audio/ogg; codecs=opus","audio/opus"],required:!1},wav:{type:['audio/wav; codecs="1"',"audio/wav","audio/wave","audio/x-wav"],required:!1},flac:{type:["audio/flac"],required:!1}},this.movieID="sm2-container",this.id=o||"sm2movie",this.debugID="soundmanager-debug",this.debugURLParam=/([#?&])debug=1/i,this.versionNumber="V2.97a.20170601",this.altURL=this.movieURL=this.version=null,this.enabled=this.swfLoaded=!1,this.oMC=null,this.sounds={},this.soundIDs=[],this.didFlashBlock=this.muted=!1,this.filePattern=null,this.filePatterns={flash8:/\.mp3(\?.*)?$/i,flash9:/\.mp3(\?.*)?$/i},this.features={buffering:!1,peakData:!1,waveformData:!1,eqData:!1,movieStar:!1},this.sandbox={type:null,types:{remote:"remote (domain-based) rules",localWithFile:"local with file access (no internet access)",localWithNetwork:"local with network (internet access only, no local access)",localTrusted:"local, trusted (local+internet access)"},description:null,noRemote:null,noLocal:null},this.html5={usingFlash:null},this.flash={},this.ignoreFlash=this.html5Only=!1;var s,r,l,u,d,c,h,f,p,m,_,g,y,w,v,M,b,O,D,L,T,P,S,F,I,H,A,E,R,k,C,x,N,U,B,j,W,q,V,Q,K,$,G,J,X,z,Z,Y,ee,te,ne,oe,ie,ae,se,re,le,ue,de,ce,he,fe,pe,me,_e=this,ge=null,ye=null,we=navigator.userAgent,ve=e.location.href.toString(),Me=document,be=[],Oe=!0,De=!1,Le=!1,Te=!1,Pe=!1,Se=!1,Fe=0,Ie=["log","info","warn","error"],He=null,Ae=null,Ee=!1,Re=!1,ke=0,Ce=null,xe=[],Ne=null,Ue=Array.prototype.slice,Be=!1,je=0,We=we.match(/(ipad|iphone|ipod)/i),qe=we.match(/android/i),Ve=we.match(/msie|trident/i),Qe=we.match(/webkit/i),Ke=we.match(/safari/i)&&!we.match(/chrome/i),$e=we.match(/opera/i),Ge=we.match(/(mobile|pre\/|xoom)/i)||We||qe,Je=!ve.match(/usehtml5audio/i)&&!ve.match(/sm2-ignorebadua/i)&&Ke&&!we.match(/silk/i)&&we.match(/OS\sX\s10_6_([3-7])/i),Xe=e.console!==t&&console.log!==t,ze=Me.hasFocus!==t?Me.hasFocus():null,Ze=Ke&&(Me.hasFocus===t||!Me.hasFocus()),Ye=!Ze,et=/(mp3|mp4|mpa|m4a|m4b)/i,tt=Me.location?Me.location.protocol.match(/http/i):null,nt=tt?"":"//",ot=/^\s*audio\/(?:x-)?(?:mpeg4|aac|flv|mov|mp4|m4v|m4a|m4b|mp4v|3gp|3g2)\s*(?:$|;)/i,it="mpeg4 aac flv mov mp4 m4v f4v m4a m4b mp4v 3gp 3g2".split(" "),at=new RegExp("\\.("+it.join("|")+")(\\?.*)?$","i");this.mimePattern=/^\s*audio\/(?:x-)?(?:mp(?:eg|3))\s*(?:$|;)/i,this.useAltURL=!tt,te=[null,"MEDIA_ERR_ABORTED","MEDIA_ERR_NETWORK","MEDIA_ERR_DECODE","MEDIA_ERR_SRC_NOT_SUPPORTED"];var st;try{st=Audio!==t&&($e&&opera!==t&&10>opera.version()?new Audio(null):new Audio).canPlayType!==t}catch(e){st=!1}this.hasHTML5=st,this.setup=function(e){var n=!_e.url;return e!==t&&Te&&Ne&&_e.ok()&&(e.flashVersion!==t||e.url!==t||e.html5Test!==t)&&Q(U("setupLate")),_(e),Be||(Ge?_e.setupOptions.ignoreMobileRestrictions&&!_e.setupOptions.forceUseGlobalHTML5Audio||(xe.push(T.globalHTML5),Be=!0):_e.setupOptions.forceUseGlobalHTML5Audio&&(xe.push(T.globalHTML5),Be=!0)),!me&&Ge&&(_e.setupOptions.ignoreMobileRestrictions?xe.push(T.ignoreMobile):(_e.setupOptions.useHTML5Audio&&!_e.setupOptions.preferFlash||_e._wD(T.mobileUA),_e.setupOptions.useHTML5Audio=!0,_e.setupOptions.preferFlash=!1,We?_e.ignoreFlash=!0:(qe&&!we.match(/android\s2\.3/i)||!qe)&&(_e._wD(T.globalHTML5),Be=!0))),e&&(n&&I&&e.url!==t&&_e.beginDelayedInit(),I||e.url===t||"complete"!==Me.readyState||setTimeout(S,1)),me=!0,_e},this.supported=this.ok=function(){return Ne?Te&&!Pe:_e.useHTML5Audio&&_e.hasHTML5},this.getMovie=function(t){return r(t)||Me[t]||e[t]},this.createSound=function(e,n){function o(){return a=q(a),_e.sounds[a.id]=new s(a),_e.soundIDs.push(a.id),_e.sounds[a.id]}var i,a;if(i=null,i="soundManager.createSound(): "+U(Te?"notOK":"notReady"),!Te||!_e.ok())return Q(i),!1;if(n!==t&&(e={id:e,url:n}),a=m(e),a.url=X(a.url),a.id===t&&(a.id=_e.setupOptions.idPrefix+je++),a.id.toString().charAt(0).match(/^[0-9]$/)&&_e._wD("soundManager.createSound(): "+U("badID",a.id),2),_e._wD("soundManager.createSound(): "+a.id+(a.url?" ("+a.url+")":""),1),K(a.id,!0))return _e._wD("soundManager.createSound(): "+a.id+" exists",1),_e.sounds[a.id];if(Y(a))i=o(),_e.html5Only||_e._wD(a.id+": Using HTML5"),i._setup_html5(a);else{if(_e.html5Only)return _e._wD(a.id+": No HTML5 support for this sound, and no Flash. Exiting."),o();if(_e.html5.usingFlash&&a.url&&a.url.match(/data:/i))return _e._wD(a.id+": data: URIs not supported via Flash. Exiting."),o();8<c&&(null===a.isMovieStar&&(a.isMovieStar=!!(a.serverURL||a.type&&a.type.match(ot)||a.url&&a.url.match(at))),a.isMovieStar&&(_e._wD("soundManager.createSound(): using MovieStar handling"),1<a.loops&&f("noNSLoop"))),a=V(a,"soundManager.createSound(): "),i=o(),8===c?ye._createSound(a.id,a.loops||1,a.usePolicyFile):(ye._createSound(a.id,a.url,a.usePeakData,a.useWaveformData,a.useEQData,a.isMovieStar,!!a.isMovieStar&&a.bufferTime,a.loops||1,a.serverURL,a.duration||null,a.autoPlay,!0,a.autoLoad,a.usePolicyFile),a.serverURL||(i.connected=!0,a.onconnect&&a.onconnect.apply(i))),a.serverURL||!a.autoLoad&&!a.autoPlay||i.load(a)}return!a.serverURL&&a.autoPlay&&i.play(),i},this.destroySound=function(e,t){if(!K(e))return!1;var n,o=_e.sounds[e];for(o.stop(),o._iO={},o.unload(),n=0;n<_e.soundIDs.length;n++)if(_e.soundIDs[n]===e){_e.soundIDs.splice(n,1);break}return t||o.destruct(!0),delete _e.sounds[e],!0},this.load=function(e,t){return!!K(e)&&_e.sounds[e].load(t)},this.unload=function(e){return!!K(e)&&_e.sounds[e].unload()},this.onposition=this.onPosition=function(e,t,n,o){return!!K(e)&&_e.sounds[e].onposition(t,n,o)},this.clearOnPosition=function(e,t,n){return!!K(e)&&_e.sounds[e].clearOnPosition(t,n)},this.start=this.play=function(e,t){var n=null,o=t&&!(t instanceof Object);if(!Te||!_e.ok())return Q("soundManager.play(): "+U(Te?"notOK":"notReady")),!1;if(K(e,o))o&&(t={url:t});else{if(!o)return!1;o&&(t={url:t}),t&&t.url&&(_e._wD('soundManager.play(): Attempting to create "'+e+'"',1),t.id=e,n=_e.createSound(t).play())}return null===n&&(n=_e.sounds[e].play(t)),n},this.setPlaybackRate=function(e,t,n){return!!K(e)&&_e.sounds[e].setPlaybackRate(t,n)},this.setPosition=function(e,t){return!!K(e)&&_e.sounds[e].setPosition(t)},this.stop=function(e){return!!K(e)&&(_e._wD("soundManager.stop("+e+")",1),_e.sounds[e].stop())},this.stopAll=function(){var e;_e._wD("soundManager.stopAll()",1);for(e in _e.sounds)_e.sounds.hasOwnProperty(e)&&_e.sounds[e].stop()},this.pause=function(e){return!!K(e)&&_e.sounds[e].pause()},this.pauseAll=function(){var e;for(e=_e.soundIDs.length-1;0<=e;e--)_e.sounds[_e.soundIDs[e]].pause()},this.resume=function(e){return!!K(e)&&_e.sounds[e].resume()},this.resumeAll=function(){var e;for(e=_e.soundIDs.length-1;0<=e;e--)_e.sounds[_e.soundIDs[e]].resume()},this.togglePause=function(e){return!!K(e)&&_e.sounds[e].togglePause()},this.setPan=function(e,t){return!!K(e)&&_e.sounds[e].setPan(t)},this.setVolume=function(e,n){var o,i;if(e!==t&&!isNaN(e)&&n===t){for(o=0,i=_e.soundIDs.length;o<i;o++)_e.sounds[_e.soundIDs[o]].setVolume(e);return!1}return!!K(e)&&_e.sounds[e].setVolume(n)},this.mute=function(e){var t=0;if(e instanceof String&&(e=null),e)return!!K(e)&&(_e._wD('soundManager.mute(): Muting "'+e+'"'),_e.sounds[e].mute());for(_e._wD("soundManager.mute(): Muting all sounds"),t=_e.soundIDs.length-1;0<=t;t--)_e.sounds[_e.soundIDs[t]].mute();return _e.muted=!0},this.muteAll=function(){_e.mute()},this.unmute=function(e){if(e instanceof String&&(e=null),e)return!!K(e)&&(_e._wD('soundManager.unmute(): Unmuting "'+e+'"'),_e.sounds[e].unmute());for(_e._wD("soundManager.unmute(): Unmuting all sounds"),e=_e.soundIDs.length-1;0<=e;e--)_e.sounds[_e.soundIDs[e]].unmute();return _e.muted=!1,!0},this.unmuteAll=function(){_e.unmute()},this.toggleMute=function(e){return!!K(e)&&_e.sounds[e].toggleMute()},this.getMemoryUse=function(){var e=0;return ye&&8!==c&&(e=parseInt(ye._getMemoryUse(),10)),e},this.disable=function(n){var o;if(n===t&&(n=!1),Pe)return!1;for(Pe=!0,f("shutdown",1),o=_e.soundIDs.length-1;0<=o;o--)C(_e.sounds[_e.soundIDs[o]]);return C(_e),p(n),se.remove(e,"load",v),!0},this.canPlayMIME=function(e){var t;return _e.hasHTML5&&(t=ee({type:e})),!t&&Ne&&(t=e&&_e.ok()?!!(8<c&&e.match(ot)||e.match(_e.mimePattern)):null),t},this.canPlayURL=function(e){var t;return _e.hasHTML5&&(t=ee({url:e})),!t&&Ne&&(t=e&&_e.ok()?!!e.match(_e.filePattern):null),t},this.canPlayLink=function(e){return!(e.type===t||!e.type||!_e.canPlayMIME(e.type))||_e.canPlayURL(e.href)},this.getSoundById=function(e,t){if(!e)return null;var n=_e.sounds[e];return n||t||_e._wD('soundManager.getSoundById(): Sound "'+e+'" not found.',2),n},this.onready=function(t,n){if("function"!=typeof t)throw U("needFunction","onready");return Te&&_e._wD(U("queue","onready")),n||(n=e),y("onready",t,n),w(),!0},this.ontimeout=function(t,n){if("function"!=typeof t)throw U("needFunction","ontimeout");return Te&&_e._wD(U("queue","ontimeout")),n||(n=e),y("ontimeout",t,n),w({type:"ontimeout"}),!0},this._writeDebug=function(e,n){var o,i;return!!_e.setupOptions.debugMode&&(!!(Xe&&_e.useConsole&&(n&&"object"==typeof n?console.log(e,n):Ie[n]!==t?console[Ie[n]](e):console.log(e),_e.consoleOnly))||!!(o=r("soundmanager-debug"))&&(i=Me.createElement("div"),0==++Fe%2&&(i.className="sm2-alt"),n=n===t?0:parseInt(n,10),i.appendChild(Me.createTextNode(e)),n&&(2<=n&&(i.style.fontWeight="bold"),3===n&&(i.style.color="#ff3333")),o.insertBefore(i,o.firstChild),!0))},-1!==ve.indexOf("sm2-debug=alert")&&(this._writeDebug=function(t){e.alert(t)}),this._wD=this._writeDebug,this._debug=function(){var e,t;for(f("currentObj",1),e=0,t=_e.soundIDs.length;e<t;e++)_e.sounds[_e.soundIDs[e]]._debug()},this.reboot=function(t,n){_e.soundIDs.length&&_e._wD("Destroying "+_e.soundIDs.length+" SMSound object"+(1!==_e.soundIDs.length?"s":"")+"...");var o,i,a;for(o=_e.soundIDs.length-1;0<=o;o--)_e.sounds[_e.soundIDs[o]].destruct();if(ye)try{Ve&&(Ae=ye.innerHTML),He=ye.parentNode.removeChild(ye)}catch(e){f("badRemove",2)}if(Ae=He=Ne=ye=null,_e.enabled=I=Te=Ee=Re=De=Le=Pe=Be=_e.swfLoaded=!1,_e.soundIDs=[],_e.sounds={},je=0,me=!1,t)be=[];else for(o in be)if(be.hasOwnProperty(o))for(i=0,a=be[o].length;i<a;i++)be[o][i].fired=!1;return n||_e._wD("soundManager: Rebooting..."),_e.html5={usingFlash:null},_e.flash={},_e.html5Only=!1,_e.ignoreFlash=!1,e.setTimeout(function(){n||_e.beginDelayedInit()},20),_e},this.reset=function(){return f("reset"),_e.reboot(!0,!0)},this.getMoviePercent=function(){return ye&&"PercentLoaded"in ye?ye.PercentLoaded():null},this.beginDelayedInit=function(){Se=!0,S(),setTimeout(function(){return!Re&&(A(),P(),Re=!0)},20),M()},this.destruct=function(){_e._wD("soundManager.destruct()"),_e.disable(!0)},s=function(e){var n,o,i,a,s,r,l,u,d,p,_,g=this,y=!1,w=[],v=0,M=null;o=n=null,this.sID=this.id=e.id,this.url=e.url,this._iO=this.instanceOptions=this.options=m(e),this.pan=this.options.pan,this.volume=this.options.volume,this.isHTML5=!1,this._a=null,_=!this.url,this.id3={},this._debug=function(){_e._wD(g.id+": Merged options:",g.options)},this.load=function(e){var n,o=null;if(e!==t?g._iO=m(e,g.options):(e=g.options,g._iO=e,M&&M!==g.url&&(f("manURL"),g._iO.url=g.url,g.url=null)),g._iO.url||(g._iO.url=g.url),g._iO.url=X(g._iO.url),n=g.instanceOptions=g._iO,_e._wD(g.id+": load ("+n.url+")"),!n.url&&!g.url)return _e._wD(g.id+": load(): url is unassigned. Exiting.",2),g;if(g.isHTML5||8!==c||g.url||n.autoPlay||_e._wD(g.id+": Flash 8 load() limitation: Wait for onload() before calling play().",1),n.url===g.url&&0!==g.readyState&&2!==g.readyState)return f("onURL",1),3===g.readyState&&n.onload&&pe(g,function(){n.onload.apply(g,[!!g.duration])}),g;if(g.loaded=!1,g.readyState=1,g.playState=0,g.id3={},Y(n))o=g._setup_html5(n),o._called_load?_e._wD(g.id+": Ignoring request to load again"):(g._html5_canplay=!1,g.url!==n.url&&(_e._wD(f("manURL")+": "+n.url),g._a.src=n.url,g.setPosition(0)),g._a.autobuffer="auto",g._a.preload="auto",g._a._called_load=!0);else{if(_e.html5Only)return _e._wD(g.id+": No flash support. Exiting."),g;if(g._iO.url&&g._iO.url.match(/data:/i))return _e._wD(g.id+": data: URIs not supported via Flash. Exiting."),g;try{g.isHTML5=!1,g._iO=V(q(n)),g._iO.autoPlay&&(g._iO.position||g._iO.from)&&(_e._wD(g.id+": Disabling autoPlay because of non-zero offset case"),g._iO.autoPlay=!1),n=g._iO,8===c?ye._load(g.id,n.url,n.stream,n.autoPlay,n.usePolicyFile):ye._load(g.id,n.url,!!n.stream,!!n.autoPlay,n.loops||1,!!n.autoLoad,n.usePolicyFile)}catch(e){f("smError",2),h("onload",!1),E({type:"SMSOUND_LOAD_JS_EXCEPTION",fatal:!0})}}return g.url=n.url,g},this.unload=function(){return 0!==g.readyState&&(_e._wD(g.id+": unload()"),g.isHTML5?(r(),g._a&&(g._a.pause(),M=oe(g._a))):8===c?ye._unload(g.id,"about:blank"):ye._unload(g.id),i()),g},this.destruct=function(e){_e._wD(g.id+": Destruct"),g.isHTML5?(r(),g._a&&(g._a.pause(),oe(g._a),Be||s(),g._a._s=null,g._a=null)):(g._iO.onfailure=null,ye._destroySound(g.id)),e||_e.destroySound(g.id,!0)},this.start=this.play=function(e,n){var o,i,a,s,r;if(i=!0,o=g.id+": play(): ",n=n===t||n,e||(e={}),g.url&&(g._iO.url=g.url),g._iO=m(g._iO,g.options),g._iO=m(e,g._iO),g._iO.url=X(g._iO.url),g.instanceOptions=g._iO,!g.isHTML5&&g._iO.serverURL&&!g.connected)return g.getAutoPlay()||(_e._wD(o+" Netstream not connected yet - setting autoPlay"),g.setAutoPlay(!0)),g;if(Y(g._iO)&&(g._setup_html5(g._iO),l()),1===g.playState&&!g.paused){if(!(i=g._iO.multiShot))return _e._wD(o+"Already playing (one-shot)",1),g.isHTML5&&g.setPosition(g._iO.position),g;_e._wD(o+"Already playing (multi-shot)",1)}if(e.url&&e.url!==g.url&&(g.readyState||g.isHTML5||8!==c||!_?g.load(g._iO):_=!1),g.loaded)_e._wD(o.substr(0,o.lastIndexOf(":")));else if(0===g.readyState){if(_e._wD(o+"Attempting to load"),g.isHTML5||_e.html5Only){if(!g.isHTML5)return _e._wD(o+"Unsupported type. Exiting."),g;g.load(g._iO)}else g._iO.autoPlay=!0,g.load(g._iO);g.instanceOptions=g._iO}else{if(2===g.readyState)return _e._wD(o+"Could not load - exiting",2),g;_e._wD(o+"Loading - attempting to play...")}return!g.isHTML5&&9===c&&0<g.position&&g.position===g.duration&&(_e._wD(o+"Sound at end, resetting to position: 0"),e.position=0),g.paused&&0<=g.position&&(!g._iO.serverURL||0<g.position)?(_e._wD(o+"Resuming from paused state",1),g.resume()):(g._iO=m(e,g._iO),(!g.isHTML5&&null!==g._iO.position&&0<g._iO.position||null!==g._iO.from&&0<g._iO.from||null!==g._iO.to)&&0===g.instanceCount&&0===g.playState&&!g._iO.serverURL&&(i=function(){g._iO=m(e,g._iO),g.play(g._iO)},g.isHTML5&&!g._html5_canplay?(_e._wD(o+"Beginning load for non-zero offset case"),g.load({_oncanplay:i})):g.isHTML5||g.loaded||g.readyState&&2===g.readyState||(_e._wD(o+"Preloading for non-zero offset case"),g.load({onload:i})),g._iO=p()),(!g.instanceCount||g._iO.multiShotEvents||g.isHTML5&&g._iO.multiShot&&!Be||!g.isHTML5&&8<c&&!g.getAutoPlay())&&g.instanceCount++,g._iO.onposition&&0===g.playState&&u(g),g.playState=1,g.paused=!1,g.position=g._iO.position===t||isNaN(g._iO.position)?0:g._iO.position,g.isHTML5||(g._iO=V(q(g._iO))),g._iO.onplay&&n&&(g._iO.onplay.apply(g),y=!0),g.setVolume(g._iO.volume,!0),g.setPan(g._iO.pan,!0),1!==g._iO.playbackRate&&g.setPlaybackRate(g._iO.playbackRate),g.isHTML5?2>g.instanceCount?(l(),o=g._setup_html5(),g.setPosition(g._iO.position),o.play()):(_e._wD(g.id+": Cloning Audio() for instance #"+g.instanceCount+"..."),a=new Audio(g._iO.url),s=function(){se.remove(a,"ended",s),g._onfinish(g),oe(a),a=null},r=function(){se.remove(a,"canplay",r);try{a.currentTime=g._iO.position/1e3}catch(e){Q(g.id+": multiShot play() failed to apply position of "+g._iO.position/1e3)}a.play()},se.add(a,"ended",s),g._iO.volume!==t&&(a.volume=Math.max(0,Math.min(1,g._iO.volume/100))),g.muted&&(a.muted=!0),g._iO.position?se.add(a,"canplay",r):a.play()):(i=ye._start(g.id,g._iO.loops||1,9===c?g.position:g.position/1e3,g._iO.multiShot||!1),9!==c||i||(_e._wD(o+"No sound hardware, or 32-sound ceiling hit",2),g._iO.onplayerror&&g._iO.onplayerror.apply(g)))),g},this.stop=function(e){var t=g._iO;return 1===g.playState&&(_e._wD(g.id+": stop()"),g._onbufferchange(0),g._resetOnPosition(0),g.paused=!1,g.isHTML5||(g.playState=0),d(),t.to&&g.clearOnPosition(t.to),g.isHTML5?g._a&&(e=g.position,g.setPosition(0),g.position=e,g._a.pause(),g.playState=0,g._onTimer(),r()):(ye._stop(g.id,e),t.serverURL&&g.unload()),g.instanceCount=0,g._iO={},t.onstop&&t.onstop.apply(g)),g},this.setAutoPlay=function(e){_e._wD(g.id+": Autoplay turned "+(e?"on":"off")),g._iO.autoPlay=e,g.isHTML5||(ye._setAutoPlay(g.id,e),e&&!g.instanceCount&&1===g.readyState&&(g.instanceCount++,_e._wD(g.id+": Incremented instance count to "+g.instanceCount)))},this.getAutoPlay=function(){return g._iO.autoPlay},this.setPlaybackRate=function(e){var t=Math.max(.5,Math.min(4,e));if(t!==e&&_e._wD(g.id+": setPlaybackRate("+e+"): limiting rate to "+t,2),g.isHTML5)try{g._iO.playbackRate=t,g._a.playbackRate=t}catch(e){_e._wD(g.id+": setPlaybackRate("+t+") failed: "+e.message,2)}return g},this.setPosition=function(e){e===t&&(e=0);var n=g.isHTML5?Math.max(e,0):Math.min(g.duration||g._iO.duration,Math.max(e,0));if(g.position=n,e=g.position/1e3,g._resetOnPosition(g.position),g._iO.position=n,g.isHTML5){if(g._a){if(g._html5_canplay){if(g._a.currentTime.toFixed(3)!==e.toFixed(3)){_e._wD(g.id+": setPosition("+e+")");try{g._a.currentTime=e,(0===g.playState||g.paused)&&g._a.pause()}catch(t){_e._wD(g.id+": setPosition("+e+") failed: "+t.message,2)}}}else if(e)return _e._wD(g.id+": setPosition("+e+"): Cannot seek yet, sound not ready",2),g;g.paused&&g._onTimer(!0)}}else e=9===c?g.position:e,g.readyState&&2!==g.readyState&&ye._setPosition(g.id,e,g.paused||!g.playState,g._iO.multiShot);return g},this.pause=function(e){return g.paused||0===g.playState&&1!==g.readyState?g:(_e._wD(g.id+": pause()"),g.paused=!0,g.isHTML5?(g._setup_html5().pause(),r()):(e||e===t)&&ye._pause(g.id,g._iO.multiShot),g._iO.onpause&&g._iO.onpause.apply(g),g)},this.resume=function(){var e=g._iO;return g.paused?(_e._wD(g.id+": resume()"),g.paused=!1,g.playState=1,g.isHTML5?(g._setup_html5().play(),l()):(e.isMovieStar&&!e.serverURL&&g.setPosition(g.position),ye._pause(g.id,e.multiShot)),!y&&e.onplay?(e.onplay.apply(g),y=!0):e.onresume&&e.onresume.apply(g),g):g},this.togglePause=function(){return _e._wD(g.id+": togglePause()"),0===g.playState?(g.play({position:9!==c||g.isHTML5?g.position/1e3:g.position}),g):(g.paused?g.resume():g.pause(),g)},this.setPan=function(e,n){return e===t&&(e=0),n===t&&(n=!1),g.isHTML5||ye._setPan(g.id,e),g._iO.pan=e,n||(g.pan=e,g.options.pan=e),g},this.setVolume=function(e,n){return e===t&&(e=100),n===t&&(n=!1),g.isHTML5?g._a&&(_e.muted&&!g.muted&&(g.muted=!0,g._a.muted=!0),g._a.volume=Math.max(0,Math.min(1,e/100))):ye._setVolume(g.id,_e.muted&&!g.muted||g.muted?0:e),g._iO.volume=e,n||(g.volume=e,g.options.volume=e),g},this.mute=function(){return g.muted=!0,g.isHTML5?g._a&&(g._a.muted=!0):ye._setVolume(g.id,0),g},this.unmute=function(){g.muted=!1;var e=g._iO.volume!==t;return g.isHTML5?g._a&&(g._a.muted=!1):ye._setVolume(g.id,e?g._iO.volume:g.options.volume),g},this.toggleMute=function(){return g.muted?g.unmute():g.mute()},this.onposition=this.onPosition=function(e,n,o){return w.push({position:parseInt(e,10),method:n,scope:o!==t?o:g,fired:!1}),g},this.clearOnPosition=function(e,t){var n;if(e=parseInt(e,10),!isNaN(e))for(n=0;n<w.length;n++)e!==w[n].position||t&&t!==w[n].method||(w[n].fired&&v--,w.splice(n,1))},this._processOnPosition=function(){var e,t;if(!(e=w.length)||!g.playState||v>=e)return!1;for(--e;0<=e;e--)!(t=w[e]).fired&&g.position>=t.position&&(t.fired=!0,v++,t.method.apply(t.scope,[t.position]));return!0},this._resetOnPosition=function(e){var t,n;if(!(t=w.length))return!1;for(--t;0<=t;t--)(n=w[t]).fired&&e<=n.position&&(n.fired=!1,v--);return!0},p=function(){var e,t,n=g._iO,o=n.from,i=n.to;return t=function(){_e._wD(g.id+': "To" time of '+i+" reached."),g.clearOnPosition(i,t),g.stop()},e=function(){_e._wD(g.id+': Playing "from" '+o),null===i||isNaN(i)||g.onPosition(i,t)},null===o||isNaN(o)||(n.position=o,n.multiShot=!1,e()),n},u=function(){var e,t=g._iO.onposition;if(t)for(e in t)t.hasOwnProperty(e)&&g.onPosition(parseInt(e,10),t[e])},d=function(){var e,t=g._iO.onposition;if(t)for(e in t)t.hasOwnProperty(e)&&g.clearOnPosition(parseInt(e,10))},l=function(){g.isHTML5&&$(g)},r=function(){g.isHTML5&&G(g)},(i=function(e){e||(w=[],v=0),y=!1,g._hasTimer=null,g._a=null,g._html5_canplay=!1,g.bytesLoaded=null,g.bytesTotal=null,g.duration=g._iO&&g._iO.duration?g._iO.duration:null,g.durationEstimate=null,g.buffered=[],g.eqData=[],g.eqData.left=[],g.eqData.right=[],g.failures=0,g.isBuffering=!1,g.instanceOptions={},g.instanceCount=0,g.loaded=!1,g.metadata={},g.readyState=0,g.muted=!1,g.paused=!1,g.peakData={left:0,right:0},g.waveformData={left:[],right:[]},g.playState=0,g.position=null,g.id3={}})(),this._onTimer=function(e){var t,i=!1,a={};return(g._hasTimer||e)&&g._a&&(e||(0<g.playState||1===g.readyState)&&!g.paused)&&((t=g._get_html5_duration())!==n&&(n=t,g.duration=t,i=!0),g.durationEstimate=g.duration,(t=1e3*g._a.currentTime||0)!==o&&(o=t,i=!0),(i||e)&&g._whileplaying(t,a,a,a,a)),i},this._get_html5_duration=function(){var e=g._iO;return(e=g._a&&g._a.duration?1e3*g._a.duration:e&&e.duration?e.duration:null)&&!isNaN(e)&&1/0!==e?e:null},this._apply_loop=function(e,t){!e.loop&&1<t&&_e._wD("Note: Native HTML5 looping is infinite.",1),e.loop=1<t?"loop":""},this._setup_html5=function(e){e=m(g._iO,e);var t,n=Be?ge:g._a,o=decodeURI(e.url);if(Be?o===decodeURI(re)&&(t=!0):o===decodeURI(M)&&(t=!0),n){if(n._s)if(Be)n._s&&n._s.playState&&!t&&n._s.stop();else if(!Be&&o===decodeURI(M))return g._apply_loop(n,e.loops),n;t||(M&&i(!1),n.src=e.url,re=M=g.url=e.url,n._called_load=!1)}else e.autoLoad||e.autoPlay?(g._a=new Audio(e.url),g._a.load()):g._a=$e&&10>opera.version()?new Audio(null):new Audio,n=g._a,n._called_load=!1,Be&&(ge=n);return g.isHTML5=!0,g._a=n,n._s=g,a(),g._apply_loop(n,e.loops),e.autoLoad||e.autoPlay?g.load():(n.autobuffer=!1,n.preload="auto"),n},a=function(){if(g._a._added_events)return!1;var e;g._a._added_events=!0;for(e in ce)ce.hasOwnProperty(e)&&g._a&&g._a.addEventListener(e,ce[e],!1);return!0},s=function(){var e;_e._wD(g.id+": Removing event listeners"),g._a._added_events=!1;for(e in ce)ce.hasOwnProperty(e)&&g._a&&g._a.removeEventListener(e,ce[e],!1)},this._onload=function(e){var t=!!e||!g.isHTML5&&8===c&&g.duration;return e=g.id+": ",_e._wD(e+(t?"onload()":"Failed to load / invalid sound?"+(g.duration?" -":" Zero-length duration reported.")+" ("+g.url+")"),t?1:2),t||g.isHTML5||(!0===_e.sandbox.noRemote&&_e._wD(e+U("noNet"),1),!0===_e.sandbox.noLocal&&_e._wD(e+U("noLocal"),1)),g.loaded=t,g.readyState=t?3:2,g._onbufferchange(0),t||g.isHTML5||g._onerror(),g._iO.onload&&pe(g,function(){g._iO.onload.apply(g,[t])}),!0},this._onerror=function(e,t){g._iO.onerror&&pe(g,function(){g._iO.onerror.apply(g,[e,t])})},this._onbufferchange=function(e){return!(0===g.playState||e&&g.isBuffering||!e&&!g.isBuffering)&&(g.isBuffering=1===e,g._iO.onbufferchange&&(_e._wD(g.id+": Buffer state change: "+e),g._iO.onbufferchange.apply(g,[e])),!0)},this._onsuspend=function(){return g._iO.onsuspend&&(_e._wD(g.id+": Playback suspended"),g._iO.onsuspend.apply(g)),!0},this._onfailure=function(e,t,n){g.failures++,_e._wD(g.id+": Failure ("+g.failures+"): "+e),g._iO.onfailure&&1===g.failures?g._iO.onfailure(e,t,n):_e._wD(g.id+": Ignoring failure")},this._onwarning=function(e,t,n){g._iO.onwarning&&g._iO.onwarning(e,t,n)},this._onfinish=function(){var e=g._iO.onfinish;g._onbufferchange(0),g._resetOnPosition(0),g.instanceCount&&(--g.instanceCount||(d(),g.playState=0,g.paused=!1,g.instanceCount=0,g.instanceOptions={},g._iO={},r(),g.isHTML5&&(g.position=0)),g.instanceCount&&!g._iO.multiShotEvents||!e||(_e._wD(g.id+": onfinish()"),pe(g,function(){e.apply(g)})))},this._whileloading=function(e,t,n,o){var i=g._iO;g.bytesLoaded=e,g.bytesTotal=t,g.duration=Math.floor(n),g.bufferLength=o,g.durationEstimate=g.isHTML5||i.isMovieStar?g.duration:i.duration?g.duration>i.duration?g.duration:i.duration:parseInt(g.bytesTotal/g.bytesLoaded*g.duration,10),g.isHTML5||(g.buffered=[{start:0,end:g.duration}]),(3!==g.readyState||g.isHTML5)&&i.whileloading&&i.whileloading.apply(g)},this._whileplaying=function(e,n,o,i,a){var s=g._iO;return!isNaN(e)&&null!==e&&(g.position=Math.max(0,e),g._processOnPosition(),!g.isHTML5&&8<c&&(s.usePeakData&&n!==t&&n&&(g.peakData={left:n.leftPeak,right:n.rightPeak}),s.useWaveformData&&o!==t&&o&&(g.waveformData={left:o.split(","),right:i.split(",")}),s.useEQData&&a!==t&&a&&a.leftEQ&&(e=a.leftEQ.split(","),g.eqData=e,g.eqData.left=e,a.rightEQ!==t&&a.rightEQ&&(g.eqData.right=a.rightEQ.split(",")))),1===g.playState&&(g.isHTML5||8!==c||g.position||!g.isBuffering||g._onbufferchange(0),s.whileplaying&&s.whileplaying.apply(g)),!0)},this._oncaptiondata=function(e){_e._wD(g.id+": Caption data received."),g.captiondata=e,g._iO.oncaptiondata&&g._iO.oncaptiondata.apply(g,[e])},this._onmetadata=function(e,t){_e._wD(g.id+": Metadata received.");var n,o,i={};for(n=0,o=e.length;n<o;n++)i[e[n]]=t[n];g.metadata=i,g._iO.onmetadata&&g._iO.onmetadata.call(g,g.metadata)},this._onid3=function(e,t){_e._wD(g.id+": ID3 data received.");var n,o,i=[];for(n=0,o=e.length;n<o;n++)i[e[n]]=t[n];g.id3=m(g.id3,i),g._iO.onid3&&g._iO.onid3.apply(g)},this._onconnect=function(e){e=1===e,_e._wD(g.id+": "+(e?"Connected.":"Failed to connect? - "+g.url),e?1:2),(g.connected=e)&&(g.failures=0,K(g.id)&&(g.getAutoPlay()?g.play(t,g.getAutoPlay()):g._iO.autoLoad&&g.load()),g._iO.onconnect&&g._iO.onconnect.apply(g,[e]))},this._ondataerror=function(e){0<g.playState&&(_e._wD(g.id+": Data error: "+e),g._iO.ondataerror&&g._iO.ondataerror.apply(g))},this._debug()},H=function(){return Me.body||Me.getElementsByTagName("div")[0]},r=function(e){return Me.getElementById(e)},m=function(e,n){var o,i,a=e||{};o=n===t?_e.defaultOptions:n;for(i in o)o.hasOwnProperty(i)&&a[i]===t&&(a[i]="object"!=typeof o[i]||null===o[i]?o[i]:m(a[i],o[i]));return a},pe=function(t,n){t.isHTML5||8!==c?n():e.setTimeout(n,0)},g={onready:1,ontimeout:1,defaultOptions:1,flash9Options:1,movieStarOptions:1},_=function(e,n){var o,i=!0,a=n!==t,s=_e.setupOptions;if(e===t){i=[];for(o in s)s.hasOwnProperty(o)&&i.push(o);for(o in g)g.hasOwnProperty(o)&&("object"==typeof _e[o]?i.push(o+": {...}"):_e[o]instanceof Function?i.push(o+": function() {...}"):i.push(o));return _e._wD(U("setup",i.join(", "))),!1}for(o in e)if(e.hasOwnProperty(o))if("object"!=typeof e[o]||null===e[o]||e[o]instanceof Array||e[o]instanceof RegExp)a&&g[n]!==t?_e[n][o]=e[o]:s[o]!==t?(_e.setupOptions[o]=e[o],_e[o]=e[o]):g[o]===t?(Q(U(_e[o]===t?"setupUndef":"setupError",o),2),i=!1):_e[o]instanceof Function?_e[o].apply(_e,e[o]instanceof Array?e[o]:[e[o]]):_e[o]=e[o];else{if(g[o]!==t)return _(e[o],o);Q(U(_e[o]===t?"setupUndef":"setupError",o),2),i=!1}return i},se=function(){function t(e){var t=(e=Ue.call(e)).length;return o?(e[1]="on"+e[1],3<t&&e.pop()):3===t&&e.push(!1),e}function n(e,t){var n=e.shift(),a=[i[t]];o?n[a](e[0],e[1]):n[a].apply(n,e)}var o=e.attachEvent,i={add:o?"attachEvent":"addEventListener",remove:o?"detachEvent":"removeEventListener"};return{add:function(){n(t(arguments),"add")},remove:function(){n(t(arguments),"remove")}}}(),ce={abort:a(function(){_e._wD(this._s.id+": abort")}),canplay:a(function(){var e,n=this._s;if(!n._html5_canplay){if(n._html5_canplay=!0,_e._wD(n.id+": canplay"),n._onbufferchange(0),e=n._iO.position===t||isNaN(n._iO.position)?null:n._iO.position/1e3,this.currentTime!==e){_e._wD(n.id+": canplay: Setting position to "+e);try{this.currentTime=e}catch(t){_e._wD(n.id+": canplay: Setting position of "+e+" failed: "+t.message,2)}}n._iO._oncanplay&&n._iO._oncanplay()}}),canplaythrough:a(function(){var e=this._s;e.loaded||(e._onbufferchange(0),e._whileloading(e.bytesLoaded,e.bytesTotal,e._get_html5_duration()),e._onload(!0))}),durationchange:a(function(){var e,t=this._s;e=t._get_html5_duration(),isNaN(e)||e===t.duration||(_e._wD(this._s.id+": durationchange ("+e+")"+(t.duration?", previously "+t.duration:"")),t.durationEstimate=t.duration=e)}),ended:a(function(){var e=this._s;_e._wD(e.id+": ended"),e._onfinish()}),error:a(function(){var e=te[this.error.code]||null;_e._wD(this._s.id+": HTML5 error, code "+this.error.code+(e?" ("+e+")":"")),this._s._onload(!1),this._s._onerror(this.error.code,e)}),loadeddata:a(function(){var e=this._s;_e._wD(e.id+": loadeddata"),e._loaded||Ke||(e.duration=e._get_html5_duration())}),loadedmetadata:a(function(){_e._wD(this._s.id+": loadedmetadata")}),loadstart:a(function(){_e._wD(this._s.id+": loadstart"),this._s._onbufferchange(1)}),play:a(function(){this._s._onbufferchange(0)}),playing:a(function(){_e._wD(this._s.id+": playing "+String.fromCharCode(9835)),this._s._onbufferchange(0)}),progress:a(function(e){var t,n,o,i=this._s;t=0;var a="progress"===e.type,s=e.target.buffered,r=e.loaded||0,l=e.total||1;if(i.buffered=[],s&&s.length){for(t=0,n=s.length;t<n;t++)i.buffered.push({start:1e3*s.start(t),end:1e3*s.end(t)});if(t=1e3*(s.end(0)-s.start(0)),r=Math.min(1,t/(1e3*e.target.duration)),a&&1<s.length){for(o=[],n=s.length,t=0;t<n;t++)o.push(1e3*e.target.buffered.start(t)+"-"+1e3*e.target.buffered.end(t));_e._wD(this._s.id+": progress, timeRanges: "+o.join(", "))}a&&!isNaN(r)&&_e._wD(this._s.id+": progress, "+Math.floor(100*r)+"% loaded")}isNaN(r)||(i._whileloading(r,l,i._get_html5_duration()),r&&l&&r===l&&ce.canplaythrough.call(this,e))}),ratechange:a(function(){_e._wD(this._s.id+": ratechange")}),suspend:a(function(e){var t=this._s;_e._wD(this._s.id+": suspend"),ce.progress.call(this,e),t._onsuspend()}),stalled:a(function(){_e._wD(this._s.id+": stalled")}),timeupdate:a(function(){this._s._onTimer()}),waiting:a(function(){var e=this._s;_e._wD(this._s.id+": waiting"),e._onbufferchange(1)})},Y=function(e){return!(!e||!(e.type||e.url||e.serverURL))&&(!(e.serverURL||e.type&&i(e.type))&&(e.type?ee({type:e.type}):ee({url:e.url})||_e.html5Only||e.url.match(/data:/i)))},oe=function(e){var n;return e&&(n=Ke?"about:blank":_e.html5.canPlayType("audio/wav")?"data:audio/wave;base64,/UklGRiYAAABXQVZFZm10IBAAAAABAAEARKwAAIhYAQACABAAZGF0YQIAAAD//w==":"about:blank",e.src=n,e._called_unload!==t&&(e._called_load=!1)),Be&&(re=null),n},ee=function(e){if(!_e.useHTML5Audio||!_e.hasHTML5)return!1;var n=e.url||null;e=e.type||null;var o,a=_e.audioFormats;if(e&&_e.html5[e]!==t)return _e.html5[e]&&!i(e);if(!ne){ne=[];for(o in a)a.hasOwnProperty(o)&&(ne.push(o),a[o].related&&(ne=ne.concat(a[o].related)));ne=new RegExp("\\.("+ne.join("|")+")(\\?.*)?$","i")}return(o=n?n.toLowerCase().match(ne):null)&&o.length?o=o[1]:e&&(n=e.indexOf(";"),o=(-1!==n?e.substr(0,n):e).substr(6)),o&&_e.html5[o]!==t?n=_e.html5[o]&&!i(o):(e="audio/"+o,n=_e.html5.canPlayType({type:e}),n=(_e.html5[o]=n)&&_e.html5[e]&&!i(e)),n},ae=function(){function e(e){var t,n=t=!1;if(!s||"function"!=typeof s.canPlayType)return t;if(e instanceof Array){for(a=0,t=e.length;a<t;a++)(_e.html5[e[a]]||s.canPlayType(e[a]).match(_e.html5Test))&&(n=!0,_e.html5[e[a]]=!0,_e.flash[e[a]]=!!e[a].match(et));t=n}else e=!(!s||"function"!=typeof s.canPlayType)&&s.canPlayType(e),t=!(!e||!e.match(_e.html5Test));return t}if(!_e.useHTML5Audio||!_e.hasHTML5)return Ne=_e.html5.usingFlash=!0,!1;var n,o,i,a,s=Audio!==t?$e&&10>opera.version()?new Audio(null):new Audio:null,r={};i=_e.audioFormats;for(n in i)if(i.hasOwnProperty(n)&&(o="audio/"+n,r[n]=e(i[n].type),r[o]=r[n],n.match(et)?(_e.flash[n]=!0,_e.flash[o]=!0):(_e.flash[n]=!1,_e.flash[o]=!1),i[n]&&i[n].related))for(a=i[n].related.length-1;0<=a;a--)r["audio/"+i[n].related[a]]=r[n],_e.html5[i[n].related[a]]=r[n],_e.flash[i[n].related[a]]=r[n];return r.canPlayType=s?e:null,_e.html5=m(_e.html5,r),_e.html5.usingFlash=Z(),Ne=_e.html5.usingFlash,!0},T={notReady:"Unavailable - wait until onready() has fired.",notOK:"Audio support is not available.",domError:"soundManagerexception caught while appending SWF to DOM.",spcWmode:"Removing wmode, preventing known SWF loading issue(s)",swf404:"soundManager: Verify that %s is a valid path.",tryDebug:"Try soundManager.debugFlash = true for more security details (output goes to SWF.)",checkSWF:"See SWF output for more debug info.",localFail:"soundManager: Non-HTTP page ("+Me.location.protocol+" URL?) Review Flash player security settings for this special case:\nhttp://www.macromedia.com/support/documentation/en/flashplayer/help/settings_manager04.html\nMay need to add/allow path, eg. c:/sm2/ or /users/me/sm2/",waitFocus:"soundManager: Special case: Waiting for SWF to load with window focus...",waitForever:"soundManager: Waiting indefinitely for Flash (will recover if unblocked)...",waitSWF:"soundManager: Waiting for 100% SWF load...",needFunction:"soundManager: Function object expected for %s",badID:'Sound ID "%s" should be a string, starting with a non-numeric character',currentObj:"soundManager: _debug(): Current sound objects",waitOnload:"soundManager: Waiting for window.onload()",docLoaded:"soundManager: Document already loaded",onload:"soundManager: initComplete(): calling soundManager.onload()",onloadOK:"soundManager.onload() complete",didInit:"soundManager: init(): Already called?",secNote:"Flash security note: Network/internet URLs will not load due to security restrictions. Access can be configured via Flash Player Global Security Settings Page: http://www.macromedia.com/support/documentation/en/flashplayer/help/settings_manager04.html",badRemove:"soundManager: Failed to remove Flash node.",shutdown:"soundManager.disable(): Shutting down",queue:"soundManager: Queueing %s handler",smError:"SMSound.load(): Exception: JS-Flash communication failed, or JS error.",fbTimeout:"No flash response, applying .swf_timedout CSS...",fbLoaded:"Flash loaded",fbHandler:"soundManager: flashBlockHandler()",manURL:"SMSound.load(): Using manually-assigned URL",onURL:"soundManager.load(): current URL already assigned.",badFV:'soundManager.flashVersion must be 8 or 9. "%s" is invalid. Reverting to %s.',as2loop:"Note: Setting stream:false so looping can work (flash 8 limitation)",noNSLoop:"Note: Looping not implemented for MovieStar formats",needfl9:"Note: Switching to flash 9, required for MP4 formats.",mfTimeout:"Setting flashLoadTimeout = 0 (infinite) for off-screen, mobile flash case",needFlash:"soundManager: Fatal error: Flash is needed to play some required formats, but is not available.",gotFocus:"soundManager: Got window focus.",policy:"Enabling usePolicyFile for data access",setup:"soundManager.setup(): allowed parameters: %s",setupError:'soundManager.setup(): "%s" cannot be assigned with this method.',setupUndef:'soundManager.setup(): Could not find option "%s"',setupLate:"soundManager.setup(): url, flashVersion and html5Test property changes will not take effect until reboot().",noURL:"soundManager: Flash URL required. Call soundManager.setup({url:...}) to get started.",sm2Loaded:"SoundManager 2: Ready. "+String.fromCharCode(10003),reset:"soundManager.reset(): Removing event callbacks",mobileUA:"Mobile UA detected, preferring HTML5 by default.",globalHTML5:"Using singleton HTML5 Audio() pattern for this device.",ignoreMobile:"Ignoring mobile restrictions for this device."},U=function(){var e,t,n,o;if(e=Ue.call(arguments),t=e.shift(),(o=T&&T[t]?T[t]:"")&&e&&e.length)for(t=0,n=e.length;t<n;t++)o=o.replace("%s",e[t]);return o},q=function(e){return 8===c&&1<e.loops&&e.stream&&(f("as2loop"),e.stream=!1),e},V=function(e,t){return e&&!e.usePolicyFile&&(e.onid3||e.usePeakData||e.useWaveformData||e.useEQData)&&(_e._wD((t||"")+U("policy")),e.usePolicyFile=!0),e},Q=function(e){Xe&&console.warn!==t?console.warn(e):_e._wD(e)},l=function(){return!1},C=function(e){for(var t in e)e.hasOwnProperty(t)&&"function"==typeof e[t]&&(e[t]=l)},x=function(e){e===t&&(e=!1),(Pe||e)&&_e.disable(e)},N=function(e){if(e)if(e.match(/\.swf(\?.*)?$/i)){if(e.substr(e.toLowerCase().lastIndexOf(".swf?")+4))return e}else e.lastIndexOf("/")!==e.length-1&&(e+="/");return e=(e&&-1!==e.lastIndexOf("/")?e.substr(0,e.lastIndexOf("/")+1):"./")+_e.movieURL,_e.noSWFCache&&(e+="?ts="+(new Date).getTime()),e},D=function(){8!==(c=parseInt(_e.flashVersion,10))&&9!==c&&(_e._wD(U("badFV",c,8)),_e.flashVersion=c=8);var e=_e.debugMode||_e.debugFlash?"_debug.swf":".swf";_e.useHTML5Audio&&!_e.html5Only&&_e.audioFormats.mp4.required&&9>c&&(_e._wD(U("needfl9")),_e.flashVersion=c=9),_e.version=_e.versionNumber+(_e.html5Only?" (HTML5-only mode)":9===c?" (AS3/Flash 9)":" (AS2/Flash 8)"),8<c?(_e.defaultOptions=m(_e.defaultOptions,_e.flash9Options),_e.features.buffering=!0,_e.defaultOptions=m(_e.defaultOptions,_e.movieStarOptions),_e.filePatterns.flash9=new RegExp("\\.(mp3|"+it.join("|")+")(\\?.*)?$","i"),_e.features.movieStar=!0):_e.features.movieStar=!1,_e.filePattern=_e.filePatterns[8!==c?"flash9":"flash8"],_e.movieURL=(8===c?"soundmanager2.swf":"soundmanager2_flash9.swf").replace(".swf",e),_e.features.peakData=_e.features.waveformData=_e.features.eqData=8<c},R=function(e,t){ye&&ye._setPolling(e,t)},k=function(){if(_e.debugURLParam.test(ve)&&(_e.setupOptions.debugMode=_e.debugMode=!0),!r(_e.debugID)){var e,t,n,o;if(!(!_e.debugMode||r(_e.debugID)||Xe&&_e.useConsole&&_e.consoleOnly)){(e=Me.createElement("div")).id=_e.debugID+"-toggle",t={position:"fixed",bottom:"0px",right:"0px",width:"1.2em",height:"1.2em",lineHeight:"1.2em",margin:"2px",textAlign:"center",border:"1px solid #999",cursor:"pointer",background:"#fff",color:"#333",zIndex:10001},e.appendChild(Me.createTextNode("-")),e.onclick=W,e.title="Toggle SM2 debug console",we.match(/msie 6/i)&&(e.style.position="absolute",e.style.cursor="hand");for(o in t)t.hasOwnProperty(o)&&(e.style[o]=t[o]);if(t=Me.createElement("div"),t.id=_e.debugID,t.style.display=_e.debugMode?"block":"none",_e.debugMode&&!r(e.id)){try{(n=H()).appendChild(e)}catch(e){throw Error(U("domError")+" \n"+e.toString())}n.appendChild(t)}}}},K=this.getSoundById,f=function(e,t){return e?_e._wD(U(e),t):""},W=function(){var e=r(_e.debugID),t=r(_e.debugID+"-toggle");e&&(Oe?(t.innerHTML="+",e.style.display="none"):(t.innerHTML="-",e.style.display="block"),Oe=!Oe)},h=function(n,o,i){if(e.sm2Debugger!==t)try{sm2Debugger.handleEvent(n,o,i)}catch(e){return!1}return!0},j=function(){var e=[];return _e.debugMode&&e.push("sm2_debug"),_e.debugFlash&&e.push("flash_debug"),_e.useHighPerformance&&e.push("high_performance"),e.join(" ")},B=function(){var e=U("fbHandler"),t=_e.getMoviePercent(),n={type:"FLASHBLOCK"};_e.html5Only||(_e.ok()?(_e.didFlashBlock&&_e._wD(e+": Unblocked"),_e.oMC&&(_e.oMC.className=[j(),"movieContainer","swf_loaded"+(_e.didFlashBlock?" swf_unblocked":"")].join(" "))):(Ne&&(_e.oMC.className=j()+" movieContainer "+(null===t?"swf_timedout":"swf_error"),_e._wD(e+": "+U("fbTimeout")+(t?" ("+U("fbLoaded")+")":""))),_e.didFlashBlock=!0,w({type:"ontimeout",ignoreInit:!0,error:n}),E(n)))},y=function(e,n,o){be[e]===t&&(be[e]=[]),be[e].push({method:n,scope:o||null,fired:!1})},w=function(e){if(e||(e={type:_e.ok()?"onready":"ontimeout"}),!Te&&e&&!e.ignoreInit||"ontimeout"===e.type&&(_e.ok()||Pe&&!e.ignoreInit))return!1;var t,n={success:e&&e.ignoreInit?_e.ok():!Pe},o=e&&e.type?be[e.type]||[]:[],i=[],n=[n],a=Ne&&!_e.ok();for(e.error&&(n[0].error=e.error),e=0,t=o.length;e<t;e++)!0!==o[e].fired&&i.push(o[e]);if(i.length)for(e=0,t=i.length;e<t;e++)i[e].scope?i[e].method.apply(i[e].scope,n):i[e].method.apply(this,n),a||(i[e].fired=!0);return!0},v=function(){e.setTimeout(function(){_e.useFlashBlock&&B(),w(),"function"==typeof _e.onload&&(f("onload",1),_e.onload.apply(e),f("onloadOK",1)),_e.waitForWindowLoad&&se.add(e,"load",v)},1)},ue=function(){if(le!==t)return le;var n,o,i=!1,a=navigator,s=e.ActiveXObject;try{o=a.plugins}catch(e){o=void 0}if(o&&o.length)(a=a.mimeTypes)&&a["application/x-shockwave-flash"]&&a["application/x-shockwave-flash"].enabledPlugin&&a["application/x-shockwave-flash"].enabledPlugin.description&&(i=!0);else if(s!==t&&!we.match(/MSAppHost/i)){try{n=new s("ShockwaveFlash.ShockwaveFlash")}catch(e){n=null}i=!!n}return le=i},Z=function(){var e,t,n=_e.audioFormats;if(We&&we.match(/os (1|2|3_0|3_1)\s/i)?(_e.hasHTML5=!1,_e.html5Only=!0,_e.oMC&&(_e.oMC.style.display="none")):_e.useHTML5Audio&&(_e.html5&&_e.html5.canPlayType||(_e._wD("SoundManager: No HTML5 Audio() support detected."),_e.hasHTML5=!1),Je&&_e._wD("soundManager: Note: Buggy HTML5 Audio in Safari on this OS X release, see https://bugs.webkit.org/show_bug.cgi?id=32159 - "+(le?"will use flash fallback for MP3/MP4, if available":" would use flash fallback for MP3/MP4, but none detected."),1)),_e.useHTML5Audio&&_e.hasHTML5)for(t in z=!0,n)n.hasOwnProperty(t)&&n[t].required&&(_e.html5.canPlayType(n[t].type)?_e.preferFlash&&(_e.flash[t]||_e.flash[n[t].type])&&(e=!0):(z=!1,e=!0));return _e.ignoreFlash&&(e=!1,z=!0),_e.html5Only=_e.hasHTML5&&_e.useHTML5Audio&&!e,!_e.html5Only},X=function(e){var t,n,o=0;if(e instanceof Array){for(t=0,n=e.length;t<n;t++)if(e[t]instanceof Object){if(_e.canPlayMIME(e[t].type)){o=t;break}}else if(_e.canPlayURL(e[t])){o=t;break}e[o].url&&(e[o]=e[o].url),e=e[o]}return e},$=function(e){e._hasTimer||(e._hasTimer=!0,!Ge&&_e.html5PollingInterval&&(null===Ce&&0===ke&&(Ce=setInterval(J,_e.html5PollingInterval)),ke++))},G=function(e){e._hasTimer&&(e._hasTimer=!1,!Ge&&_e.html5PollingInterval&&ke--)},J=function(){var e;if(null===Ce||ke)for(e=_e.soundIDs.length-1;0<=e;e--)_e.sounds[_e.soundIDs[e]].isHTML5&&_e.sounds[_e.soundIDs[e]]._hasTimer&&_e.sounds[_e.soundIDs[e]]._onTimer();else clearInterval(Ce),Ce=null},E=function(n){n=n!==t?n:{},"function"==typeof _e.onerror&&_e.onerror.apply(e,[{type:n.type!==t?n.type:null}]),n.fatal!==t&&n.fatal&&_e.disable()},de=function(){if(Je&&ue()){var e,t,n=_e.audioFormats;for(t in n)if(n.hasOwnProperty(t)&&("mp3"===t||"mp4"===t)&&(_e._wD("soundManager: Using flash fallback for "+t+" format"),_e.html5[t]=!1,n[t]&&n[t].related))for(e=n[t].related.length-1;0<=e;e--)_e.html5[n[t].related[e]]=!1}},this._setSandboxType=function(e){var n=_e.sandbox;n.type=e,n.description=n.types[n.types[e]!==t?e:"unknown"],"localWithFile"===n.type?(n.noRemote=!0,n.noLocal=!1,f("secNote",2)):"localWithNetwork"===n.type?(n.noRemote=!1,n.noLocal=!0):"localTrusted"===n.type&&(n.noRemote=!1,n.noLocal=!1)},this._externalInterfaceOK=function(e){if(!_e.swfLoaded){var t;h("swf",!0),h("flashtojs",!0),_e.swfLoaded=!0,Ze=!1,Je&&de(),e&&e.replace(/\+dev/i,"")===_e.versionNumber.replace(/\+dev/i,"")?setTimeout(d,Ve?100:1):(t='soundManager: Fatal: JavaScript file build "'+_e.versionNumber+'" does not match Flash SWF build "'+e+'" at '+_e.url+". Ensure both are up-to-date.",setTimeout(function(){throw Error(t)},0))}},A=function(e,n){function o(){var e,t=[],n=[];e="SoundManager "+_e.version+(!_e.html5Only&&_e.useHTML5Audio?_e.hasHTML5?" + HTML5 audio":", no HTML5 audio support":""),_e.html5Only?_e.html5PollingInterval&&t.push("html5PollingInterval ("+_e.html5PollingInterval+"ms)"):(_e.preferFlash&&t.push("preferFlash"),_e.useHighPerformance&&t.push("useHighPerformance"),_e.flashPollingInterval&&t.push("flashPollingInterval ("+_e.flashPollingInterval+"ms)"),_e.html5PollingInterval&&t.push("html5PollingInterval ("+_e.html5PollingInterval+"ms)"),_e.wmode&&t.push("wmode ("+_e.wmode+")"),_e.debugFlash&&t.push("debugFlash"),_e.useFlashBlock&&t.push("flashBlock")),t.length&&(n=n.concat([t.join(" + ")])),_e._wD(e+(n.length?" + "+n.join(", "):""),1),he()}function i(e,t){return'<param name="'+e+'" value="'+t+'" />'}if(De&&Le)return!1;if(_e.html5Only)return D(),o(),_e.oMC=r(_e.movieID),d(),Le=De=!0,!1;var a,s,l,u=n||_e.url,c=_e.altURL||u,h=H(),f=j(),p=null,p=(p=Me.getElementsByTagName("html")[0])&&p.dir&&p.dir.match(/rtl/i);if(e=e===t?_e.id:e,D(),_e.url=N(tt?u:c),n=_e.url,_e.wmode=!_e.wmode&&_e.useHighPerformance?"transparent":_e.wmode,null!==_e.wmode&&(we.match(/msie 8/i)||!Ve&&!_e.useHighPerformance)&&navigator.platform.match(/win32|win64/i)&&(xe.push(T.spcWmode),_e.wmode=null),h={name:e,id:e,src:n,quality:"high",allowScriptAccess:_e.allowScriptAccess,bgcolor:_e.bgColor,pluginspage:nt+"www.macromedia.com/go/getflashplayer",title:"JS/Flash audio component (SoundManager 2)",type:"application/x-shockwave-flash",wmode:_e.wmode,hasPriority:"true"},_e.debugFlash&&(h.FlashVars="debug=1"),_e.wmode||delete h.wmode,Ve)u=Me.createElement("div"),s=['<object id="'+e+'" data="'+n+'" type="'+h.type+'" title="'+h.title+'" classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" codebase="http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,40,0">',i("movie",n),i("AllowScriptAccess",_e.allowScriptAccess),i("quality",h.quality),_e.wmode?i("wmode",_e.wmode):"",i("bgcolor",_e.bgColor),i("hasPriority","true"),_e.debugFlash?i("FlashVars",h.FlashVars):"","</object>"].join("");else for(a in u=Me.createElement("embed"),h)h.hasOwnProperty(a)&&u.setAttribute(a,h[a]);if(k(),f=j(),h=H())if(_e.oMC=r(_e.movieID)||Me.createElement("div"),_e.oMC.id)l=_e.oMC.className,_e.oMC.className=(l?l+" ":"movieContainer")+(f?" "+f:""),_e.oMC.appendChild(u),Ve&&(a=_e.oMC.appendChild(Me.createElement("div")),a.className="sm2-object-box",a.innerHTML=s),Le=!0;else{if(_e.oMC.id=_e.movieID,_e.oMC.className="movieContainer "+f,a=f=null,_e.useFlashBlock||(_e.useHighPerformance?f={position:"fixed",width:"8px",height:"8px",bottom:"0px",left:"0px",overflow:"hidden"}:(f={position:"absolute",width:"6px",height:"6px",top:"-9999px",left:"-9999px"},p&&(f.left=Math.abs(parseInt(f.left,10))+"px"))),Qe&&(_e.oMC.style.zIndex=1e4),!_e.debugFlash)for(l in f)f.hasOwnProperty(l)&&(_e.oMC.style[l]=f[l]);try{Ve||_e.oMC.appendChild(u),h.appendChild(_e.oMC),Ve&&(a=_e.oMC.appendChild(Me.createElement("div")),a.className="sm2-object-box",a.innerHTML=s),Le=!0}catch(e){throw Error(U("domError")+" \n"+e.toString())}}return De=!0,o(),!0},P=function(){return _e.html5Only?(A(),!1):!ye&&(_e.url?((ye=_e.getMovie(_e.id))||(He?(Ve?_e.oMC.innerHTML=Ae:_e.oMC.appendChild(He),He=null,De=!0):A(_e.id,_e.url),ye=_e.getMovie(_e.id)),"function"==typeof _e.oninitmovie&&setTimeout(_e.oninitmovie,1),fe(),!0):(f("noURL"),!1))},M=function(){setTimeout(b,1e3)},O=function(){e.setTimeout(function(){Q("soundManager: useFlashBlock is false, 100% HTML5 mode is possible. Rebooting with preferFlash: false..."),_e.setup({preferFlash:!1}).reboot(),_e.didFlashBlock=!0,_e.beginDelayedInit()},1)},b=function(){var t,n=!1;_e.url&&!Ee&&(Ee=!0,se.remove(e,"load",M),le&&Ze&&!ze?f("waitFocus"):(Te||0<(t=_e.getMoviePercent())&&100>t&&(n=!0),setTimeout(function(){t=_e.getMoviePercent(),n?(Ee=!1,_e._wD(U("waitSWF")),e.setTimeout(M,1)):(Te||(_e._wD("soundManager: No Flash response within expected time. Likely causes: "+(0===t?"SWF load failed, ":"")+"Flash blocked or JS-Flash security error."+(_e.debugFlash?" "+U("checkSWF"):""),2),!tt&&t&&(f("localFail",2),_e.debugFlash||f("tryDebug",2)),0===t&&_e._wD(U("swf404",_e.url),1),h("flashtojs",!1,": Timed out"+(tt?" (Check flash security or flash blockers)":" (No plugin/missing SWF?)"))),!Te&&Ye&&(null===t?_e.useFlashBlock||0===_e.flashLoadTimeout?(_e.useFlashBlock&&B(),f("waitForever")):!_e.useFlashBlock&&z?O():(f("waitForever"),w({type:"ontimeout",ignoreInit:!0,error:{type:"INIT_FLASHBLOCK"}})):0===_e.flashLoadTimeout?f("waitForever"):!_e.useFlashBlock&&z?O():x(!0)))},_e.flashLoadTimeout)))},L=function(){return ze||!Ze?(se.remove(e,"focus",L),!0):(ze=Ye=!0,f("gotFocus"),Ee=!1,M(),se.remove(e,"focus",L),!0)},fe=function(){xe.length&&(_e._wD("SoundManager 2: "+xe.join(" "),1),xe=[])},he=function(){fe();var e,t=[];if(_e.useHTML5Audio&&_e.hasHTML5){for(e in _e.audioFormats)_e.audioFormats.hasOwnProperty(e)&&t.push(e+" = "+_e.html5[e]+(!_e.html5[e]&&Ne&&_e.flash[e]?" (using flash)":_e.preferFlash&&_e.flash[e]&&Ne?" (preferring flash)":_e.html5[e]?"":" ("+(_e.audioFormats[e].required?"required, ":"")+"and no flash support)"));_e._wD("SoundManager 2 HTML5 support: "+t.join(", "),1)}},p=function(t){if(Te)return!1;if(_e.html5Only)return f("sm2Loaded",1),Te=!0,v(),h("onload",!0),!0;var n,o=!0;return _e.useFlashBlock&&_e.flashLoadTimeout&&!_e.getMoviePercent()||(Te=!0),n={type:!le&&Ne?"NO_FLASH":"INIT_TIMEOUT"},_e._wD("SoundManager 2 "+(Pe?"failed to load":"loaded")+" ("+(Pe?"Flash security/load error":"OK")+") "+String.fromCharCode(Pe?10006:10003),Pe?2:1),Pe||t?(_e.useFlashBlock&&_e.oMC&&(_e.oMC.className=j()+" "+(null===_e.getMoviePercent()?"swf_timedout":"swf_error")),w({type:"ontimeout",error:n,ignoreInit:!0}),h("onload",!1),E(n),o=!1):h("onload",!0),Pe||(_e.waitForWindowLoad&&!Se?(f("waitOnload"),se.add(e,"load",v)):(_e.waitForWindowLoad&&Se&&f("docLoaded"),v())),o},u=function(){var e,n=_e.setupOptions;for(e in n)n.hasOwnProperty(e)&&(_e[e]===t?_e[e]=n[e]:_e[e]!==n[e]&&(_e.setupOptions[e]=_e[e]))},d=function(){if(Te)return f("didInit"),!1;if(_e.html5Only)return Te||(se.remove(e,"load",_e.beginDelayedInit),_e.enabled=!0,p()),!0;P();try{ye._externalInterfaceTest(!1),R(!0,_e.flashPollingInterval||(_e.useHighPerformance?10:50)),_e.debugMode||ye._disableDebug(),_e.enabled=!0,h("jstoflash",!0),_e.html5Only||se.add(e,"unload",l)}catch(e){return _e._wD("js/flash exception: "+e.toString()),h("jstoflash",!1),E({type:"JS_TO_FLASH_EXCEPTION",fatal:!0}),x(!0),p(),!1}return p(),se.remove(e,"load",_e.beginDelayedInit),!0},S=function(){return!I&&(I=!0,u(),k(),!le&&_e.hasHTML5&&(_e._wD("SoundManager 2: No Flash detected"+(_e.useHTML5Audio?". Trying HTML5-only mode.":", enabling HTML5."),1),_e.setup({useHTML5Audio:!0,preferFlash:!1})),ae(),!le&&Ne&&(xe.push(T.needFlash),_e.setup({flashLoadTimeout:1})),Me.removeEventListener&&Me.removeEventListener("DOMContentLoaded",S,!1),P(),!0)},ie=function(){return"complete"===Me.readyState&&(S(),Me.detachEvent("onreadystatechange",ie)),!0},F=function(){Se=!0,S(),se.remove(e,"load",F)},ue(),se.add(e,"focus",L),se.add(e,"load",M),se.add(e,"load",F),Me.addEventListener?Me.addEventListener("DOMContentLoaded",S,!1):Me.attachEvent?Me.attachEvent("onreadystatechange",ie):(h("onload",!1),E({type:"NO_DOM2_EVENTS",fatal:!0}))}if(!e||!e.document)throw Error("SoundManager requires a browser with window and document objects.");var o=null;e.SM2_DEFER!==t&&SM2_DEFER||(o=new n),"object"==typeof module&&module&&"object"==typeof module.exports?(module.exports.SoundManager=n,module.exports.soundManager=o):"function"==typeof define&&define.amd&&define(function(){return{constructor:n,getInstance:function(t){return!e.soundManager&&t instanceof Function&&(t=t(n))instanceof n&&(e.soundManager=t),e.soundManager}}}),e.SoundManager=n,e.soundManager=o}(window);