﻿/**
 * Camera settings
 * Настройки камеры
 */
{
  "camera": {
    // false - disable camera settings.
    // 启用该功能
    "enabled": false,
    // true - disable red flash when enemy hit your tank.
    // true - отключить красную вспышку когда враг попадает по вам.
    "noFlashBang": false,
    // true - hide the tips about switching to siege mode and aiming mode changing in strategic mode.
    // true - скрыть подсказки перехода в осадный режим и смены режима прицеливания в стратегическом режиме.
    "hideHint": false,    
    // Arcade mode
    // 普通瞄准
    "arcade": {
      // Camera distance range: [min, max], default - [2, 25]
      // 镜头放大距离
      "distRange": [2, 25],
      // Start distance (null for default behavior - saved state from the last battle)
      // 初始距离
      "startDist": null,
      // 滚轮敏感度
      // Scroll sensitivity (по умолчанию = 5)
      "scrollSensitivity": 5,
      // false - disable the shot recoil effect (for the enabled dynamic camera option)
      // 跳弹效果
      "shotRecoilEffect": true
    },
    // Postmortem mode
    // Режим после смерти
    "postmortem": {
      // Camera distance range: [min, max], default - [2, 25]
      // Отдаление камеры: [мин, макс], по умолчанию - [2, 25]
      "distRange": [2, 25],
      // Start distance (null for default behavior - maximum distance)
      // Начальная дистанция (null для поведения по умолчанию - максимальная дистанция)
      "startDist": null,
      // Чувствительность прокрутки (default = 5)
      // Scroll sensitivity (по умолчанию = 5)
      "scrollSensitivity": 5,
      // false - disable the shot recoil effect (for the enabled dynamic camera option)
      // false - выключить эффект отдачи от выстрела (для включенной опции динамической камеры)
      "shotRecoilEffect": true
    },
    // Strategic mode (arty)
    // Стратегический режим (арта)
    "strategic": {
      // Camera distance range: [min, max], default - [40, 100]
      // Отдаление камеры: [мин, макс], по умолчанию - [40, 100]
      "distRange": [40, 100],
      // false - disable the shot recoil effect (for the enabled dynamic camera option)
      // false - выключить эффект отдачи от выстрела (для включенной опции динамической камеры)
      "shotRecoilEffect": true
    },
    // Sniper mode
    // Снайперский режим
    "sniper": {
      // List of multiplicities for the sniper mode
      // Default: [ 2, 4, 8 ]. It's possible to use a greater number of values.
      // 放大倍数列表
      // 默认: [ 2, 4, 8 ]. 可增加更大的倍数
      "zooms": [2, 4, 8],
      "startZoom": null,
      // Zoom Indicator
      // Global macros allowed in all fields
      // Индикатор масштаба
      // Можно использовать глобальные макросы во всех полях
      "zoomIndicator": {
        // Enable/disable
        // 放大倍数指示
        "enabled": true,
        // Field position relative to screen center
        // 位置
        "x": 150,
        "y": 30,
        // Field size
        // Размер поля
        "width": 100,
        "height": 40,
        // Opacity in percents (0..100)
        // 透明度
        "alpha": 100,
        "rotation": 0,
        "scaleX": 1,
        "scaleY": 1,
        // Background color
        // Цвет фона
        "bgColor": null,
        // Border color 
        // Цвет рамки
        "borderColor": null,
        "antiAliasType": "advanced",
        "textFormat": {
          "font": "$TitleFont",
          "size": 16,
          "color": "0x95CB29",
          "align": "left",
          "valign": "center"
        },
        // Text format
        // Формат текста
        "format": "x{{zoom}}",
        // Shadow options
        // Параметры тени
        "shadow": {
          // false - no shadow
          // false - без тени
          "enabled": true,
          "distance": 0,             // (in pixels)     / offset distance / дистанция смещения
          "angle": 0,                // (0.0 .. 360.0)  / offset angle    / угол смещения
          "color": "0x192E0E",       // "0xXXXXXX"      / color           / цвет
          "alpha": 100,              // (0 .. 100)      / opacity         / прозрачность
          "blur": 3,                 // (0.0 .. 255.0)  / blur            / размытие
          "strength": 2              // (0.0 .. 255.0)  / intensity       / интенсивность
        }
      },
      // false - disable the shot recoil effect (for the enabled dynamic camera option)
      // false - выключить эффект отдачи от выстрела (для включенной опции динамической камеры)
      "shotRecoilEffect": true,
      // true - disable dimming and greening in sniper scope
      // true - отключить затемнение и озеленение в снайперском прицеле
      "noBinoculars": false,
      // TODO: English comments
      // Отключение предела вращения камеры в снайперском прицеле для техники с ограниченными УГН (углами горизонтальной наводки) орудия. 
      "noCameraLimit": {
        // true - enable.
        // true - включить.
        "enabled": false,
        // "full" - отключение ограничения камеры и фиксации корпуса (включается вручную клавишей "x");
        // "custom" - отключение ограничения камеры;
        // "hotkey" - отключение ограничения камеры с зажатой правой кнопкой мыши;
        "mode": "hotkey"
      }
    }
  }
}
