
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {
--[[
        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),
]]

	Asset("SCRIPT", "scripts/prefabs/player_common.lua"),
	        Asset( "ANIM", "anim/xjj.zip" ),
        Asset( "ANIM", "anim/ghost_xjj_build.zip" ),
}
local prefabs = {}

-- Custom starting items
local start_inv = {
"xiaotai",
--"datai",
}




local function DoEffects(pet)
    local x, y, z = pet.Transform:GetWorldPosition()
    SpawnPrefab("zhaohuan").Transform:SetPosition(x, y, z)
    --SpawnPrefab("statue_transition_2").Transform:SetPosition(x, y, z)
end

local function KillPet(pet)

    pet.components.health:Kill()
end

	hunger_modifier = 0
	speed_modifier = 0
	armor_modifier = 0
	dmg_modifier = 0
	sanity_modifier = 0

local function OnSpawn(inst, pet)
    --if pet:HasTag("shadowminion") then
    --Delayed in case we need to relocate for migration spawning
    pet:DoTaskInTime(0, DoEffects)
	
    if not (inst.components.health:IsDead() or inst:HasTag("playerghost")) then
        -- inst.components.sanity:AddSanityPenalty(pet, TUNING.SHADOWWAXWELL_SANITY_PENALTY[string.upper(pet.prefab)])
		hunger_modifier = hunger_modifier + 0.008
		speed_modifier = speed_modifier + 0.008
		armor_modifier = armor_modifier + 0.01
		dmg_modifier = dmg_modifier + 0.025
		sanity_modifier = sanity_modifier + 0.02
		inst:ListenForEvent("onremove", inst._onpetlost, pet)
		inst.components.hunger.hungerrate = inst.components.hunger.hungerrate + (hunger_modifier * TUNING.WILSON_HUNGER_RATE)
		inst.components.locomotor.runspeed =  inst.components.locomotor.runspeed + (speed_modifier * TUNING.WILSON_RUN_SPEED)
		inst.components.combat.damagemultiplier = inst.components.combat.damagemultiplier + dmg_modifier 
		inst.components.health:SetAbsorptionAmount(armor_modifier)
		inst.components.sanity.night_drain_mult = inst.components.sanity.night_drain_mult + sanity_modifier
		inst.components.sanity.neg_aura_mult = inst.components.sanity.neg_aura_mult + sanity_modifier
		
    elseif pet._killtask == nil then
        pet._killtask = pet:DoTaskInTime(math.random(), KillPet)
    --end
	    --elseif inst._OnSpawnPet ~= nil then
        --inst:_OnSpawnPet(pet)
    end
	--end
end

local function OnDespawn(inst, pet)
    DoEffects(pet)
    pet:Remove()
end

local function OnDeath(inst)
    for k, v in pairs(inst.components.petleash:GetPets()) do
        if v._killtask == nil then
            v._killtask = v:DoTaskInTime(math.random(), KillPet)
        end
    end
end


local function onbecamehuman(inst)

	--inst.components.locomotor:SetExternalSpeedMultiplier(inst, "xjj_speed_mod", 1)
	
end

local function onbecameghost(inst)
   --KillPet(pet)
   --inst.components.locomotor:RemoveExternalSpeedMultiplier(inst, "xjj_speed_mod")
   
end

local function onload(inst)

    inst:ListenForEvent("ms_respawnedfromghost", onbecamehuman)
    inst:ListenForEvent("ms_becameghost", onbecameghost)

    if inst:HasTag("playerghost") then
	
        onbecameghost(inst)
		
    else
	
        onbecamehuman(inst)
		
    end
	
end




local function xuexian(inst)

    if inst.components.hunger:GetPercent() < 0.15 and inst.components.health:GetPercent() > 0 then
	inst.components.health.maxhealth=28
		inst.components.talker:Say("电量过低!", 2.2,true)
		else
	inst.components.health.maxhealth=128	
	end
	
	end

local function health_droped(inst)
inst.components.health:StartRegen(-1, 8)
inst.components.sanity.dapperness = -TUNING.DAPPERNESS_HUGE * 2
inst.components.hunger.hungerrate = TUNING.WILSON_HUNGER_RATE * 2.8
end

local function health_stoped(inst)
inst.components.health:StartRegen(0, 8)
inst.components.sanity.dapperness = 0
inst.components.hunger.hungerrate = TUNING.WILSON_HUNGER_RATE * 1

end

local function oneath(inst, data)
local hujiaxp_time = 80
local huisanxp_time = 30
local huixuexp_time = 30
local jianjie_time = 480
local jiashang_time = 60
local speedup_time = 60
local zuidah_time = 60
local food = data and data.food
if food and food.prefab == "yaoshui" then
health_stoped(inst)
inst.components.talker:Say("病毒已被杀灭!", 2.2,true)
inst.SoundEmitter:PlaySound("dontstarve/characters/wx78/levelup")

elseif food and food.prefab == "honeyham" then
inst.components.hunger:DoDelta(300)
inst.components.sanity:DoDelta(300)
inst.components.health:DoDelta(300)

elseif food and food.components.edible and food.components.edible.foodtype == FOODTYPE.GEARS and food.prefab == "hujiaxp" then
	inst.components.health.absorb = 0.8
	inst:DoTaskInTime(hujiaxp_time, function()
	inst.components.health.absorb = 0.2
	end)

elseif food and food.components.edible and food.components.edible.foodtype == FOODTYPE.GEARS and food.prefab == "huisanxp" then
	inst.components.sanity.dapperness = TUNING.DAPPERNESS_LARGE * 3
	inst:DoTaskInTime(huisanxp_time, function()
	inst.components.sanity.dapperness = 0
	end)

elseif food and food.components.edible and food.components.edible.foodtype == FOODTYPE.GEARS and food.prefab == "huixuexp" then
	inst.components.health:StartRegen(5, 1)
	inst:DoTaskInTime(huixuexp_time, function()
	inst.components.health:StartRegen(0, 1)
	end)

elseif food and food.components.edible and food.components.edible.foodtype == FOODTYPE.GEARS and food.prefab == "jianjie" then
	inst.components.hunger.hungerrate = 0.5 * TUNING.WILSON_HUNGER_RATE
	inst:DoTaskInTime(jianjie_time, function()
	inst.components.hunger.hungerrate = 1 * TUNING.WILSON_HUNGER_RATE
	end)

elseif food and food.components.edible and food.components.edible.foodtype == FOODTYPE.GEARS and food.prefab == "jiashang" then
if inst.components.combat.damagemultiplier and inst.components.combat.damagemultiplier <= 3 then
	inst.components.combat.damagemultiplier = inst.components.combat.damagemultiplier + 1
	inst:DoTaskInTime(jiashang_time, function()
	inst.components.combat.damagemultiplier = inst.components.combat.damagemultiplier - 1
	end)
end


elseif food and food.components.edible and food.components.edible.foodtype == FOODTYPE.GEARS and food.prefab == "speedup" then
if inst.components.locomotor.walkspeed <= 13 and inst.components.locomotor.runspeed <= 15 then
	inst.components.locomotor.walkspeed = inst.components.locomotor.walkspeed + 2
	inst.components.locomotor.runspeed = inst.components.locomotor.runspeed + 2
	inst:DoTaskInTime(speedup_time, function()
	inst.components.locomotor.walkspeed = inst.components.locomotor.walkspeed - 2
	inst.components.locomotor.runspeed = inst.components.locomotor.runspeed - 2
	end)
end
elseif food and food.components.edible and food.components.edible.foodtype == FOODTYPE.GEARS and food.prefab == "zuidah" then
if inst.components.temperature then
				inst.components.temperature:SetTemperature(10)
			end
			if inst and inst.components.burnable then
				inst.components.burnable:Extinguish()
			end
	inst.components.health.fire_damage_scale = 0
	inst:DoTaskInTime(zuidah_time, function()
	inst.components.health.fire_damage_scale = 1
	end)
end
end

local function onkilledother(inst, data)
	local chance = 0.3
	local chancet = 0.07
	local victim = data.victim
	local x, y, z = victim.Transform:GetWorldPosition()
		if victim.components.freezable and victim:HasTag("monster") then
		if math.random() < chancet then
			health_droped(inst)
			inst.SoundEmitter:PlaySound("dontstarve/sanity/creature2/taunt")
	local x, y, z = inst.Transform:GetWorldPosition()
	--local fx = SpawnPrefab("lightning")
	--fx.Transform:SetPosition(x, y, z)
	SpawnPrefab("statue_transition").Transform:SetPosition(inst:GetPosition():Get())
			inst.components.talker:Say("机体发现有病毒入侵!", 2.2,true)
end end 
		if victim.components.freezable or victim:HasTag("monster") then
		
		if math.random() < chance then
	SpawnPrefab("xinp").Transform:SetPosition(x,y,z)
			
end end
end


--[[
-- When the character is revived from human
local function onbecamehuman(inst)
	-- Set speed when loading or reviving from ghost (optional)
	inst.components.locomotor.walkspeed = 5
	inst.components.locomotor.runspeed = 7
end

-- When loading or spawning the character

local function onload(inst)
    inst:ListenForEvent("ms_respawnedfromghost", onbecamehuman)

    if not inst:HasTag("playerghost") then
        onbecamehuman(inst)
    end
end
]]

-- This initializes for both the server and client. Tags can be added here.
local common_postinit = function(inst) 
	inst:AddTag("xjj_builder")
	-- Minimap icon
	inst.MiniMapEntity:SetIcon( "xjj.tex" )
		inst.transformed = true 
	inst:AddComponent("keyhandler")
    inst.components.keyhandler:AddActionListener("xjj", TUNING.XJJ.KEYTWO, "Kkkk")
end

-- This initializes for the server only. Components are added here.
local master_postinit = function(inst)
	-- choose which sounds this character will play
	inst.soundsname = "willow"
	
	-- Uncomment if "wathgrithr"(Wigfrid) or "webber" voice is used
    --inst.talker_path_override = "dontstarve_DLC001/characters/"
	
	--pet
		inst:AddTag("insomniac")
	inst:AddComponent("petleash")
    inst.components.petleash:SetOnSpawnFn(OnSpawn)
    inst.components.petleash:SetOnDespawnFn(OnDespawn)
    inst.components.petleash:SetMaxPets(1)

	inst._onpetlost = function(pet)
	inst.components.hunger.hungerrate = inst.components.hunger.hungerrate - (TUNING.WILSON_HUNGER_RATE * hunger_modifier)
	hunger_modifier = hunger_modifier - 0.008
	inst.components.locomotor.runspeed =  inst.components.locomotor.runspeed - (TUNING.WILSON_RUN_SPEED * speed_modifier)
	speed_modifier = speed_modifier - 0.008
	inst.components.combat.damagemultiplier = inst.components.combat.damagemultiplier - dmg_modifier
	dmg_modifier = dmg_modifier - 0.025
	armor_modifier = armor_modifier - 0.01
	inst.components.health:SetAbsorptionAmount(armor_modifier)
	inst.components.sanity.night_drain_mult = inst.components.sanity.night_drain_mult - sanity_modifier
    inst.components.sanity.neg_aura_mult = inst.components.sanity.neg_aura_mult - sanity_modifier
	sanity_modifier = sanity_modifier - 0.02
	end

	
	-- Stats	
	inst.components.health:SetMaxHealth(128)
	inst.components.hunger:SetMax(128)
	inst.components.sanity:SetMax(228)
	inst.components.locomotor.walkspeed = 5
	inst.components.locomotor.runspeed = 7
	inst.components.combat.min_attack_period = 0.5
	inst.components.health.fire_damage_scale = 1
	inst.components.temperature.mintemp = 8
	inst.components.temperature.overheattemp = 60
	inst.components.builder.science_bonus = 1
	inst.components.sanity.neg_aura_mult = 0.2
	inst.components.health.absorb = 0.2

	   --inst.components.eater.ignoresspoilage = true
    inst.components.eater:SetCanEatGears()
    --inst.components.eater:SetOnEatFn(oneat)
	
	-- Damage multiplier (optional)
    inst.components.combat.damagemultiplier = 1
	
	-- Hunger rate (optional)
	inst.components.hunger.hungerrate = 1 * TUNING.WILSON_HUNGER_RATE
	
	inst:ListenForEvent("killed", onkilledother)
	inst:ListenForEvent("oneat", oneath)
	--inst:ListenForEvent("death", OnDeath)
	
	--inst.OnLoad = onload
    --inst.OnNewSpawn = onload
	
		inst.OnLoad = onload
    inst.OnNewSpawn = onload
	
	    local rtox = 5
    inst:DoPeriodicTask(rtox, function() xuexian(inst, rtox) end)
	
	
	
end

return MakePlayerCharacter("xjj", prefabs, assets, common_postinit, master_postinit, start_inv)
