local assets=
{
	Asset("ANIM", "anim/speedup.zip"),
	
	Asset("ATLAS", "images/inventoryimages/speedup.xml"),
    Asset("IMAGE", "images/inventoryimages/speedup.tex"),
}

local function fn()
    
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	--inst.entity:AddSoundEmitter()
	--inst.entity:AddPhysics()
	inst.entity:AddNetwork()
	inst.entity:AddLight()
	
    MakeInventoryPhysics(inst)
	RemovePhysicsColliders(inst)

    inst.AnimState:SetBank("speedup")
    inst.AnimState:SetBuild("speedup")
    inst.AnimState:PlayAnimation("idle")


	
	
	inst.entity:SetPristine()
    if not TheWorld.ismastersim then
        return inst
    end
	
    inst:AddComponent("edible")
    inst.components.edible.foodtype = FOODTYPE.GEARS
    inst.components.edible.healthvalue = 1
    inst.components.edible.hungervalue = 1
    inst.components.edible.sanityvalue = 1
    --inst:AddComponent("tradable")
    
    inst:AddComponent("inspectable")
	inst:AddComponent("stackable")

    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.imagename = "speedup"
	inst.components.inventoryitem.atlasname = "images/inventoryimages/speedup.xml"
  
    return inst
end

return Prefab( "common/inventory/speedup", fn, assets) 
