local assets =
{
    Asset("ANIM", "anim/juzi.zip"),
    Asset("ANIM", "anim/swap_juzi.zip"),
	Asset("IMAGE","images/inventoryimages/juzi.tex"),
	Asset("ATLAS","images/inventoryimages/juzi.xml")
}

local function onequip(inst, owner)

    owner.AnimState:OverrideSymbol("swap_object", "swap_juzi", "swap_juzi")
    owner.AnimState:Show("ARM_carry")
    owner.AnimState:Hide("ARM_normal")

end

local function onunequip(inst, owner)
--inst:RemoveTag("feng")
    owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")

end


local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("juzi")
    inst.AnimState:SetBuild("juzi")
    inst.AnimState:PlayAnimation("idle")

    inst:AddTag("sharp")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(5)

    -------
    --inst.components.weapon:SetRange()



    inst:AddComponent("inspectable")

    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.imagename = "juzi"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/juzi.xml"
	
inst:AddComponent("tool")
	inst.components.tool:SetAction(ACTIONS.CHOP, 3)
        inst.components.tool:SetAction(ACTIONS.MINE, 2)
		
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)



    MakeHauntableLaunch(inst)

    return inst
end

return Prefab( "common/inventory/juzi", fn, assets)