/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.util.xml;

import com.sodiumarc.patchwork.util.Collection.StringMap;
import com.sodiumarc.patchwork.util.xml.DocumentNodeTranscoder;
import com.sodiumarc.patchwork.util.xml.XMLUtils;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class StringMapTranscoder
implements DocumentNodeTranscoder<StringMap> {
    private static final String ENTRY_ELEMENT_NAME = "entry";
    private static final String ATTR_KEY = "key";
    private static final String ATTR_VALUE = "value";
    private final String elementName;

    public StringMapTranscoder(String elementName) {
        this.elementName = elementName;
    }

    @Override
    public Class<StringMap> getDecodedType() {
        return StringMap.class;
    }

    @Override
    public Node encode(Document document, StringMap object) {
        Element result = XMLUtils.createElement(document, this.elementName, null, false);
        for (String key : object.keySet()) {
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put(ATTR_KEY, key);
            attributes.put(ATTR_VALUE, (String)object.get(key));
            Element entryElement = XMLUtils.createElement(document, ENTRY_ELEMENT_NAME, attributes, true);
            result.appendChild(entryElement);
        }
        return result;
    }

    @Override
    public StringMap decode(Node node) {
        assert (node != null) : "Null node";
        if (node.getNodeType() != 1) {
            return null;
        }
        if (!node.getLocalName().equals(this.elementName)) {
            return null;
        }
        StringMap result = new StringMap();
        for (Node entryNode : XMLUtils.getChildElements(node, ENTRY_ELEMENT_NAME)) {
            Map<String, String> attributes = XMLUtils.getAttributes(entryNode);
            result.put(attributes.get(ATTR_KEY), attributes.get(ATTR_VALUE));
        }
        return result;
    }
}

