/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.util.xml;

import com.sodiumarc.patchwork.util.Collection.StringMap;
import com.sodiumarc.patchwork.util.xml.DocumentNodeTranscoder;
import com.sodiumarc.patchwork.util.xml.StringMapTranscoder;
import java.util.EnumMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class EnumMapTranscoder<E extends Enum<E>>
implements DocumentNodeTranscoder<EnumMap> {
    private static final String ELEMENT_NAME = "EnumMap";
    private final StringMapTranscoder stringMapTranscoder = new StringMapTranscoder("EnumMap");
    private final Class<E> enumType;

    public EnumMapTranscoder(Class<E> enumType) {
        this.enumType = enumType;
    }

    @Override
    public Class<EnumMap> getDecodedType() {
        return EnumMap.class;
    }

    @Override
    public Node encode(Document document, EnumMap map) {
        StringMap stringMap = new StringMap();
        for (Object key : map.keySet()) {
            stringMap.put(((Enum)key).name(), (String)map.get(key));
        }
        return this.stringMapTranscoder.encode(document, stringMap);
    }

    @Override
    public EnumMap decode(Node node) {
        StringMap stringMap = this.stringMapTranscoder.decode(node);
        EnumMap result = new EnumMap(this.enumType);
        for (Map.Entry entry : stringMap.entrySet()) {
            result.put(this.toEnumVal((String)entry.getKey()), entry.getValue());
        }
        return result;
    }

    protected abstract E toEnumVal(String var1);
}

