/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.util.image;

import com.sodiumarc.patchwork.util.ColorComponent;
import com.sodiumarc.patchwork.util.ColorUtils;
import com.sodiumarc.patchwork.util.MathUtils;
import com.sodiumarc.patchwork.util.Rectangle4d;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.ImageCapabilities;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;

public class ImageUtils {
    public static void saveImage(BufferedImage img, File file) throws IOException {
        ImageUtils.saveImage(img, file.getPath());
    }

    public static void saveImage(BufferedImage img, String filename) throws IOException {
        String format = filename.endsWith(".png") ? "png" : "jpeg";
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName(format);
        ImageWriter writer = iter.next();
        ImageWriteParam iwp = null;
        if (format.equals("jpeg")) {
            iwp = writer.getDefaultWriteParam();
            iwp.setCompressionMode(2);
            iwp.setCompressionQuality(1.0f);
        }
        File file = new File(filename);
        FileImageOutputStream output = new FileImageOutputStream(file);
        writer.setOutput(output);
        IIOImage image = new IIOImage(img, null, null);
        writer.write(null, image, iwp);
        writer.dispose();
        output.close();
    }

    public static void saveRGBImage(BufferedImage img, String filename) throws IOException {
        BufferedImage rgbImage = new BufferedImage(img.getWidth(), img.getHeight(), 1);
        Graphics2D g = rgbImage.createGraphics();
        g.setComposite(AlphaComposite.Src);
        g.drawImage(img, null, 0, 0);
        g.dispose();
        ImageUtils.saveImage(rgbImage, filename);
    }

    public static BufferedImage composite(List<BufferedImage> layers) {
        int maxWidth = 0;
        int maxHeight = 0;
        for (BufferedImage image : layers) {
            if (image == null) continue;
            maxWidth = Math.max(maxWidth, image.getWidth());
            maxHeight = Math.max(maxHeight, image.getHeight());
        }
        if (maxWidth == 0 || maxHeight == 0) {
            return null;
        }
        BufferedImage result = new BufferedImage(maxWidth, maxHeight, 2);
        Graphics2D g = (Graphics2D)result.getGraphics();
        g.setComposite(AlphaComposite.SrcOver);
        for (BufferedImage image : layers) {
            g.drawImage((Image)image, 0, 0, null);
        }
        g.dispose();
        return result;
    }

    public static BufferedImage scale(BufferedImage image, float xScale, float yScale) {
        BufferedImage scaledImage = new BufferedImage((int)((float)image.getWidth() * xScale), (int)((float)image.getHeight() * yScale), 2);
        Graphics2D g = scaledImage.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g.setComposite(AlphaComposite.Src);
        g.drawImage(image, 0, 0, scaledImage.getWidth(), scaledImage.getHeight(), 0, 0, image.getWidth(), image.getHeight(), null);
        g.dispose();
        return scaledImage;
    }

    public static void drawImage(BufferedImage source, BufferedImage destination, Rectangle sourceRect, Rectangle destRect) {
        Graphics2D g = (Graphics2D)destination.getGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g.setComposite(AlphaComposite.Src);
        g.drawImage(source, destRect.x, destRect.y, destRect.x + destRect.width, destRect.y + destRect.height, sourceRect.x, sourceRect.y, sourceRect.x + sourceRect.width, sourceRect.y + sourceRect.height, null);
        g.dispose();
    }

    public static BufferedImage copy(BufferedImage image) {
        int type = image.getType();
        if (type == 0) {
            type = 2;
        }
        BufferedImage result = new BufferedImage(image.getWidth(), image.getHeight(), type);
        Graphics2D g = result.createGraphics();
        g.setComposite(AlphaComposite.Src);
        g.drawImage(image, null, 0, 0);
        g.dispose();
        return result;
    }

    public static BufferedImage safeSubimage(BufferedImage source, int x, int y, int w, int h) {
        int xAdjusted = Math.max(x, 0);
        int yAdjusted = Math.max(y, 0);
        int wAdjusted = Math.min(source.getWidth() - xAdjusted, w);
        int hAdjusted = Math.min(source.getHeight() - yAdjusted, h);
        return source.getSubimage(xAdjusted, yAdjusted, wAdjusted, hAdjusted);
    }

    public static BufferedImage scale(BufferedImage image, int destWidth, int destHeight) {
        int sourceWidth = image.getWidth();
        int sourceHeight = image.getHeight();
        if (sourceWidth == destWidth && sourceHeight == destHeight) {
            return image;
        }
        BufferedImage scaledImage = new BufferedImage(destWidth, destHeight, 2);
        Graphics2D g = scaledImage.createGraphics();
        if (destWidth < sourceWidth && destHeight < sourceHeight) {
            Image downScaled = image.getScaledInstance(destWidth, destHeight, 16);
            g.drawImage(downScaled, 0, 0, null);
        } else {
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g.setComposite(AlphaComposite.Src);
            g.drawImage(image, 0, 0, scaledImage.getWidth(), scaledImage.getHeight(), 0, 0, image.getWidth(), image.getHeight(), null);
        }
        g.dispose();
        return scaledImage;
    }

    public static BufferedImage trimColor(BufferedImage image, Color eraseColor, int epsilon) {
        int xTrimmedMin = -1;
        int xTrimmedMax = -1;
        int yTrimmedMin = -1;
        int yTrimmedMax = -1;
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                if (ColorUtils.epsilonEqualsColor(new Color(image.getRGB(x, y)), eraseColor, epsilon)) continue;
                if (xTrimmedMin == -1 || x < xTrimmedMin) {
                    xTrimmedMin = x;
                }
                if (xTrimmedMax == -1 || x > xTrimmedMax) {
                    xTrimmedMax = x;
                }
                if (yTrimmedMin == -1 || y < yTrimmedMin) {
                    yTrimmedMin = y;
                }
                if (yTrimmedMax != -1 && y <= yTrimmedMax) continue;
                yTrimmedMax = y;
            }
        }
        int trimmedWidth = xTrimmedMax - xTrimmedMin + 1;
        int trimmedHeight = yTrimmedMax - yTrimmedMin + 1;
        BufferedImage processedImage = new BufferedImage(trimmedWidth, trimmedHeight, 2);
        Graphics2D g = processedImage.createGraphics();
        g.setComposite(AlphaComposite.SrcOver);
        g.drawImage(image, 0, 0, trimmedWidth, trimmedHeight, xTrimmedMin, yTrimmedMin, xTrimmedMax, yTrimmedMax, null);
        g.dispose();
        return processedImage;
    }

    public static void fill(BufferedImage image, Color color) {
        Graphics2D g = image.createGraphics();
        g.setComposite(AlphaComposite.Src);
        g.setColor(color);
        g.fillRect(0, 0, image.getWidth(), image.getHeight());
        g.dispose();
    }

    public static BufferedImage fillComponent(BufferedImage image, ColorComponent component, int value) {
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int argb = image.getRGB(x, y);
                argb = ColorUtils.setComponent(argb, component, value);
                image.setRGB(x, y, argb);
            }
        }
        return image;
    }

    public static BufferedImage mask(BufferedImage toMask, BufferedImage mask, int bias) {
        if (bias == 0) {
            return ImageUtils.mask(toMask, mask);
        }
        BufferedImage biasMask = new BufferedImage(mask.getWidth(), mask.getHeight(), mask.getType());
        int w = mask.getWidth();
        for (int x = 0; x < w; ++x) {
            int h = mask.getHeight();
            for (int y = 0; y < h; ++y) {
                int sourceColor = mask.getRGB(x, y);
                int alpha = ColorUtils.getComponent(sourceColor, ColorComponent.ALPHA);
                if (alpha <= 0) continue;
                for (int dx = -bias; dx <= bias; ++dx) {
                    for (int dy = -bias; dy <= bias; ++dy) {
                        biasMask.setRGB(MathUtils.clamp(x + dx, 0, w - 1), MathUtils.clamp(y + dy, 0, h - 1), -1);
                    }
                }
            }
        }
        return ImageUtils.mask(toMask, biasMask);
    }

    public static BufferedImage mask(BufferedImage toMask, BufferedImage mask) {
        BufferedImage result = new BufferedImage(toMask.getWidth(), toMask.getHeight(), 2);
        int w = toMask.getWidth();
        for (int x = 0; x < w; ++x) {
            int h = toMask.getHeight();
            for (int y = 0; y < h; ++y) {
                int maskColor = mask.getRGB(x, y);
                int alpha = ColorUtils.getComponent(maskColor, ColorComponent.ALPHA);
                if (alpha == 0) continue;
                result.setRGB(x, y, toMask.getRGB(x, y));
            }
        }
        return result;
    }

    public static BufferedImage fadeMargins(BufferedImage image, Rectangle4d solidImageRect) {
        double alpha;
        int color;
        int y;
        double alpha2;
        int color2;
        int y2;
        double fraction;
        int x;
        int fromX = 0;
        int toX = (int)solidImageRect.getX();
        for (x = fromX; x < toX; ++x) {
            fraction = MathUtils.rangeFraction(x, fromX, toX);
            for (y2 = 0; y2 < image.getHeight(); ++y2) {
                color2 = image.getRGB(x, y2);
                alpha2 = ColorUtils.getComponent(color2, ColorComponent.ALPHA);
                color2 = ColorUtils.setComponent(color2, ColorComponent.ALPHA, (int)(alpha2 * fraction));
                image.setRGB(x, y2, color2);
            }
        }
        fromX = (int)solidImageRect.getXMax() + 1;
        toX = image.getWidth();
        for (x = fromX; x < toX; ++x) {
            fraction = MathUtils.rangeFraction(x, fromX, toX);
            for (y2 = 0; y2 < image.getHeight(); ++y2) {
                color2 = image.getRGB(x, y2);
                alpha2 = ColorUtils.getComponent(color2, ColorComponent.ALPHA);
                color2 = ColorUtils.setComponent(color2, ColorComponent.ALPHA, (int)(alpha2 * (1.0 - fraction)));
                image.setRGB(x, y2, color2);
            }
        }
        int fromY = 0;
        int toY = (int)solidImageRect.getY();
        for (y = fromY; y < toY; ++y) {
            double fraction2 = MathUtils.rangeFraction(y, fromY, toY);
            for (int x2 = 0; x2 < image.getWidth(); ++x2) {
                color = image.getRGB(x2, y);
                alpha = ColorUtils.getComponent(color, ColorComponent.ALPHA);
                color = ColorUtils.setComponent(color, ColorComponent.ALPHA, (int)(alpha * fraction2));
                image.setRGB(x2, y, color);
            }
        }
        fromY = (int)solidImageRect.getYMax() + 1;
        toY = image.getHeight();
        for (y = fromY; y < toY; ++y) {
            double fraction3 = MathUtils.rangeFraction(y, fromY, toY);
            for (int x3 = 0; x3 < image.getWidth(); ++x3) {
                color = image.getRGB(x3, y);
                alpha = ColorUtils.getComponent(color, ColorComponent.ALPHA);
                color = ColorUtils.setComponent(color, ColorComponent.ALPHA, (int)(alpha * (1.0 - fraction3)));
                image.setRGB(x3, y, color);
            }
        }
        return image;
    }

    public static BufferedImage silhouette(BufferedImage source, Color foreground, Color background) {
        assert (source != null);
        assert (foreground != null);
        int foreARGB = ColorUtils.toIntARGB(foreground);
        int backARGB = ColorUtils.toIntARGB(background);
        for (int y = 0; y < source.getHeight(); ++y) {
            for (int x = 0; x < source.getWidth(); ++x) {
                int alpha = ColorUtils.getComponent(source.getRGB(x, y), ColorComponent.ALPHA);
                float alphaF = (float)MathUtils.rangeFraction(alpha, 0.0, 255.0);
                int blendARGB = ColorUtils.blend(backARGB, foreARGB, alphaF);
                source.setRGB(x, y, blendARGB);
            }
        }
        return source;
    }

    public static BufferedImage addBorder(BufferedImage image, Color color, int size) {
        assert (image != null);
        assert (color != null);
        BufferedImage result = new BufferedImage(image.getWidth() + 2 * size, image.getHeight() + 2 * size, 2);
        ImageUtils.fill(result, color);
        Graphics2D g = result.createGraphics();
        g.setComposite(AlphaComposite.Src);
        g.drawImage(image, null, size, size);
        g.dispose();
        return result;
    }

    public static BufferedImage fillExterior(BufferedImage image, Color emptyColor, int epsilon, int border) {
        int pixelRGB;
        int lastRGB;
        assert (image != null);
        assert (emptyColor != null);
        assert (epsilon >= 0);
        assert (border >= 0);
        BufferedImage processedImage = new BufferedImage(image.getWidth() + 2 * border, image.getHeight() + 2 * border, 2);
        Graphics2D g = processedImage.createGraphics();
        g.setComposite(AlphaComposite.Src);
        g.drawImage(image, null, border, border);
        g.dispose();
        int eraseRGB = emptyColor.getRGB();
        for (int y = 0; y < processedImage.getHeight(); ++y) {
            int x;
            lastRGB = eraseRGB;
            for (x = 0; x < processedImage.getWidth(); ++x) {
                pixelRGB = processedImage.getRGB(x, y);
                if (ColorUtils.epsilonEqualsColor(pixelRGB, eraseRGB, epsilon)) {
                    processedImage.setRGB(x, y, lastRGB);
                    continue;
                }
                lastRGB = pixelRGB;
            }
            lastRGB = eraseRGB;
            for (x = processedImage.getWidth() - 1; x >= 0; --x) {
                pixelRGB = processedImage.getRGB(x, y);
                if (ColorUtils.epsilonEqualsColor(pixelRGB, eraseRGB, epsilon)) {
                    processedImage.setRGB(x, y, lastRGB);
                    continue;
                }
                lastRGB = pixelRGB;
            }
        }
        for (int x = 0; x < processedImage.getWidth(); ++x) {
            int y;
            lastRGB = eraseRGB;
            for (y = 0; y < processedImage.getHeight(); ++y) {
                pixelRGB = processedImage.getRGB(x, y);
                if (ColorUtils.epsilonEqualsColor(pixelRGB, eraseRGB, epsilon)) {
                    processedImage.setRGB(x, y, lastRGB);
                    continue;
                }
                lastRGB = pixelRGB;
            }
            lastRGB = eraseRGB;
            for (y = processedImage.getHeight() - 1; y >= 0; --y) {
                pixelRGB = processedImage.getRGB(x, y);
                if (ColorUtils.epsilonEqualsColor(pixelRGB, eraseRGB, epsilon)) {
                    processedImage.setRGB(x, y, lastRGB);
                    continue;
                }
                lastRGB = pixelRGB;
            }
        }
        return processedImage;
    }

    public static Rectangle getVisibleRegion(BufferedImage image) {
        assert (image != null);
        int xMin = Integer.MAX_VALUE;
        int xMax = Integer.MIN_VALUE;
        int yMin = Integer.MAX_VALUE;
        int yMax = Integer.MIN_VALUE;
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int pixelRGB = image.getRGB(x, y);
                int alpha = ColorUtils.getComponent(pixelRGB, ColorComponent.ALPHA);
                if (alpha == 0) continue;
                xMin = Math.min(x, xMin);
                xMax = Math.max(x, xMax);
                yMin = Math.min(y, yMin);
                yMax = Math.max(y, yMax);
            }
        }
        if (xMin > xMax || yMin > yMax) {
            return new Rectangle(0, 0, 0, 0);
        }
        return new Rectangle(xMin, yMin, xMax - xMin + 1, yMax - yMin + 1);
    }

    public static void paintCheckerboard(Graphics graphics, Rectangle bounds, int checkerWidth, int checkerHeight, Color color0, Color color1) {
        assert (graphics != null);
        assert (bounds != null);
        assert (color0 != null);
        assert (color1 != null);
        graphics.setColor(color0);
        int xEnd = bounds.x + bounds.width;
        int yEnd = bounds.y + bounds.height;
        boolean evenColumn = true;
        boolean evenRow = true;
        for (int y = bounds.y; y < yEnd; y += checkerHeight) {
            evenColumn = true;
            for (int x = bounds.x; x < xEnd; x += checkerWidth) {
                graphics.setColor(evenColumn == evenRow ? color0 : color1);
                graphics.fillRect(x, y, Math.min(checkerWidth, xEnd - x), Math.min(checkerHeight, yEnd - y));
                evenColumn = !evenColumn;
            }
            evenRow = !evenRow;
        }
    }

    public static BufferedImage intensityToAlpha(BufferedImage source, int minIntensity, int maxIntensity) {
        assert (source != null);
        for (int y = 0; y < source.getHeight(); ++y) {
            for (int x = 0; x < source.getWidth(); ++x) {
                int argb = source.getRGB(x, y);
                int averageIntensity = ColorUtils.getIntensity(argb);
                double fraction = MathUtils.clamp(MathUtils.rangeFraction(averageIntensity, minIntensity, maxIntensity), 0.0, 1.0);
                argb = ColorUtils.setComponent(argb, ColorComponent.ALPHA, (int)(fraction * 255.0));
                source.setRGB(x, y, argb);
            }
        }
        return source;
    }

    public static BufferedImage boxBlur(BufferedImage source, int radius) {
        assert (source != null);
        BufferedImage result = new BufferedImage(source.getWidth(), source.getHeight(), source.getType());
        int size = 1 + 2 * radius;
        int pixels = size * size;
        float weight = 1.0f / (float)pixels;
        float[] elements = new float[pixels];
        for (int i = 0; i < pixels; ++i) {
            elements[i] = weight;
        }
        Kernel myKernel = new Kernel(size, size, elements);
        ConvolveOp simpleBlur = new ConvolveOp(myKernel);
        simpleBlur.filter(source, result);
        return result;
    }

    public static BufferedImage quickBlur(BufferedImage source, int hRadius, int vRadius, int iterations) {
        int width = source.getWidth();
        int height = source.getHeight();
        BufferedImage result = new BufferedImage(width, height, source.getType());
        int[] inPixels = new int[width * height];
        int[] outPixels = new int[width * height];
        ImageUtils.getRGB(source, 0, 0, width, height, inPixels);
        for (int i = 0; i < iterations; ++i) {
            ImageUtils.blur(inPixels, outPixels, width, height, hRadius);
            ImageUtils.blur(outPixels, inPixels, height, width, vRadius);
        }
        ImageUtils.setRGB(result, 0, 0, width, height, inPixels);
        return result;
    }

    public static int[] getRGB(BufferedImage image, int x, int y, int width, int height, int[] pixels) {
        int type = image.getType();
        if (type == 2 || type == 1) {
            return (int[])image.getRaster().getDataElements(x, y, width, height, pixels);
        }
        return image.getRGB(x, y, width, height, pixels, 0, width);
    }

    public static void setRGB(BufferedImage image, int x, int y, int width, int height, int[] pixels) {
        int type = image.getType();
        if (type == 2 || type == 1) {
            image.getRaster().setDataElements(x, y, width, height, pixels);
        } else {
            image.setRGB(x, y, width, height, pixels, 0, width);
        }
    }

    public static void blur(int[] in, int[] out, int width, int height, int radius) {
        int widthMinus1 = width - 1;
        int tableSize = 2 * radius + 1;
        int[] divide = new int[256 * tableSize];
        for (int i = 0; i < 256 * tableSize; ++i) {
            divide[i] = i / tableSize;
        }
        int inIndex = 0;
        for (int y = 0; y < height; ++y) {
            int outIndex = y;
            int ta = 0;
            int tr = 0;
            int tg = 0;
            int tb = 0;
            for (int i = -radius; i <= radius; ++i) {
                int rgb = in[inIndex + MathUtils.clamp(i, 0, width - 1)];
                ta += rgb >> 24 & 0xFF;
                tr += rgb >> 16 & 0xFF;
                tg += rgb >> 8 & 0xFF;
                tb += rgb & 0xFF;
            }
            for (int x = 0; x < width; ++x) {
                int i2;
                out[outIndex] = divide[ta] << 24 | divide[tr] << 16 | divide[tg] << 8 | divide[tb];
                int i1 = x + radius + 1;
                if (i1 > widthMinus1) {
                    i1 = widthMinus1;
                }
                if ((i2 = x - radius) < 0) {
                    i2 = 0;
                }
                int rgb1 = in[inIndex + i1];
                int rgb2 = in[inIndex + i2];
                ta += (rgb1 >> 24 & 0xFF) - (rgb2 >> 24 & 0xFF);
                tr += (rgb1 & 0xFF0000) - (rgb2 & 0xFF0000) >> 16;
                tg += (rgb1 & 0xFF00) - (rgb2 & 0xFF00) >> 8;
                tb += (rgb1 & 0xFF) - (rgb2 & 0xFF);
                outIndex += height;
            }
            inIndex += width;
        }
    }

    @Deprecated
    public static void softClip(BufferedImage destination, BufferedImage source, Shape clipShape, int sourceOffsetX, int sourceOffsetY) {
        int width = destination.getWidth();
        int height = destination.getHeight();
        Graphics2D g1 = destination.createGraphics();
        GraphicsConfiguration gc = g1.getDeviceConfiguration();
        BufferedImage img = gc.createCompatibleImage(width, height, 3);
        Graphics2D g2 = img.createGraphics();
        g2.setComposite(AlphaComposite.Clear);
        g2.fillRect(0, 0, width, height);
        g2.setComposite(AlphaComposite.Src);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g2.setClip(clipShape);
        g2.setColor(Color.WHITE);
        g2.fill(clipShape);
        g2.setComposite(AlphaComposite.SrcAtop);
        g2.drawImage((Image)source, sourceOffsetX, sourceOffsetY, null);
        g2.dispose();
        g1.drawImage((Image)img, 0, 0, null);
        g1.dispose();
    }

    public static int getRGBClamped(BufferedImage image, int x, int y) {
        int xClamped = MathUtils.clamp(x, 0, image.getWidth() - 1);
        int yClamped = MathUtils.clamp(y, 0, image.getHeight() - 1);
        return image.getRGB(xClamped, yClamped);
    }

    public static int getRGBTiled(BufferedImage image, int x, int y, boolean flip, int blendMargin) {
        boolean flipX;
        int widthInside = image.getWidth() - blendMargin * 2;
        int heightInside = image.getHeight() - blendMargin * 2;
        boolean bl = flip && Math.abs(x) / widthInside % 2 == (x < 0 ? 0 : 1) ? true : (flipX = false);
        boolean flipY = flip && Math.abs(y) / heightInside % 2 == (y < 0 ? 0 : 1);
        int xInside = MathUtils.modulus(flipX ? -(x + 1) : x, widthInside);
        int yInside = MathUtils.modulus(flipY ? -(y + 1) : y, heightInside);
        int xSrc = blendMargin + xInside;
        int ySrc = blendMargin + yInside;
        int srcColor = image.getRGB(xSrc, ySrc);
        if (blendMargin > 0) {
            int xInsideRight = widthInside - xInside - 1;
            int yInsideUp = heightInside - yInside - 1;
            int xOther = -1;
            int yOther = -1;
            float xBlendWeight = 0.0f;
            float yBlendWeight = 0.0f;
            if (xInsideRight < blendMargin) {
                xOther = blendMargin - xInsideRight - 1;
                xBlendWeight = (1.0f - (float)(xInsideRight + 1) / (float)blendMargin) / 2.0f;
            }
            if (xInside < blendMargin) {
                xOther = image.getWidth() - blendMargin + xInside;
                xBlendWeight = (1.0f - (float)(xInside + 1) / (float)blendMargin) / 2.0f;
            }
            if (yInsideUp < blendMargin) {
                yOther = blendMargin - yInsideUp - 1;
                yBlendWeight = (1.0f - (float)(yInsideUp + 1) / (float)blendMargin) / 2.0f;
            }
            if (yInside < blendMargin) {
                yOther = image.getHeight() - blendMargin + yInside;
                yBlendWeight = (1.0f - (float)(yInside + 1) / (float)blendMargin) / 2.0f;
            }
            if (yOther != -1) {
                if (xOther != -1) {
                    int srcBlendColor = ColorUtils.blend(srcColor, image.getRGB(xOther, ySrc), xBlendWeight);
                    int otherBlendColor = ColorUtils.blend(image.getRGB(xSrc, yOther), image.getRGB(xOther, yOther), xBlendWeight);
                    return ColorUtils.blend(srcBlendColor, otherBlendColor, yBlendWeight);
                }
                return ColorUtils.blend(srcColor, image.getRGB(xSrc, yOther), yBlendWeight);
            }
            if (xOther != -1) {
                return ColorUtils.blend(srcColor, image.getRGB(xOther, ySrc), xBlendWeight);
            }
        }
        return srcColor;
    }

    public static void drawVertex(Graphics2D graphics, Point point, Color color, int size, String label) {
        graphics.setColor(color);
        int x = (int)point.getX();
        int y = (int)point.getY();
        graphics.drawLine(x - size, y, x + size, y);
        graphics.drawLine(x, y - size, x, y + size);
        if (label != null) {
            graphics.drawString(label, point.x + 2, point.y - 2);
        }
    }

    public static boolean isAccelerated(BufferedImage image) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsConfiguration gc = ge.getDefaultScreenDevice().getDefaultConfiguration();
        ImageCapabilities capabilities = image.getCapabilities(gc);
        return capabilities.isAccelerated();
    }
}

