/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.util;

import com.sodiumarc.patchwork.render.scenegraph.Transform3D;
import com.sodiumarc.patchwork.util.GeometricAxis;
import com.sodiumarc.patchwork.util.MathUtils;
import com.sodiumarc.patchwork.util.StringUtils;
import java.text.DecimalFormat;
import java.util.Set;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public final class VectorUtils {
    public static boolean parallel(Vector3d v0, Vector3d v1, double epsilon) {
        return MathUtils.epsilonEquals(v0.dot(v1), Math.abs(v0.length()) * Math.abs(v1.length()), epsilon);
    }

    public static Vector3d scaledDelataVector(Tuple3d point0, Tuple3d point1, double scale) {
        Vector3d deltaVector = new Vector3d(point1);
        deltaVector.sub(point0);
        deltaVector.scale(scale);
        return deltaVector;
    }

    public static Point3d midPoint(Point3d point0, Point3d point1) {
        return new Point3d((point0.x + point1.x) / 2.0, (point0.y + point1.y) / 2.0, (point0.z + point1.z) / 2.0);
    }

    public static double pointPlaneDistance(Point3d point, Point3d planePoint, Vector3d planeUnitNormal) {
        Vector3d v0 = new Vector3d(point);
        v0.sub(planePoint);
        return v0.dot(planeUnitNormal);
    }

    public static double parametricLinePlaneIntersection(Point3d e0, Point3d e1, Point3d planePoint, Vector3d planeUnitNormal) {
        Vector3d e0ToE1 = new Vector3d(e1);
        e0ToE1.sub(e0);
        Vector3d e0ToPlanePoint = new Vector3d(planePoint);
        e0ToPlanePoint.sub(e0);
        return planeUnitNormal.dot(e0ToPlanePoint) / planeUnitNormal.dot(e0ToE1);
    }

    public static Point3d getLinePoint(Point3d e0, Point3d e1, double t, Point3d result) {
        result.sub(e1, e0);
        result.scale(t);
        result.add(e0);
        return result;
    }

    public static double getComponent(Tuple3d tuple, GeometricAxis axis) {
        switch (axis) {
            case X: {
                return tuple.getX();
            }
            case Y: {
                return tuple.getY();
            }
            case Z: {
                return tuple.getZ();
            }
        }
        return Double.NaN;
    }

    public static GeometricAxis getMinDimension(Tuple3d tuple) {
        GeometricAxis result = GeometricAxis.X;
        for (GeometricAxis axis : GeometricAxis.values()) {
            if (!(VectorUtils.getComponent(tuple, axis) < VectorUtils.getComponent(tuple, result))) continue;
            result = axis;
        }
        return result;
    }

    public static GeometricAxis getMaxDimension(Tuple3d tuple) {
        GeometricAxis result = GeometricAxis.X;
        for (GeometricAxis axis : GeometricAxis.values()) {
            if (!(VectorUtils.getComponent(tuple, axis) > VectorUtils.getComponent(tuple, result))) continue;
            result = axis;
        }
        return result;
    }

    public static void setComponent(Tuple3d tuple, GeometricAxis axis, double value) {
        switch (axis) {
            case X: {
                tuple.setX(value);
                break;
            }
            case Y: {
                tuple.setY(value);
                break;
            }
            case Z: {
                tuple.setZ(value);
            }
        }
    }

    public static boolean epsilonEquals(Tuple3d t0, Tuple3d t1, double epsilon, Set<GeometricAxis> axes) {
        for (GeometricAxis axis : axes) {
            if (MathUtils.epsilonEquals(VectorUtils.getComponent(t0, axis), VectorUtils.getComponent(t1, axis), epsilon)) continue;
            return false;
        }
        return true;
    }

    public static String toString(Tuple3d tuple) {
        return tuple.x + "," + tuple.y + "," + tuple.z;
    }

    public static String toString(Tuple3d tuple, DecimalFormat format) {
        return format.format(tuple.x) + "," + format.format(tuple.y) + "," + format.format(tuple.z);
    }

    public static String toString(Transform3D xform) {
        double[] values = new double[16];
        xform.get(values);
        return StringUtils.toDelimitedList(values, ",");
    }

    public static Transform3D decodeTransform3D(String encoded) {
        double[] values = StringUtils.decodeDoubleArray(encoded, ",");
        return new Transform3D(values);
    }

    public static Vector3d decodeVector3d(String string) {
        String[] components = string.split(",");
        assert (components.length == 3) : "Wrong number of components: " + components.length;
        return new Vector3d(Double.valueOf(components[0]), Double.valueOf(components[1]), Double.valueOf(components[2]));
    }

    public static Point3d decodePoint3d(String string) {
        String[] components = string.split(",");
        assert (components.length == 3) : "Wrong number of components: " + components.length;
        return new Point3d(Double.valueOf(components[0]), Double.valueOf(components[1]), Double.valueOf(components[2]));
    }

    private VectorUtils() {
    }
}

