/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.util;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class StringTemplate {
    private final String _id;
    private String _templateText;
    private final Set<String> _localParameters;
    private final Map<String, String> _valuesByParameterName;
    private final Map<String, List<StringTemplate>> _subtemplatesByParameterName;
    private static final char ESCAPE_CHARACTER = '$';
    private static final char OPEN_BRACKET_CHARACTER = '{';
    private static final char CLOSE_BRACKET_CHARACTER = '}';

    public StringTemplate(String id) {
        this._id = id;
        this._localParameters = new TreeSet<String>();
        this._valuesByParameterName = new HashMap<String, String>();
        this._subtemplatesByParameterName = new HashMap<String, List<StringTemplate>>();
    }

    public StringTemplate(String id, String text) {
        this(id);
        this.setText(text);
    }

    public String getId() {
        return this._id;
    }

    public void setText(String text) {
        if (text == null) {
            throw new NullPointerException();
        }
        this._templateText = text;
    }

    public boolean isSatisfied() throws ParseException {
        boolean satisfied = true;
        for (String parameterName : this.getParameterNames()) {
            if (this._valuesByParameterName.get(parameterName) == null) {
                List<StringTemplate> subtemplates = this._subtemplatesByParameterName.get(parameterName);
                if (subtemplates == null) {
                    satisfied = false;
                } else {
                    boolean subtemplateSatisfied = false;
                    for (StringTemplate subtemplate : subtemplates) {
                        if (!subtemplate.isSatisfied()) continue;
                        subtemplateSatisfied = true;
                        break;
                    }
                    if (!subtemplateSatisfied) {
                        satisfied = false;
                    }
                }
            }
            if (satisfied) continue;
            break;
        }
        return satisfied;
    }

    public Set<String> getParameterNames() throws ParseException {
        if (this._localParameters.size() == 0) {
            this.process(false);
        }
        TreeSet<String> parameterNames = new TreeSet<String>();
        parameterNames.addAll(this._localParameters);
        for (List<StringTemplate> subtemplates : this._subtemplatesByParameterName.values()) {
            for (StringTemplate subtemplate : subtemplates) {
                parameterNames.addAll(subtemplate.getParameterNames());
            }
        }
        return Collections.unmodifiableSet(this._localParameters);
    }

    public void setParameterValue(String parameterName, String value) {
        if (parameterName == null || parameterName.length() == 0) {
            throw new IllegalArgumentException("Invalid parameter name.");
        }
        if (this._subtemplatesByParameterName.get(parameterName) != null) {
            throw new IllegalArgumentException("Parameter \"" + parameterName + "\" already has associated sub-templates.");
        }
        this._valuesByParameterName.put(parameterName, value);
        for (List<StringTemplate> subtemplates : this._subtemplatesByParameterName.values()) {
            for (StringTemplate subtemplate : subtemplates) {
                subtemplate.setParameterValue(parameterName, value);
            }
        }
    }

    public void setParameterValueQuoted(String parameterName, String value) {
        String quotedValue = value == null ? "null" : "\"" + value + "\"";
        this.setParameterValue(parameterName.toString(), quotedValue);
    }

    public void setParameterValueNullable(String parameterName, String value) {
        value = value == null ? "null" : value;
        this.setParameterValue(parameterName.toString(), value);
    }

    public void setParameterValue(Object parameterName, String value) {
        this.setParameterValue(parameterName.toString(), value);
    }

    public void setParameterValue(Object parameterName, double value) {
        this.setParameterValue(parameterName.toString(), Double.toString(value));
    }

    public void setParameterValue(Object parameterName, float value) {
        this.setParameterValue(parameterName.toString(), Float.toString(value));
    }

    public void setParameterValue(Object parameterName, long value) {
        this.setParameterValue(parameterName.toString(), Long.toString(value));
    }

    public void clearParameterValues() {
        this._valuesByParameterName.clear();
        for (List<StringTemplate> subtemplates : this._subtemplatesByParameterName.values()) {
            for (StringTemplate subtemplate : subtemplates) {
                subtemplate.clearParameterValues();
            }
        }
    }

    public void addSubtemplate(String parameterName, StringTemplate subtemplate) {
        if (parameterName == null || parameterName.length() == 0) {
            throw new IllegalArgumentException("Invalid parameter name.");
        }
        if (subtemplate == null) {
            throw new NullPointerException();
        }
        if (this._valuesByParameterName.get(parameterName) != null) {
            throw new IllegalArgumentException("Parameter \"" + parameterName + "\" has already been assigned a value.");
        }
        List<StringTemplate> subtemplates = this._subtemplatesByParameterName.get(parameterName);
        if (subtemplates == null) {
            subtemplates = new ArrayList<StringTemplate>();
            this._subtemplatesByParameterName.put(parameterName, subtemplates);
        }
        subtemplates.add(subtemplate);
    }

    public String getUnprocessedText() {
        return this._templateText;
    }

    public String getProcessedText() throws ParseException {
        return this.process(true);
    }

    private String process(boolean performsubstitution) throws ParseException {
        StringBuilder processedBuffer = new StringBuilder();
        StringBuilder parameterNameBuffer = new StringBuilder();
        ParseContext parseContext = ParseContext.PLAIN_TEXT;
        int n = this._templateText.length();
        block5: for (int i = 0; i < n; ++i) {
            char c = this._templateText.charAt(i);
            switch (c) {
                case '$': {
                    if (parseContext == ParseContext.ESCAPED) {
                        processedBuffer.append(c);
                        parseContext = ParseContext.PLAIN_TEXT;
                        continue block5;
                    }
                    if (parseContext == ParseContext.PARAMETER_NAME) {
                        this.badCharacter(c, i);
                        continue block5;
                    }
                    parseContext = ParseContext.ESCAPED;
                    continue block5;
                }
                case '{': {
                    if (parseContext == ParseContext.ESCAPED) {
                        parseContext = ParseContext.PARAMETER_NAME;
                        continue block5;
                    }
                    if (parseContext == ParseContext.PARAMETER_NAME) {
                        this.badCharacter(c, i);
                        continue block5;
                    }
                    processedBuffer.append(c);
                    continue block5;
                }
                case '}': {
                    if (parseContext == ParseContext.ESCAPED) {
                        this.badCharacter(c, i);
                        continue block5;
                    }
                    if (parseContext == ParseContext.PARAMETER_NAME) {
                        if (parameterNameBuffer.length() == 0) {
                            throw new ParseException("Parameter name expected at position " + i + ".", i);
                        }
                        String parameterName = parameterNameBuffer.toString();
                        this._localParameters.add(parameterName);
                        if (performsubstitution) {
                            processedBuffer.append(this.getParameterSubstitution(parameterName));
                        }
                        parameterNameBuffer.setLength(0);
                        parseContext = ParseContext.PLAIN_TEXT;
                        continue block5;
                    }
                    processedBuffer.append(c);
                    continue block5;
                }
                default: {
                    if (parseContext == ParseContext.ESCAPED) {
                        this.badCharacter(c, i);
                        continue block5;
                    }
                    if (parseContext == ParseContext.PARAMETER_NAME) {
                        parameterNameBuffer.append(c);
                        continue block5;
                    }
                    processedBuffer.append(c);
                }
            }
        }
        return processedBuffer.toString();
    }

    private void badCharacter(char c, int offset) throws ParseException {
        throw new ParseException("Invalid character at position " + offset + ": '" + c + "'", offset);
    }

    private String getParameterSubstitution(String parameterName) throws ParseException {
        List<StringTemplate> subtemplates;
        String parameterValue = this._valuesByParameterName.get(parameterName);
        if (parameterValue == null && (subtemplates = this._subtemplatesByParameterName.get(parameterName)) != null) {
            for (StringTemplate subtemplate : subtemplates) {
                if (!subtemplate.isSatisfied()) continue;
                parameterValue = subtemplate.getProcessedText();
                break;
            }
        }
        return parameterValue == null ? "" : parameterValue;
    }

    private static enum ParseContext {
        PLAIN_TEXT,
        ESCAPED,
        PARAMETER_NAME;

    }
}

