/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class LoggerStream
extends PrintStream {
    private static PrintStream originalErr;
    private static PrintStream originalOut;
    private static LoggerStream loggerErr;
    private static LoggerStream loggerOut;
    private final Logger logger;
    private final Level level;
    private Map<String, Level> overrides = new HashMap<String, Level>();

    public LoggerStream(Class<?> logClass, Level level) {
        this(Logger.getLogger(logClass), level);
    }

    public LoggerStream(String name, Level level) {
        this(Logger.getLogger(name), level);
    }

    public LoggerStream(Logger logger, Level level) {
        super(new InnerStream(), true);
        ((InnerStream)this.out).setOuter(this);
        this.logger = logger;
        this.level = level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOverride(String logName, Level level) {
        assert (level != null);
        Map<String, Level> map = this.overrides;
        synchronized (map) {
            this.overrides.put(logName, level);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOverride(String logName) {
        Map<String, Level> map = this.overrides;
        synchronized (map) {
            this.overrides.remove(logName);
        }
    }

    Logger getLogger() {
        return this.logger;
    }

    Level getLevel() {
        return this.level;
    }

    public static PrintStream getOriginalErr() {
        return originalErr == null ? System.err : originalErr;
    }

    public static PrintStream getOriginalOut() {
        return originalOut == null ? System.out : originalOut;
    }

    public static LoggerStream getLoggerErr() {
        return loggerErr;
    }

    public static LoggerStream getLoggerOut() {
        return loggerOut;
    }

    public static void rerouteSystemToLog4j() {
        if (originalErr != null) {
            return;
        }
        originalErr = System.err;
        originalOut = System.out;
        loggerErr = new LoggerStream("", Level.ERROR);
        System.setErr(loggerErr);
        loggerOut = new LoggerStream("", Level.INFO);
        System.setOut(loggerOut);
    }

    private static class InnerStream
    extends ByteArrayOutputStream {
        private LoggerStream loggerStream;

        private InnerStream() {
        }

        void setOuter(LoggerStream loggerStream) {
            this.loggerStream = loggerStream;
        }

        @Override
        public void close() {
            this.flush();
        }

        @Override
        public void flush() {
            if (this.loggerStream == null) {
                return;
            }
            String contents = this.toString();
            if (contents == null || contents.trim().isEmpty()) {
                return;
            }
            try {
                Logger logger = this.loggerStream.getLogger();
                logger.log(Priority.ERROR, contents);
            }
            catch (StackOverflowError stackOverflowError) {
                // empty catch block
            }
            this.reset();
        }
    }
}

