/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.util.Collection;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class CompoundIterator<T>
implements Iterator<T> {
    private final List<Iterator<T>> _subIterators;
    private int _subIteratorIndex;
    private T _next;
    private boolean _hasNext;

    public CompoundIterator(List<Iterable<T>> iterables) {
        assert (iterables != null);
        this._subIterators = new ArrayList<Iterator<T>>(iterables.size());
        for (Iterable<T> iterable : iterables) {
            this._subIterators.add(iterable.iterator());
        }
        this._subIteratorIndex = 0;
        this.updateNext();
    }

    @Override
    public boolean hasNext() {
        return this._hasNext;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T next = this._next;
        this.updateNext();
        return next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void updateNext() {
        this._next = null;
        this._hasNext = false;
        Iterator<T> subIterator = null;
        while (this._subIteratorIndex < this._subIterators.size()) {
            subIterator = this._subIterators.get(this._subIteratorIndex);
            if (subIterator.hasNext()) {
                this._next = subIterator.next();
                this._hasNext = true;
                break;
            }
            ++this._subIteratorIndex;
        }
    }
}

