/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.sketch;

import com.sodiumarc.patchwork.render.RenderResourceIO;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class StippleMap {
    private int[] _stippleData;
    private int _stippleWidth;
    private int _stippleHeight;
    private int _stippleWidthInIntegers;

    public StippleMap(String filename) throws IOException {
        int indexOffset;
        int x;
        int rowBaseIndex;
        StringBuffer rowString;
        int y;
        BufferedImage image = RenderResourceIO.getInstance().getInputImage(filename);
        Logger logger = Logger.getLogger(this.getClass());
        logger.debug("Stipple Map: " + image.getWidth() + " x " + image.getHeight());
        this._stippleWidth = image.getWidth();
        this._stippleHeight = image.getHeight();
        this._stippleWidthInIntegers = this._stippleWidth / 32;
        this._stippleData = new int[this._stippleWidthInIntegers * this._stippleHeight];
        for (y = 0; y < image.getHeight(); ++y) {
            rowString = new StringBuffer();
            rowBaseIndex = y * this._stippleWidthInIntegers;
            for (x = 0; x < image.getWidth(); ++x) {
                indexOffset = x / 32;
                if (indexOffset >= this._stippleWidthInIntegers) continue;
                int bitOffset = 31 - x % 32;
                int colorInt = image.getRGB(x, y);
                int r = colorInt >> 16 & 0xFF;
                int bit = r < 100 ? 1 : 0;
                int stippleInt = this._stippleData[rowBaseIndex + indexOffset];
                this._stippleData[rowBaseIndex + indexOffset] = stippleInt | bit << bitOffset;
                rowString.append(bit + " ");
            }
        }
        for (y = 0; y < image.getHeight(); ++y) {
            rowString = new StringBuffer();
            rowBaseIndex = y * this._stippleWidthInIntegers;
            for (x = 0; x < image.getWidth(); ++x) {
                indexOffset = x / 32;
                int stippleInt = this._stippleData[rowBaseIndex + indexOffset];
                int bitOffset = 31 - x % 32;
                rowString.append(stippleInt >> bitOffset & 1);
                rowString.append(" ");
            }
        }
    }

    public int getWidth() {
        return this._stippleWidth;
    }

    public int getHeight() {
        return this._stippleHeight;
    }

    public List<Point> getStipples(int width, int height, int stippleScale) {
        ArrayList<Point> stipples = new ArrayList<Point>(100);
        for (int py = 0; py < height; ++py) {
            for (int px = 0; px < width; ++px) {
                boolean stipple = false;
                if (px % stippleScale == 0 && py % stippleScale == 0) {
                    stipple = this.isStipple(px / stippleScale, py / stippleScale);
                }
                if (!stipple) continue;
                stipples.add(new Point(px, py));
            }
        }
        return stipples;
    }

    public void printStippleData(int[] stippleData) {
        StringBuffer arrayString = new StringBuffer();
        for (int i = 0; i < stippleData.length; ++i) {
            if (arrayString.length() > 0) {
                arrayString.append(",");
            }
            arrayString.append("0x" + Integer.toHexString(stippleData[i]).toUpperCase());
        }
        System.out.println("new Array(" + arrayString + ")");
    }

    private boolean isStipple(int x, int y) {
        int xWrapped = x < 0 ? this._stippleWidth - x % this._stippleWidth : x % this._stippleWidth;
        int yWrapped = y < 0 ? this._stippleHeight - y % this._stippleHeight : y % this._stippleHeight;
        int index = yWrapped * this._stippleWidthInIntegers + (int)Math.floor(xWrapped / 32);
        int bitOffset = 31 - xWrapped % 32;
        return (this._stippleData[index] >> bitOffset & 1) == 1;
    }
}

