/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.sketch;

import com.sodiumarc.patchwork.sketch.SketchAsset;
import com.sodiumarc.patchwork.sketch.SketchAssetLibrary;
import com.sodiumarc.patchwork.sketch.StippleMap;
import com.sodiumarc.patchwork.util.Collection.Pair;
import com.sodiumarc.patchwork.util.Collection.Range;
import com.sodiumarc.patchwork.util.ColorComponent;
import com.sodiumarc.patchwork.util.ColorUtils;
import com.sodiumarc.patchwork.util.MathUtils;
import com.sodiumarc.patchwork.util.image.ImageFilter;
import com.sodiumarc.patchwork.util.image.ImageUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Properties;

public class Splotcher
implements ImageFilter {
    public static final int MAX_SPLOTCHES_PER_PIXEL = 3;
    public static final String STIPPLE_FILE = "stipples/Stipple32.jpg";
    public static final String[] HATCH_FILES = new String[]{"splotches/hatch01.jpg", "splotches/hatch02.jpg", "splotches/hatch03.jpg", "splotches/hatch04.jpg", "splotches/hatch05.jpg", "splotches/hatch06.jpg", "splotches/hatch07.jpg"};
    public static final String[] SWIRL_FILES = new String[]{"splotches/swirl01.jpg", "splotches/swirl02.jpg", "splotches/swirl03.jpg", "splotches/swirl04.jpg", "splotches/swirl05.jpg", "splotches/swirl06.jpg"};
    public static final String[] SCRIBBLE_FILES = new String[]{"splotches/scribble01.jpg", "splotches/scribble02.jpg", "splotches/scribble03.jpg"};
    private final List<Pair<Range<Integer>, SketchAssetLibrary>> _splotchLibraries;
    private final StippleMap _stippleMap;
    private final int _width;
    private final int _height;
    private final int _stippleScale;
    private final ArrayList<SplotchData> _splotches = new ArrayList();
    private PixelData[] _pixelData;
    private static Splotcher DEFAULT_INSTANCE;

    public static Splotcher getDefaultInstance() throws IOException {
        if (DEFAULT_INSTANCE == null) {
            DEFAULT_INSTANCE = new Splotcher(new Dimension(500, 500), new StippleMap(STIPPLE_FILE), 2);
            DEFAULT_INSTANCE.addSplotchLibrary(new SketchAssetLibrary(SWIRL_FILES, 1.0f, 0.8f), 0, 255);
        }
        return DEFAULT_INSTANCE;
    }

    public Splotcher(Dimension dimensions, StippleMap stippleMap, int stippleScale) {
        this._width = dimensions.width;
        this._height = dimensions.height;
        this._pixelData = new PixelData[this._width * this._height];
        this._splotchLibraries = new ArrayList<Pair<Range<Integer>, SketchAssetLibrary>>();
        this._stippleMap = stippleMap;
        this._stippleScale = stippleScale;
    }

    public int getWidth() {
        return this._width;
    }

    public int getHeight() {
        return this._height;
    }

    public void addSplotchLibrary(SketchAssetLibrary library, int minIntensity, int maxIntensity) {
        this._splotchLibraries.add(new Pair<Range<Integer>, SketchAssetLibrary>(new Range<Integer>(minIntensity, maxIntensity), library));
    }

    public BufferedImage createSplotchImageFast(Rectangle region, BufferedImage sourceImage, int maxColorError) {
        BufferedImage scaledSource = ImageUtils.scale(sourceImage, (float)this._width / (float)sourceImage.getWidth(), (float)this._height / (float)sourceImage.getHeight());
        BufferedImage result = new BufferedImage(this._width, this._height, 2);
        Graphics2D g = result.createGraphics();
        g.setComposite(AlphaComposite.SrcOver);
        g.drawImage(scaledSource, null, null);
        for (SplotchData splotchData : this._splotches) {
            Color sourceColor = new Color(scaledSource.getRGB(splotchData.sourceX, splotchData.sourceY));
            splotchData.color = ColorUtils.getErrorColor(sourceColor, maxColorError);
        }
        EnumMap<ColorComponent, Integer> components = new EnumMap<ColorComponent, Integer>(ColorComponent.class);
        for (int y = 0; y < this._height; ++y) {
            for (int x = 0; x < this._width; ++x) {
                for (ColorComponent component : ColorComponent.values()) {
                    components.put(component, 0);
                }
                PixelData pixelData = this.getPixelData(x, y);
                float remainderWeight = 1.0f;
                for (int i = pixelData.splotchCount - 1; i >= 0; --i) {
                    SplotchData splotchData = pixelData.splotches[i];
                    float weight = Math.min(pixelData.splotchWeights[i], remainderWeight);
                    for (ColorComponent component : ColorComponent.values()) {
                        components.put(component, (int)((float)((Integer)components.get((Object)component)).intValue() + (float)ColorUtils.getComponent(splotchData.color, component) * weight));
                    }
                    remainderWeight -= weight;
                }
                Color sourceColor = new Color(scaledSource.getRGB(x, y));
                for (ColorComponent component : ColorComponent.values()) {
                    components.put(component, (int)((float)((Integer)components.get((Object)component)).intValue() + (float)ColorUtils.getComponent(sourceColor, component) * remainderWeight));
                }
                Color adjustedColor = ColorUtils.toColor(components);
                result.setRGB(x, y, adjustedColor.getRGB());
            }
        }
        return result;
    }

    public BufferedImage createSplotchImageSlow(Rectangle region, BufferedImage source, int maxColorError, int maxIntensity) {
        BufferedImage scaledSource = ImageUtils.scale(source, (float)region.width / (float)source.getWidth(), (float)region.height / (float)source.getHeight());
        BufferedImage result = new BufferedImage(region.width, region.height, 2);
        Graphics2D g = result.createGraphics();
        g.setComposite(AlphaComposite.SrcOver);
        g.drawImage(scaledSource, null, null);
        List<Point> stipples = this._stippleMap.getStipples(region.width, region.height, this._stippleScale);
        float colorCorrection = 0.45f;
        this.orderStipplesByIntensity(stipples, scaledSource, false);
        for (Point stipple : stipples) {
            SketchAsset splotch;
            Color pixelColor = new Color(scaledSource.getRGB(stipple.x, stipple.y));
            int pixelIntensity = ColorUtils.getIntensity(pixelColor);
            if (pixelIntensity > maxIntensity || (splotch = this.getSplotch(pixelColor)) == null) continue;
            int lightestAdjacentColor = this.getLightestAdjacentColor(splotch, scaledSource, stipple);
            Color tweakedColor = new Color(ColorUtils.blend(pixelColor.getRGB(), lightestAdjacentColor, colorCorrection));
            Color errorColor = ColorUtils.getErrorColor(tweakedColor, maxColorError);
            BufferedImage splotchImage = splotch.makeSplotchImage(errorColor, false);
            int w = splotchImage.getWidth();
            int h = splotchImage.getHeight();
            Point adjustedLoc = stipple;
            g.drawImage(splotchImage, adjustedLoc.x - w / 2, adjustedLoc.y - h / 2, adjustedLoc.x + w / 2, adjustedLoc.y + h / 2, 0, 0, w, h, null);
        }
        g.dispose();
        return result;
    }

    @Override
    public BufferedImage apply(BufferedImage input, Properties properties) {
        if (properties == null) {
            properties = new Properties();
        }
        int maxColorError = Integer.valueOf(properties.getProperty("maxColorError", "20"));
        int maxIntensity = Integer.valueOf(properties.getProperty("maxIntensity", "255"));
        return this.createSplotchImageSlow(new Rectangle(0, 0, input.getWidth(), input.getHeight()), input, maxColorError, maxIntensity);
    }

    private SketchAsset getSplotch(Color color) {
        int intensity = ColorUtils.getIntensity(color);
        SketchAssetLibrary library = null;
        for (Pair<Range<Integer>, SketchAssetLibrary> pair : this._splotchLibraries) {
            Range<Integer> range = pair.getFirst();
            if (intensity <= range.getMin() && range.getMin() != -1 || intensity >= range.getMax() && range.getMax() != -1) continue;
            library = pair.getSecond();
        }
        if (library != null) {
            return library.randomAsset();
        }
        return null;
    }

    private int getLightestAdjacentColor(SketchAsset splotch, BufferedImage source, Point srcLocation) {
        int result = 0;
        int radius = Math.max(splotch.getWidth(), splotch.getHeight()) / 2;
        int directions = 8;
        double angle = 0.0;
        double angleStep = Math.PI * 2 / (double)directions;
        int maxIntensity = Integer.MIN_VALUE;
        for (int i = 0; i < directions; ++i) {
            int y;
            int x = srcLocation.x + (int)((double)radius * Math.sin(angle));
            int srcColor = ImageUtils.getRGBClamped(source, x, y = srcLocation.y + (int)((double)radius * Math.cos(angle)));
            int intensity = ColorUtils.getIntensity(srcColor);
            if (intensity > maxIntensity) {
                result = srcColor;
                maxIntensity = intensity;
            }
            angle += angleStep;
        }
        return result;
    }

    private void orderStipplesByIntensity(List<Point> stipples, final BufferedImage source, final boolean increasing) {
        Collections.sort(stipples, new Comparator<Point>(){

            @Override
            public int compare(Point p0, Point p1) {
                int i0 = ColorUtils.getIntensity(source.getRGB(p0.x, p0.y));
                int i1 = ColorUtils.getIntensity(source.getRGB(p1.x, p1.y));
                return increasing ? i0 - i1 : i1 - i0;
            }
        });
    }

    private void addSplotch(PixelData[] pixelData, SketchAsset splotch, int x, int y) {
        SplotchData splotchData = new SplotchData(splotch, x, y);
        this._splotches.add(splotchData);
        int width = splotch.getWidth();
        int height = splotch.getHeight();
        int xMin = x - width / 2;
        int yMin = y - height / 2;
        for (int dy = 0; dy < height; ++dy) {
            for (int dx = 0; dx < width; ++dx) {
                int px = MathUtils.modulus(xMin + dx, this._width);
                int py = MathUtils.modulus(yMin + dy, this._height);
                PixelData pixel = this._pixelData[py * this._width + px];
                pixel.addSplotchContribution(splotchData, splotch.getNormalizedWeight(dx, dy));
            }
        }
    }

    private PixelData getPixelData(int x, int y) {
        return this._pixelData[y * this._width + x];
    }

    private static class SplotchData {
        final SketchAsset splotch;
        final int sourceX;
        final int sourceY;
        Color color = Color.WHITE;

        SplotchData(SketchAsset splotch, int sourceX, int sourceY) {
            this.splotch = splotch;
            this.sourceX = sourceX;
            this.sourceY = sourceY;
        }
    }

    private static class PixelData {
        final int maxSplotches;
        final SplotchData[] splotches;
        final float[] splotchWeights;
        float remainderWeight = 1.0f;
        int splotchCount = 0;
        private static final float MIN_CONTRIBUTION = 0.01f;

        PixelData(int maxSplotches) {
            this.maxSplotches = maxSplotches;
            this.splotches = new SplotchData[3];
            this.splotchWeights = new float[3];
        }

        void reset() {
            this.splotchCount = 0;
            this.remainderWeight = 1.0f;
        }

        void addSplotchContribution(SplotchData splotchData, float weight) {
            if (weight >= 0.01f && this.splotchCount < this.maxSplotches) {
                this.remainderWeight = Math.max(this.remainderWeight - weight, 0.0f);
                this.splotches[this.splotchCount] = splotchData;
                this.splotchWeights[this.splotchCount] = weight;
                ++this.splotchCount;
            }
        }
    }
}

