/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.sketch;

import com.sodiumarc.patchwork.sketch.SketchFiller;
import com.sodiumarc.patchwork.sketch.Splotcher;
import com.sodiumarc.patchwork.util.AppUtils;
import com.sodiumarc.patchwork.util.image.ImageUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;

public class SketchFillerTestApp {
    public static void main(String[] args) {
        try {
            int width = 400;
            int height = 400;
            SketchFiller filler = SketchFiller.getDefaultInstance();
            Splotcher splotcher = Splotcher.getDefaultInstance();
            BufferedImage source = SketchFillerTestApp.createLinearGradientTest(width, height);
            AppUtils.showImage(source);
            AppUtils.showImage(filler.createFillImage(source));
            AppUtils.showImage(splotcher.createSplotchImageSlow(new Rectangle(0, 0, source.getWidth(), source.getHeight()), source, 12, 255));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static BufferedImage createSolidTest(int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D g = image.createGraphics();
        g.setColor(Color.LIGHT_GRAY);
        g.fillRect(0, 0, width, height);
        g.dispose();
        return image;
    }

    public static BufferedImage createLinearGradientTest(int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D g = image.createGraphics();
        LinearGradientPaint paint = new LinearGradientPaint(new Point2D.Float(0.0f, 0.0f), new Point2D.Float(width, 0.0f), new float[]{0.0f, 1.0f}, new Color[]{Color.WHITE, Color.BLACK});
        g.setPaint(paint);
        g.fillRect(0, 0, width, height);
        g.dispose();
        return image;
    }

    public static BufferedImage createShortLinearGradientTest(int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D g = image.createGraphics();
        int yStart = (int)(0.4f * (float)height);
        int yEnd = (int)(0.5f * (float)height);
        g.setColor(Color.LIGHT_GRAY);
        g.fillRect(0, 0, width, height);
        LinearGradientPaint paint = new LinearGradientPaint(new Point2D.Float(0.0f, yStart), new Point2D.Float(0.0f, yEnd), new float[]{0.0f, 1.0f}, new Color[]{Color.DARK_GRAY, Color.LIGHT_GRAY});
        g.setPaint(paint);
        g.fillRect(0, yStart, width, yEnd - yStart);
        g.dispose();
        return image;
    }

    public static BufferedImage createRadialGradientTest(int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D g = image.createGraphics();
        RadialGradientPaint paint = new RadialGradientPaint(new Point2D.Float(width / 2, height / 2), (float)Math.sqrt(Math.pow(width, 2.0) + Math.pow(height, 2.0)) / 2.0f, new float[]{0.0f, 1.0f}, new Color[]{Color.YELLOW, Color.RED});
        g.setPaint(paint);
        g.fillRect(0, 0, width, height);
        g.dispose();
        return image;
    }

    public static BufferedImage createCheckerTest(int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D g = image.createGraphics();
        ImageUtils.paintCheckerboard(g, new Rectangle(0, 0, width, height), 16, 16, Color.WHITE, Color.LIGHT_GRAY);
        g.dispose();
        return image;
    }

    public static BufferedImage createShapeTest(int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D g = image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        Path2D.Double shapePath = new Path2D.Double();
        shapePath.moveTo((double)width * 0.2, (double)height * 0.4);
        shapePath.lineTo((double)width * 0.8, (double)height * 0.2);
        shapePath.lineTo((double)width * 0.6, (double)height * 0.8);
        shapePath.closePath();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, width, height);
        g.setColor(Color.BLACK);
        g.fill(shapePath);
        g.dispose();
        return image;
    }
}

