/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.sketch;

import com.sodiumarc.patchwork.render.RenderResourceIO;
import com.sodiumarc.patchwork.sketch.SketchAsset;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class SketchAssetLibrary {
    private ArrayList<SketchAsset> _assets;
    private Map<String, SketchAsset> _assetsById;
    private final float _sourceScale;

    public SketchAssetLibrary(String[] filenames, float sourceScale, float alpha) throws IOException {
        this._sourceScale = sourceScale;
        HashMap<String, BufferedImage> sourceData = new HashMap<String, BufferedImage>();
        for (String fileName : filenames) {
            sourceData.put(fileName, RenderResourceIO.getInstance().getInputImage(fileName));
        }
        this.loadLibrary(sourceData, alpha);
    }

    public SketchAssetLibrary(Map<String, BufferedImage> sourceData, float sourceScale, float alpha) {
        this._sourceScale = sourceScale;
        this.loadLibrary(sourceData, alpha);
    }

    public BufferedImage randomImage() {
        return this.randomImage(null);
    }

    public BufferedImage randomImage(Color strokeColor) {
        return this.randomAsset().makeSplotchImage(strokeColor);
    }

    public SketchAsset randomAsset() {
        int index = (int)(Math.random() * 100.0) % this._assets.size();
        return this._assets.get(index);
    }

    public Map<String, SketchAsset> getAssetsById() {
        return Collections.unmodifiableMap(this._assetsById);
    }

    public Map<String, BufferedImage> getImagesById() {
        return this.getImagesById(null, true);
    }

    public Map<String, BufferedImage> getImagesById(Color strokeColor, boolean normalize) {
        HashMap<String, BufferedImage> imagesById = new HashMap<String, BufferedImage>();
        for (Map.Entry<String, SketchAsset> entry : this._assetsById.entrySet()) {
            imagesById.put(entry.getKey(), entry.getValue().makeSplotchImage(strokeColor, normalize));
        }
        return imagesById;
    }

    public SketchAsset getAssetById(String id) {
        return this._assetsById.get(id);
    }

    private void loadLibrary(Map<String, BufferedImage> sourceData, float alpha) {
        this._assets = new ArrayList();
        this._assetsById = new LinkedHashMap<String, SketchAsset>();
        for (Map.Entry<String, BufferedImage> entry : sourceData.entrySet()) {
            SketchAsset asset = new SketchAsset(entry.getKey(), entry.getValue(), this._sourceScale, alpha);
            this._assets.add(asset);
            this._assetsById.put(asset.getIdentifier(), asset);
        }
    }
}

