/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.sketch;

import com.sodiumarc.patchwork.render.RenderResourceIO;
import com.sodiumarc.patchwork.util.ColorUtils;
import com.sodiumarc.patchwork.util.image.ImageUtils;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;

public class SketchAsset {
    private final String _identifier;
    private final int _width;
    private final int _height;
    private final float[] _rawWeightData;
    private final float[] _normalizedWeightData;
    private final Color _naturalGrey;
    private BufferedImage _splotchImage = null;

    public SketchAsset(String fileName, float scale, float alpha) throws IOException {
        this(fileName, scale, alpha, false, false);
    }

    public SketchAsset(String fileName, float scale, float alpha, boolean invertX, boolean invertY) throws IOException {
        this(fileName, RenderResourceIO.getInstance().getInputImage(fileName), scale, alpha, invertX, invertY);
    }

    public SketchAsset(String identifier, BufferedImage image, float scale, float alpha) {
        this(identifier, image, scale, alpha, false, false);
    }

    public SketchAsset(String identifier, BufferedImage image, float scale, float alpha, boolean invertX, boolean invertY) {
        int x;
        int y;
        BufferedImage scaledImage = ImageUtils.scale(image, scale, scale);
        int minIntensity = 255;
        int maxIntensity = 0;
        for (y = 0; y < scaledImage.getHeight(); ++y) {
            for (x = 0; x < scaledImage.getWidth(); ++x) {
                Color pixelColor = new Color(scaledImage.getRGB(x, y));
                int averageIntensity = (pixelColor.getRed() + pixelColor.getGreen() + pixelColor.getBlue()) / 3;
                if (averageIntensity < minIntensity) {
                    minIntensity = averageIntensity;
                }
                if (averageIntensity <= maxIntensity) continue;
                maxIntensity = averageIntensity;
            }
        }
        this._identifier = identifier;
        this._width = scaledImage.getWidth();
        this._height = scaledImage.getHeight();
        this._normalizedWeightData = new float[this._width * this._height];
        this._rawWeightData = new float[this._width * this._height];
        for (y = 0; y < this._height; ++y) {
            for (x = 0; x < this._width; ++x) {
                int i = y * this._width + x;
                int xSrc = invertX ? this._width - 1 - x : x;
                int ySrc = invertY ? this._height - 1 - y : y;
                Color pixelColor = new Color(scaledImage.getRGB(xSrc, ySrc));
                int averageIntensity = ColorUtils.getIntensity(pixelColor);
                float rawFraction = (float)averageIntensity / 255.0f;
                float normalizedFraction = (float)(averageIntensity - minIntensity) / (float)(maxIntensity - minIntensity);
                this._normalizedWeightData[i] = (1.0f - normalizedFraction) * alpha;
                this._rawWeightData[i] = (1.0f - rawFraction) * alpha;
            }
        }
        this._naturalGrey = ColorUtils.newColor(minIntensity, minIntensity, minIntensity, 255);
    }

    public String getIdentifier() {
        return this._identifier;
    }

    public int getWidth() {
        return this._width;
    }

    public int getHeight() {
        return this._height;
    }

    public float getNormalizedWeight(int x, int y) {
        return this._normalizedWeightData[y * this._width + x];
    }

    public float getWeight(int x, int y) {
        return this._rawWeightData[y * this._width + x];
    }

    public Color getNaturalGrey() {
        return this._naturalGrey;
    }

    public BufferedImage makeSplotchImage() {
        return this.makeSplotchImage(null, true);
    }

    public BufferedImage makeSplotchImage(Color splotchColor) {
        return this.makeSplotchImage(splotchColor, true);
    }

    public BufferedImage makeSplotchImage(boolean normalize) {
        return this.makeSplotchImage(null, normalize);
    }

    public BufferedImage makeSplotchImage(Color splotchColor, boolean normalize) {
        if (splotchColor == null) {
            Color color = splotchColor = normalize ? this._naturalGrey : Color.BLACK;
        }
        if (this._splotchImage == null) {
            this._splotchImage = new BufferedImage(this._width, this._height, 2);
        }
        for (int y = 0; y < this._splotchImage.getHeight(); ++y) {
            for (int x = 0; x < this._splotchImage.getWidth(); ++x) {
                float intensityFraction = normalize ? this.getNormalizedWeight(x, y) : this.getWeight(x, y);
                int alpha = (int)(intensityFraction * (float)splotchColor.getAlpha());
                int adjustedColor = ColorUtils.toIntARGB(alpha, splotchColor.getRed(), splotchColor.getGreen(), splotchColor.getBlue());
                this._splotchImage.setRGB(x, y, adjustedColor);
            }
        }
        return this._splotchImage;
    }
}

