/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.render.scenegraph;

import com.sodiumarc.patchwork.util.MathUtils;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.TreeMap;

public abstract class TransformAnimator<T> {
    private final NavigableMap<Double, T> valuesByKeyframe = new TreeMap<Double, T>();
    private final boolean normalized;

    public TransformAnimator(Map<Double, T> rawKeyframes, boolean normalize) {
        this.normalized = normalize;
        if (normalize) {
            double keyMax = Double.NEGATIVE_INFINITY;
            double keyMin = Double.POSITIVE_INFINITY;
            for (Double d : rawKeyframes.keySet()) {
                keyMax = Math.max(d, keyMax);
                keyMin = Math.min(d, keyMin);
            }
            for (Map.Entry entry : rawKeyframes.entrySet()) {
                this.valuesByKeyframe.put(MathUtils.rangeFraction((Double)entry.getKey(), keyMin, keyMax), entry.getValue());
            }
        } else {
            this.valuesByKeyframe.putAll(rawKeyframes);
        }
    }

    public NavigableSet<Double> getKeyframes() {
        return this.valuesByKeyframe.navigableKeySet();
    }

    public Double getLastKeyframe() {
        if (this.valuesByKeyframe.isEmpty()) {
            return 0.0;
        }
        return (Double)this.valuesByKeyframe.lastKey();
    }

    public T getValueAt(double frame) {
        if (this.valuesByKeyframe.isEmpty()) {
            return null;
        }
        Object value = this.valuesByKeyframe.get(frame);
        if (value != null) {
            return (T)value;
        }
        Map.Entry<Double, T> ceilEntry = this.valuesByKeyframe.ceilingEntry(frame);
        Map.Entry<Double, T> floorEntry = this.valuesByKeyframe.floorEntry(frame);
        if (ceilEntry != null && floorEntry == null) {
            return ceilEntry.getValue();
        }
        if (ceilEntry == null && floorEntry != null) {
            return floorEntry.getValue();
        }
        double intervalFraction = MathUtils.rangeFraction(frame, floorEntry.getKey(), ceilEntry.getKey());
        return this.interpolate(floorEntry.getValue(), ceilEntry.getValue(), intervalFraction);
    }

    public boolean isNormalized() {
        return this.normalized;
    }

    protected abstract T interpolate(T var1, T var2, double var3);
}

