/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.render.scenegraph;

import com.sodiumarc.patchwork.render.mesh.MeshUtils;
import com.sodiumarc.patchwork.render.mesh.PolyMesh3D;
import com.sodiumarc.patchwork.render.scenegraph.AnimatableTransform;
import com.sodiumarc.patchwork.render.scenegraph.Camera;
import com.sodiumarc.patchwork.render.scenegraph.PointLight;
import com.sodiumarc.patchwork.render.scenegraph.SceneGraphVisitor;
import com.sodiumarc.patchwork.render.scenegraph.Transform3D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.vecmath.Point3d;

public class SceneGraphNode {
    private final String name;
    private final Transform3D localTransform3D;
    private final AnimatableTransform componentTransform;
    private final List<PolyMesh3D> meshes;
    private final List<Camera> cameras;
    private final List<PointLight> lights;
    private final List<SceneGraphNode> children;
    private SceneGraphNode parent;
    private Transform3D cumulativeTransform;
    private Map<String, PolyMesh3D> meshesInGlobalCoords;
    private final Map<String, Map<String, PolyMesh3D>> meshesInCameraCoords;

    public SceneGraphNode(String name, List<SceneGraphNode> children) {
        this(name, new Transform3D(), new ArrayList<PolyMesh3D>(), new ArrayList<Camera>(), new ArrayList<PointLight>(), children);
    }

    public SceneGraphNode(String name, Transform3D localTransform3D, List<SceneGraphNode> children) {
        this(name, localTransform3D, new ArrayList<PolyMesh3D>(), new ArrayList<Camera>(), new ArrayList<PointLight>(), children);
    }

    public SceneGraphNode(String name, Transform3D localTransform3D, Camera camera) {
        this(name, localTransform3D, new ArrayList<PolyMesh3D>(), Collections.singletonList(camera), new ArrayList<PointLight>(), new ArrayList<SceneGraphNode>());
    }

    public SceneGraphNode(String name, Transform3D localTransform3D, PolyMesh3D mesh) {
        this(name, localTransform3D, Collections.singletonList(mesh), new ArrayList<Camera>(), new ArrayList<PointLight>(), new ArrayList<SceneGraphNode>());
    }

    public SceneGraphNode(String name, AnimatableTransform localTransform, List<PolyMesh3D> meshes, List<Camera> cameras, List<PointLight> lights, List<SceneGraphNode> children) {
        this.name = name;
        this.componentTransform = localTransform;
        this.localTransform3D = null;
        this.meshes = meshes;
        this.cameras = cameras;
        this.lights = lights;
        this.children = children;
        this.meshesInCameraCoords = new HashMap<String, Map<String, PolyMesh3D>>();
        this.initChildren();
    }

    public SceneGraphNode(String name, Transform3D localTransform3D, List<PolyMesh3D> meshes, List<Camera> cameras, List<PointLight> lights, List<SceneGraphNode> children) {
        this.name = name;
        if (localTransform3D == null) {
            this.localTransform3D = new Transform3D();
            this.localTransform3D.setIdentity();
        } else {
            this.localTransform3D = localTransform3D;
        }
        this.componentTransform = null;
        this.meshes = meshes;
        this.cameras = cameras;
        this.lights = lights;
        this.children = children;
        this.meshesInCameraCoords = new HashMap<String, Map<String, PolyMesh3D>>();
        this.initChildren();
    }

    public String getName() {
        return this.name;
    }

    public SceneGraphNode getParent() {
        return this.parent;
    }

    public Transform3D getLocalTransform() {
        if (this.componentTransform != null) {
            return this.componentTransform.getTransform3D();
        }
        return this.localTransform3D;
    }

    public Transform3D getCumulativeTransform() {
        Transform3D localTransform3D = this.getLocalTransform();
        if (this.cumulativeTransform == null) {
            if (this.parent != null) {
                this.cumulativeTransform = new Transform3D(this.parent.getCumulativeTransform());
                this.cumulativeTransform.mul(localTransform3D);
            } else {
                this.cumulativeTransform = localTransform3D;
            }
        }
        return this.cumulativeTransform;
    }

    public AnimatableTransform getAnimatableTransform() {
        return this.componentTransform;
    }

    public List<PolyMesh3D> getMeshes() {
        return this.meshes;
    }

    public PolyMesh3D getMeshInGlobalCoords(String meshID) {
        return this.getMeshesInGlobalCoords().get(meshID);
    }

    public Point3d getOriginInGlobalCoords() {
        Point3d origin = new Point3d(0.0, 0.0, 0.0);
        this.getCumulativeTransform().transform(origin);
        return origin;
    }

    public boolean containsMesh(String meshID) {
        assert (meshID != null) : "Null meshID not allowed.";
        for (PolyMesh3D mesh : this.getMeshes()) {
            if (!meshID.equals(mesh.getIdentifier())) continue;
            return true;
        }
        return false;
    }

    public Map<String, PolyMesh3D> getMeshesInGlobalCoords() {
        if (this.meshesInGlobalCoords == null) {
            this.meshesInGlobalCoords = new HashMap<String, PolyMesh3D>();
            for (PolyMesh3D mesh : this.getMeshes()) {
                this.meshesInGlobalCoords.put(mesh.getIdentifier(), MeshUtils.getTransformedMesh(mesh, this.getCumulativeTransform()));
            }
        }
        return this.meshesInGlobalCoords;
    }

    public Map<String, PolyMesh3D> getMeshesInCameraCoords(Camera camera) {
        String cameraID = camera.getId();
        if (!this.meshesInCameraCoords.containsKey(cameraID)) {
            this.meshesInCameraCoords.put(cameraID, camera.toCameraCoords(this.getMeshesInGlobalCoords()));
        }
        return this.meshesInCameraCoords.get(cameraID);
    }

    public Set<PolyMesh3D> getDescendantMeshesMatching(String regex) {
        final HashSet<PolyMesh3D> result = new HashSet<PolyMesh3D>();
        final Pattern pattern = Pattern.compile(regex);
        this.accept(new SceneGraphVisitor(){

            @Override
            public void visit(SceneGraphNode node) {
                for (PolyMesh3D mesh : node.getMeshes()) {
                    if (!pattern.matcher(mesh.getIdentifier()).matches()) continue;
                    result.add(mesh);
                }
            }
        });
        return result;
    }

    public List<Camera> getCameras() {
        return this.cameras;
    }

    public List<PointLight> getLights() {
        return this.lights;
    }

    public List<SceneGraphNode> getChildren() {
        return this.children;
    }

    public void addChild(SceneGraphNode child) {
        this.children.add(child);
        child.setParent(this);
    }

    public void splitNoncontiguousMeshes() {
        ArrayList<PolyMesh3D> meshesCopy = new ArrayList<PolyMesh3D>(this.meshes);
        this.meshes.clear();
        MeshUtils.splitMeshes(meshesCopy, MeshUtils.ACCEPT_ANY_EDGE, ";", this.meshes);
        this.meshesInGlobalCoords = null;
        this.meshesInCameraCoords.clear();
    }

    public void accept(SceneGraphVisitor visitor) {
        visitor.visit(this);
        for (SceneGraphNode child : this.getChildren()) {
            child.accept(visitor);
        }
    }

    public SceneGraphNode cloneSubtree(boolean accumulateTransform) {
        ArrayList<PolyMesh3D> clonedMeshes = new ArrayList<PolyMesh3D>();
        for (PolyMesh3D mesh : this.meshes) {
            clonedMeshes.add(new PolyMesh3D(mesh));
        }
        ArrayList<Camera> clonedCameras = new ArrayList<Camera>();
        for (Camera camera : this.cameras) {
            clonedCameras.add(new Camera(camera.getId()));
        }
        ArrayList<PointLight> clonedLights = new ArrayList<PointLight>();
        for (PointLight light : this.lights) {
            clonedLights.add(new PointLight(light.getId(), light.getColor(), light.getPosition()));
        }
        ArrayList<SceneGraphNode> clonedChildren = new ArrayList<SceneGraphNode>();
        for (SceneGraphNode child : this.children) {
            clonedChildren.add(child.cloneSubtree(false));
        }
        Transform3D transform = accumulateTransform ? this.getCumulativeTransform() : new Transform3D(this.getLocalTransform());
        return new SceneGraphNode(this.name, transform, clonedMeshes, clonedCameras, clonedLights, clonedChildren);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [name=" + this.name + "]";
    }

    private void initChildren() {
        for (SceneGraphNode child : this.children) {
            child.setParent(this);
        }
        for (Camera camera : this.cameras) {
            camera.setParent(this);
        }
    }

    private void setParent(SceneGraphNode parent) {
        this.parent = parent;
    }
}

