/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.render.scenegraph;

import com.sodiumarc.patchwork.render.mesh.PolyMesh3D;
import com.sodiumarc.patchwork.render.scenegraph.AnimatableTransform;
import com.sodiumarc.patchwork.render.scenegraph.Camera;
import com.sodiumarc.patchwork.render.scenegraph.PointLight;
import com.sodiumarc.patchwork.render.scenegraph.SceneGraphNode;
import com.sodiumarc.patchwork.render.scenegraph.SceneGraphVisitor;
import com.sodiumarc.patchwork.util.Collection.CollectionUtils;
import com.sodiumarc.patchwork.util.MathUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.vecmath.Point3d;

public class SceneGraph {
    private SceneGraphNode rootNode;

    public SceneGraph(SceneGraphNode root) {
        this.rootNode = root;
    }

    public SceneGraphNode getRoot() {
        return this.rootNode;
    }

    public Set<SceneGraphNode> getNodes(final String name) {
        final HashSet<SceneGraphNode> result = new HashSet<SceneGraphNode>();
        SceneGraphVisitor visitor = new SceneGraphVisitor(){

            @Override
            public void visit(SceneGraphNode node) {
                if (name == null ? node.getName() == null : name.equals(node.getName())) {
                    result.add(node);
                }
            }
        };
        this.accept(visitor);
        return result;
    }

    public Set<SceneGraphNode> getNodes(final Pattern namePattern) {
        final HashSet<SceneGraphNode> result = new HashSet<SceneGraphNode>();
        SceneGraphVisitor visitor = new SceneGraphVisitor(){

            @Override
            public void visit(SceneGraphNode node) {
                if (node.getName() != null && namePattern.matcher(node.getName()).matches()) {
                    result.add(node);
                }
            }
        };
        this.accept(visitor);
        return result;
    }

    public void accept(SceneGraphVisitor visitor) {
        if (this.rootNode != null) {
            this.rootNode.accept(visitor);
        }
    }

    public Set<String> getMeshIDs() {
        return Collections.unmodifiableSet(this.getMeshesInGlobalCoords().keySet());
    }

    public Map<String, PolyMesh3D> getMeshesInCameraCoords(String cameraID) {
        final HashMap<String, PolyMesh3D> result = new HashMap<String, PolyMesh3D>();
        final Camera camera = this.getCamera(cameraID);
        SceneGraphVisitor visitor = new SceneGraphVisitor(){

            @Override
            public void visit(SceneGraphNode node) {
                result.putAll(node.getMeshesInCameraCoords(camera));
            }
        };
        this.accept(visitor);
        return result;
    }

    public PolyMesh3D getMeshInCameraCoords(String meshID, String cameraID) {
        Map<String, PolyMesh3D> meshMap = this.getMeshesInCameraCoords(cameraID);
        if (meshMap == null) {
            return null;
        }
        return meshMap.get(meshID);
    }

    public Map<String, Camera> getCameras() {
        final HashMap<String, Camera> result = new HashMap<String, Camera>();
        SceneGraphVisitor visitor = new SceneGraphVisitor(){

            @Override
            public void visit(SceneGraphNode node) {
                for (Camera camera : node.getCameras()) {
                    result.put(camera.getId(), camera);
                }
            }
        };
        this.accept(visitor);
        return result;
    }

    public boolean cameraExists(String cameraID) {
        return this.getCameras().containsKey(cameraID);
    }

    public Camera getCamera(String cameraID) {
        Camera result = this.getCameras().get(cameraID);
        return result;
    }

    public Map<String, PolyMesh3D> getMeshesInGlobalCoords() {
        final HashMap<String, PolyMesh3D> meshesInGlobalCoords = new HashMap<String, PolyMesh3D>();
        SceneGraphVisitor visitor = new SceneGraphVisitor(){

            @Override
            public void visit(SceneGraphNode node) {
                meshesInGlobalCoords.putAll(node.getMeshesInGlobalCoords());
            }
        };
        this.accept(visitor);
        return meshesInGlobalCoords;
    }

    public Set<SceneGraphNode> getAnimatedNodes() {
        final HashSet<SceneGraphNode> result = new HashSet<SceneGraphNode>();
        SceneGraphVisitor visitor = new SceneGraphVisitor(){

            @Override
            public void visit(SceneGraphNode node) {
                AnimatableTransform animatableTransform = node.getAnimatableTransform();
                if (animatableTransform != null) {
                    for (AnimatableTransform.Channel channel : AnimatableTransform.Channel.values()) {
                        if (animatableTransform.getAnimator(channel) == null) continue;
                        result.add(node);
                        break;
                    }
                }
            }
        };
        this.accept(visitor);
        return result;
    }

    public PolyMesh3D getMeshInGlobalCoords(String meshID) {
        if (meshID == null) {
            return null;
        }
        return this.getMeshesInGlobalCoords().get(meshID);
    }

    public Point3d getMeshOriginInGlobalCoords(final String meshID) {
        if (meshID == null) {
            return null;
        }
        final ArrayList resultList = new ArrayList();
        SceneGraphVisitor visitor = new SceneGraphVisitor(){

            @Override
            public void visit(SceneGraphNode node) {
                if (node.containsMesh(meshID)) {
                    resultList.add(node.getOriginInGlobalCoords());
                }
            }
        };
        this.accept(visitor);
        return (Point3d)CollectionUtils.first(resultList);
    }

    public Map<String, PointLight> getLightsInGlobalCoords() {
        final HashMap<String, PointLight> result = new HashMap<String, PointLight>();
        SceneGraphVisitor visitor = new SceneGraphVisitor(){

            @Override
            public void visit(SceneGraphNode node) {
                for (PointLight light : node.getLights()) {
                    Point3d position = new Point3d(light.getPosition());
                    node.getCumulativeTransform().transform(position);
                    result.put(light.getId(), new PointLight(light.getId(), light.getColor(), position));
                }
            }
        };
        this.accept(visitor);
        return result;
    }

    public Map<String, PointLight> getLightsInCameraCoords(String cameraID) {
        Map<String, Camera> cameras = this.getCameras();
        if (!cameras.containsKey(cameraID)) {
            return Collections.emptyMap();
        }
        return cameras.get(cameraID).getLightsInCameraCoords(this.getLightsInGlobalCoords());
    }

    public NavigableSet<Double> getKeyframes() {
        final TreeSet<Double> result = new TreeSet<Double>();
        SceneGraphVisitor visitor = new SceneGraphVisitor(){

            @Override
            public void visit(SceneGraphNode node) {
                AnimatableTransform transform = node.getAnimatableTransform();
                if (transform == null) {
                    return;
                }
                result.addAll(transform.getKeyframes());
            }
        };
        this.accept(visitor);
        return result;
    }

    public void setAnimationFrame(final double frame) {
        SceneGraphVisitor visitor = new SceneGraphVisitor(){

            @Override
            public void visit(SceneGraphNode node) {
                AnimatableTransform transform = node.getAnimatableTransform();
                if (transform == null) {
                    return;
                }
                transform.setAnimationFrame(frame);
            }
        };
        this.accept(visitor);
    }

    public void setAnimationFraction(double fraction) {
        NavigableSet<Double> keyframes = this.getKeyframes();
        if (keyframes.size() == 0) {
            return;
        }
        if (keyframes.size() == 1) {
            this.setAnimationFrame((Double)keyframes.first());
        } else {
            this.setAnimationFrame(MathUtils.interpolate(fraction, (Double)keyframes.first(), (Double)keyframes.last()));
        }
    }

    public void cleanMeshes(final double vertexWeldThreshold) {
        SceneGraphVisitor visitor = new SceneGraphVisitor(){

            @Override
            public void visit(SceneGraphNode node) {
                for (PolyMesh3D mesh : node.getMeshes()) {
                    mesh.consolidateVertices(vertexWeldThreshold);
                    mesh.eliminateOverlappingEdges();
                }
            }
        };
        this.accept(visitor);
    }

    public void splitNoncontiguousMeshes() {
        SceneGraphVisitor visitor = new SceneGraphVisitor(){

            @Override
            public void visit(SceneGraphNode node) {
                node.splitNoncontiguousMeshes();
            }
        };
        this.accept(visitor);
    }
}

