/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.render.scenegraph;

import com.sodiumarc.patchwork.render.BoundingBox3D;
import com.sodiumarc.patchwork.render.RenderQuality;
import com.sodiumarc.patchwork.render.mesh.MeshUtils;
import com.sodiumarc.patchwork.render.mesh.Plane;
import com.sodiumarc.patchwork.render.mesh.PolyMesh3D;
import com.sodiumarc.patchwork.render.mesh.Polygon3D;
import com.sodiumarc.patchwork.render.scenegraph.CoordinateSystem;
import com.sodiumarc.patchwork.render.scenegraph.PointLight;
import com.sodiumarc.patchwork.render.scenegraph.SceneGraphNode;
import com.sodiumarc.patchwork.render.scenegraph.Transform3D;
import com.sodiumarc.patchwork.util.Filter;
import com.sodiumarc.patchwork.util.MathUtils;
import com.sodiumarc.patchwork.util.Rectangle4d;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.apache.log4j.Logger;

public class Camera {
    public static Vector3d DEFAULT_LOOK_VECTOR = new Vector3d(0.0, 0.0, -1.0);
    public static Vector3d DEFAULT_UP_VECTOR = new Vector3d(0.0, 1.0, 0.0);
    private final String id;
    private final Logger logger;
    private SceneGraphNode parent;
    private Transform3D cumulativeTransform;
    public static final double FOV = 0.7853981633974483;

    public Camera(String id) {
        this(id, null);
    }

    public Camera(String id, Transform3D transform) {
        this.id = id;
        this.cumulativeTransform = transform;
        this.logger = Logger.getLogger(this.getClass());
    }

    public String getId() {
        return this.id;
    }

    public Point3d getGlobalPosition() {
        Point3d result = new Point3d();
        this.getCumulativeTransform().transform(result);
        return result;
    }

    public double getGlobalScale() {
        return this.getCumulativeTransform().getScale();
    }

    public Vector3d getGlobalViewVector() {
        Vector3d result = new Vector3d(DEFAULT_LOOK_VECTOR);
        this.getCumulativeTransform().transform(result);
        result.normalize();
        return result;
    }

    public double getFOV() {
        return 0.7853981633974483;
    }

    public Set<PolyMesh3D> getDescendantMeshesMatching(String regex) {
        return this.parent.getDescendantMeshesMatching(regex);
    }

    public Map<String, PolyMesh3D> toCameraCoords(Map<String, PolyMesh3D> meshesInGlobalCoords) {
        Transform3D inverseCamera = this.getInverseTransform();
        HashMap<String, PolyMesh3D> result = new HashMap<String, PolyMesh3D>();
        for (Map.Entry<String, PolyMesh3D> entry : meshesInGlobalCoords.entrySet()) {
            result.put(entry.getKey(), MeshUtils.getTransformedMesh(entry.getValue(), inverseCamera));
        }
        return result;
    }

    public PolyMesh3D toCameraCoords(PolyMesh3D mesh) {
        Transform3D inverseCamera = this.getInverseTransform();
        return MeshUtils.getTransformedMesh(mesh, inverseCamera);
    }

    public Collection<PolyMesh3D> toCameraCoords(Collection<PolyMesh3D> meshesInGlobalCoords) {
        Transform3D inverseCamera = this.getInverseTransform();
        ArrayList<PolyMesh3D> result = new ArrayList<PolyMesh3D>();
        for (PolyMesh3D mesh : meshesInGlobalCoords) {
            result.add(MeshUtils.getTransformedMesh(mesh, inverseCamera));
        }
        return result;
    }

    public Point3d fromCameraCoords(Point3d point) {
        Point3d result = new Point3d(point);
        this.getCumulativeTransform().transform(result);
        return result;
    }

    public Vector3d fromCameraCoords(Vector3d vector) {
        Vector3d result = new Vector3d(vector);
        this.getCumulativeTransform().transform(result);
        return result;
    }

    public Map<String, PointLight> getLightsInCameraCoords(Map<String, PointLight> lightsInGlobalCoords) {
        Transform3D inverseCamera = this.getInverseTransform();
        HashMap<String, PointLight> result = new HashMap<String, PointLight>();
        for (Map.Entry<String, PointLight> entry : lightsInGlobalCoords.entrySet()) {
            PointLight light = entry.getValue();
            Point3d position = new Point3d(light.getPosition());
            inverseCamera.transform(position);
            result.put(entry.getKey(), new PointLight(light.getId(), light.getColor(), position));
        }
        return result;
    }

    public List<PolyMesh3D> frustrumClipMeshes(Rectangle4d viewport, Collection<PolyMesh3D> meshes, RenderQuality quality) {
        double z = 1.0;
        double fudgeMargin = Math.abs(viewport.getWidth()) * 0.05;
        double left = viewport.getXMin() - fudgeMargin;
        double right = viewport.getXMax() + fudgeMargin;
        double top = viewport.getYMin() - fudgeMargin;
        double bottom = viewport.getYMax() + fudgeMargin;
        ArrayList<PolyMesh3D> result = new ArrayList<PolyMesh3D>(meshes.size());
        for (PolyMesh3D mesh : meshes) {
            Plane plane;
            ArrayList<Plane> sidePlanes = new ArrayList<Plane>();
            sidePlanes.add(new Plane(new Point3d(0.0, 0.0, -1.0), new Vector3d(0.0, 0.0, -1.0)));
            sidePlanes.add(new Plane(new Point3d(0.0, 0.0, 0.0), new Vector3d(z, 0.0, left)));
            sidePlanes.add(new Plane(new Point3d(0.0, 0.0, 0.0), new Vector3d(-z, 0.0, -right)));
            sidePlanes.add(new Plane(new Point3d(0.0, 0.0, 0.0), new Vector3d(0.0, z, -bottom)));
            sidePlanes.add(new Plane(new Point3d(0.0, 0.0, 0.0), new Vector3d(0.0, -z, top)));
            PolyMesh3D clippedMesh = mesh;
            Iterator i$ = sidePlanes.iterator();
            while (i$.hasNext() && (clippedMesh = this.clipMeshToPlane(clippedMesh, plane = (Plane)i$.next(), false)) != null) {
            }
            if (clippedMesh == null) {
                this.logger.debug("Clipping eliminates mesh: " + mesh.getIdentifier());
                continue;
            }
            result.add(clippedMesh);
        }
        return result;
    }

    public List<PolyMesh3D> projectMeshes(Collection<PolyMesh3D> meshes, Filter<Polygon3D> polyFilter, Rectangle4d viewport, Dimension imageSize) {
        ArrayList<PolyMesh3D> result = new ArrayList<PolyMesh3D>(meshes.size());
        for (PolyMesh3D mesh : meshes) {
            ArrayList<Point3d> projectedVertices = new ArrayList<Point3d>(mesh.getVertices().size());
            for (Point3d vertex : mesh.getVertices()) {
                Point3d projectedVertex = this.cameraToProjected(vertex);
                this.projectedToDisplay(projectedVertex, viewport, imageSize, projectedVertex);
                projectedVertices.add(projectedVertex);
            }
            PolyMesh3D projectedMesh = new PolyMesh3D(mesh.getIdentifier(), projectedVertices, mesh.getColors(), mesh.getTextureCoordinates(), mesh.getMaterials());
            projectedMesh.setAlternateVertices(mesh.getAlternateVertices());
            for (Polygon3D polygon : mesh.getPolygons()) {
                if (!polyFilter.accept(polygon)) continue;
                projectedMesh.addPolygonIndexed(new ArrayList<Integer>(polygon.getVertexIndices()), polygon.getVertexColorIndices(), polygon.getTextureCoordIndices(), new Vector3d(polygon.getNormal()), polygon.getMaterialIndex());
            }
            projectedMesh.setAlternateVertices(CoordinateSystem.CAMERA, mesh.getVertices());
            result.add(projectedMesh);
        }
        return result;
    }

    public Point3d globalToCamera(Point3d point) {
        Transform3D inverseCamera = this.getInverseTransform();
        Point3d result = new Point3d(point);
        inverseCamera.transform(result);
        return result;
    }

    public Point3d cameraToProjected(Point3d point) {
        double fovScale = 1.0 / Math.tan(this.getFOV());
        double z = -point.getZ();
        Point3d result = new Point3d();
        if (z <= 0.0) {
            return result;
        }
        double f = fovScale / z;
        result.setX(point.getX() * f);
        result.setY(point.getY() * f);
        result.setZ(z);
        return result;
    }

    public Point3d projectedToDisplay(Point3d source, Rectangle4d viewPort, Dimension viewportDisplaySize, Point3d result) {
        double xFraction = MathUtils.rangeFraction(source.getX(), viewPort.getX(), viewPort.getX() + viewPort.getWidth());
        double yFraction = MathUtils.rangeFraction(-source.getY(), viewPort.getY(), viewPort.getY() + viewPort.getHeight());
        result.setX(MathUtils.interpolate(xFraction, 0.0, viewportDisplaySize.getWidth()));
        result.setY(MathUtils.interpolate(yFraction, 0.0, viewportDisplaySize.getHeight()));
        return result;
    }

    public Point3d globalToDisplay(Point3d point, Rectangle4d viewPort, Dimension viewportDisplaySize) {
        Point3d result = this.globalToCamera(point);
        result = this.cameraToProjected(result);
        return this.projectedToDisplay(result, viewPort, viewportDisplaySize, result);
    }

    public Point3d cameraToDisplay(Point3d point, Rectangle4d viewPort, Dimension viewportDisplaySize) {
        Point3d result = this.cameraToProjected(point);
        return this.projectedToDisplay(result, viewPort, viewportDisplaySize, result);
    }

    public List<PolyMesh3D> prepareForScanConversion(Collection<PolyMesh3D> meshes, Rectangle4d viewport, Dimension imageSize, RenderQuality quality) {
        this.logger.debug("Clipping meshes...");
        List<PolyMesh3D> clippedMeshes = this.frustrumClipMeshes(viewport, meshes, quality);
        this.logger.debug("Projecting meshes...");
        Filter<Polygon3D> facingFilter = new Filter<Polygon3D>(){

            @Override
            public boolean accept(Polygon3D item) {
                return Camera.this.isFacing(item);
            }
        };
        return this.projectMeshes(clippedMeshes, facingFilter, viewport, imageSize);
    }

    public Rectangle4d getProjectedBounds(Iterable<Point3d> points) {
        double xMin = Double.POSITIVE_INFINITY;
        double yMin = Double.POSITIVE_INFINITY;
        double xMax = Double.NEGATIVE_INFINITY;
        double yMax = Double.NEGATIVE_INFINITY;
        for (Point3d point : points) {
            Point3d projectedPoint = this.cameraToProjected(point);
            xMin = Math.min(xMin, projectedPoint.getX());
            xMax = Math.max(xMax, projectedPoint.getX());
            yMin = Math.min(yMin, -projectedPoint.getY());
            yMax = Math.max(yMax, -projectedPoint.getY());
        }
        return new Rectangle4d(xMin, yMin, xMax - xMin, yMax - yMin);
    }

    public Rectangle4d getProjectedBounds(PolyMesh3D mesh) {
        if (mesh == null) {
            return null;
        }
        double xMin = Double.POSITIVE_INFINITY;
        double yMin = Double.POSITIVE_INFINITY;
        double xMax = Double.NEGATIVE_INFINITY;
        double yMax = Double.NEGATIVE_INFINITY;
        List<Point3d> vertices = mesh.getVertices();
        for (int i = 0; i < vertices.size(); ++i) {
            if (!mesh.isVertexUsed(i)) continue;
            Point3d projectedVertex = this.cameraToProjected(vertices.get(i));
            xMin = Math.min(xMin, projectedVertex.getX());
            xMax = Math.max(xMax, projectedVertex.getX());
            yMin = Math.min(yMin, -projectedVertex.getY());
            yMax = Math.max(yMax, -projectedVertex.getY());
        }
        return new Rectangle4d(xMin, yMin, xMax - xMin, yMax - yMin);
    }

    public Rectangle4d getProjectedBounds(Collection<PolyMesh3D> meshes) {
        Rectangle4d combinedBounds = null;
        for (PolyMesh3D mesh : meshes) {
            Rectangle4d bounds = this.getProjectedBounds(mesh);
            if (combinedBounds == null) {
                combinedBounds = bounds;
                continue;
            }
            combinedBounds = combinedBounds.combine(bounds);
        }
        return combinedBounds;
    }

    public Rectangle4d getProjectedBounds(BoundingBox3D bounds) {
        if (bounds == null) {
            return null;
        }
        double xMin = Double.POSITIVE_INFINITY;
        double yMin = Double.POSITIVE_INFINITY;
        double xMax = Double.NEGATIVE_INFINITY;
        double yMax = Double.NEGATIVE_INFINITY;
        List<Point3d> vertices = bounds.getAllCornerPoints();
        for (Point3d vertex : vertices) {
            Point3d projectedVertex = this.cameraToProjected(vertex);
            xMin = Math.min(xMin, projectedVertex.getX());
            xMax = Math.max(xMax, projectedVertex.getX());
            yMin = Math.min(yMin, -projectedVertex.getY());
            yMax = Math.max(yMax, -projectedVertex.getY());
        }
        return new Rectangle4d(xMin, yMin, xMax - xMin, yMax - yMin);
    }

    public Camera createOffsetCamera(String id, Vector3d offset, boolean local) {
        Transform3D offsetTransform = new Transform3D();
        offsetTransform.setTranslation(offset);
        Transform3D totalTransform = new Transform3D();
        if (local) {
            totalTransform.mul(this.getCumulativeTransform(), offsetTransform);
        } else {
            totalTransform.mul(offsetTransform, this.getCumulativeTransform());
        }
        return new Camera(id, totalTransform);
    }

    public Transform3D getCumulativeTransform() {
        if (this.cumulativeTransform != null) {
            return this.cumulativeTransform;
        }
        if (this.parent != null) {
            return this.parent.getCumulativeTransform();
        }
        return new Transform3D();
    }

    public Transform3D getInverseTransform() {
        Transform3D inverseCamera = new Transform3D(this.getCumulativeTransform());
        inverseCamera.invert();
        return inverseCamera;
    }

    public SceneGraphNode getParent() {
        return this.parent;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [id=" + this.id + "]";
    }

    void setParent(SceneGraphNode parent) {
        this.parent = parent;
    }

    void setCumulativeTransform(Transform3D cumulativeTransform) {
        this.cumulativeTransform = cumulativeTransform;
    }

    private PolyMesh3D clipMeshToPlane(PolyMesh3D mesh, Plane plane, boolean fast) {
        if (fast) {
            int compare = mesh.compareBoundsToPlane(plane);
            return compare == -1 ? null : mesh;
        }
        PolyMesh3D clippedMesh = new PolyMesh3D(mesh);
        boolean altered = clippedMesh.clipToPlane(plane);
        if (clippedMesh.getPolygons().isEmpty()) {
            return null;
        }
        if (altered) {
            clippedMesh.consolidateVertices(0.001);
            clippedMesh.eliminateOverlappingEdges();
        }
        return clippedMesh;
    }

    private boolean isFacing(Polygon3D polygon) {
        Vector3d ref;
        Vector3d normal = polygon.getNormal();
        return normal.dot(ref = new Vector3d(polygon.getVertex(0))) < 0.0;
    }
}

