/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.render.scenegraph;

import com.sodiumarc.patchwork.collada.Animation;
import com.sodiumarc.patchwork.collada.COLLADA;
import com.sodiumarc.patchwork.collada.Channel;
import com.sodiumarc.patchwork.collada.Effect;
import com.sodiumarc.patchwork.collada.Input;
import com.sodiumarc.patchwork.collada.Light;
import com.sodiumarc.patchwork.collada.Material;
import com.sodiumarc.patchwork.collada.Mesh;
import com.sodiumarc.patchwork.collada.Node;
import com.sodiumarc.patchwork.collada.Polygons;
import com.sodiumarc.patchwork.collada.Rotate;
import com.sodiumarc.patchwork.collada.Scale;
import com.sodiumarc.patchwork.collada.Translate;
import com.sodiumarc.patchwork.collada.VisualScene;
import com.sodiumarc.patchwork.render.mesh.PolyMaterial;
import com.sodiumarc.patchwork.render.mesh.PolyMesh3D;
import com.sodiumarc.patchwork.render.scenegraph.AngleAnimator;
import com.sodiumarc.patchwork.render.scenegraph.AnimatableTransform;
import com.sodiumarc.patchwork.render.scenegraph.Camera;
import com.sodiumarc.patchwork.render.scenegraph.DoubleAnimator;
import com.sodiumarc.patchwork.render.scenegraph.PointLight;
import com.sodiumarc.patchwork.render.scenegraph.SceneGraph;
import com.sodiumarc.patchwork.render.scenegraph.SceneGraphNode;
import com.sodiumarc.patchwork.render.scenegraph.TransformAnimator;
import com.sodiumarc.patchwork.render.scenegraph.Vector3dAnimator;
import com.sodiumarc.patchwork.util.Collection.CollectionUtils;
import com.sodiumarc.patchwork.util.MathUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class COLLADALoader {
    public SceneGraph load(File inputFile) {
        if (inputFile == null) {
            return null;
        }
        COLLADA inputRoot = null;
        try {
            inputRoot = COLLADA.fromFile(inputFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        if (inputRoot != null) {
            return this.load(inputRoot);
        }
        return null;
    }

    public SceneGraph load(InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        COLLADA inputRoot = null;
        try {
            inputRoot = COLLADA.fromInputStream(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        if (inputRoot != null) {
            return this.load(inputRoot);
        }
        return null;
    }

    public SceneGraph load(COLLADA colladaRoot) {
        ArrayList<SceneGraphNode> roots = new ArrayList<SceneGraphNode>();
        for (VisualScene scene : colladaRoot.getVisualScenes()) {
            SceneGraphNode sceneRoot = this.load(scene, colladaRoot);
            if (sceneRoot == null) continue;
            roots.add(sceneRoot);
        }
        SceneGraphNode root = null;
        if (roots.size() == 1) {
            root = (SceneGraphNode)roots.get(0);
        } else if (roots.size() > 1) {
            root = new SceneGraphNode("<ROOT>", roots);
        }
        return new SceneGraph(root);
    }

    public SceneGraphNode load(VisualScene scene, COLLADA colladaRoot) {
        ArrayList<SceneGraphNode> roots = new ArrayList<SceneGraphNode>();
        for (Node root : scene.getRootNodes()) {
            roots.add(this.load(root, colladaRoot, null));
        }
        SceneGraphNode result = null;
        if (roots.size() == 1) {
            result = (SceneGraphNode)roots.get(0);
        } else if (roots.size() > 1) {
            result = new SceneGraphNode("<ROOT>", roots);
        }
        return result;
    }

    public SceneGraphNode load(Node root, COLLADA colladaRoot, String parentPathString) {
        String nodePathString = parentPathString == null ? root.getName() : parentPathString + ";" + root.getName();
        ArrayList<PolyMesh3D> meshes = new ArrayList<PolyMesh3D>();
        for (String id : root.getGeometryIds()) {
            meshes.add(this.load(colladaRoot.getMeshesByID().get(id), colladaRoot, nodePathString));
        }
        ArrayList<Camera> cameras = new ArrayList<Camera>();
        for (String id : root.getCameraIds()) {
            cameras.add(this.load(colladaRoot.getCamerasByID().get(id), nodePathString));
        }
        ArrayList<PointLight> lights = new ArrayList<PointLight>();
        for (String id : root.getLightIds()) {
            lights.add(this.load(colladaRoot.getLightsByID().get(id), nodePathString));
        }
        ArrayList<SceneGraphNode> children = new ArrayList<SceneGraphNode>();
        for (Node child : root.getChildNodes()) {
            SceneGraphNode childNode = this.load(child, colladaRoot, nodePathString);
            children.add(childNode);
        }
        SceneGraphNode result = new SceneGraphNode(root.getName(), this.getTransform(root), meshes, cameras, lights, children);
        this.loadAnimations(result, colladaRoot);
        return result;
    }

    private Camera load(com.sodiumarc.patchwork.collada.Camera colladaCamera, String nodeID) {
        return new Camera(nodeID);
    }

    private PointLight load(Light colladaLight, String nodeID) {
        return new PointLight(nodeID, colladaLight.getColor());
    }

    private PolyMesh3D load(Mesh mesh, COLLADA colladaRoot, String pathString) {
        Input colorInput;
        List<Float> vertexValues = mesh.getVertexValues();
        ArrayList<Point3d> vertices = new ArrayList<Point3d>(vertexValues.size());
        for (int i = 0; i < vertexValues.size(); i += 3) {
            Point3d vertex = new Point3d(vertexValues.get(i).floatValue(), vertexValues.get(i + 1).floatValue(), vertexValues.get(i + 2).floatValue());
            vertices.add(vertex);
        }
        ArrayList<Color3f> colors = null;
        Polygons polys = CollectionUtils.first(mesh.getPolygons());
        if (polys != null && (colorInput = polys.getInputForSemantic("COLOR")) != null) {
            colors = new ArrayList<Color3f>();
            String colorSourceId = polys.getInputForSemantic("COLOR").getSourceId();
            List<Float> colorValues = mesh.getSourceArray(colorSourceId);
            for (int i = 0; i < colorValues.size(); i += 4) {
                Color3f color = new Color3f(colorValues.get(i).floatValue(), colorValues.get(i + 1).floatValue(), colorValues.get(i + 2).floatValue());
                colors.add(color);
            }
        }
        ArrayList<PolyMaterial> materials = new ArrayList<PolyMaterial>();
        HashMap<Polygons, Integer> materialIndexMap = new HashMap<Polygons, Integer>();
        for (Polygons polygons : mesh.getPolygons()) {
            PolyMaterial material = this.getPolyMaterial(polygons, colladaRoot);
            if (material == null) continue;
            materialIndexMap.put(polygons, materials.size());
            materials.add(material);
        }
        PolyMesh3D result = new PolyMesh3D(pathString, vertices, colors, null, materials);
        for (Polygons polygons : mesh.getPolygons()) {
            List<List<Integer>> indexLists = polygons.getIndexLists();
            for (List<Integer> indexList : indexLists) {
                List<Integer> polyIndexList = polygons.getIndexListForSemantic("VERTEX", indexList);
                List<Integer> colorIndexList = colors == null ? null : polygons.getIndexListForSemantic("COLOR", indexList);
                Integer materialIndexI = (Integer)materialIndexMap.get(polygons);
                int materialIndex = materialIndexI == null ? -1 : materialIndexI;
                result.addPolygonIndexed(polyIndexList, colorIndexList, null, null, materialIndex);
            }
        }
        return result;
    }

    private PolyMaterial getPolyMaterial(Polygons polygons, COLLADA colladaRoot) {
        String materialID = polygons.getMaterialID();
        if (materialID == null) {
            return null;
        }
        Material material = colladaRoot.getMaterialsByID().get(materialID);
        if (material == null) {
            return null;
        }
        Effect effect = colladaRoot.getEffectsByID().get(material.getEffectId());
        if (effect == null) {
            return null;
        }
        return new PolyMaterial(materialID, effect.getAmbientColor(), effect.getDiffuseColor(), effect.getSpecularColor());
    }

    private AnimatableTransform getTransform(Node node) {
        Scale scale;
        Rotate rotate;
        List<Float> values;
        AnimatableTransform result = new AnimatableTransform();
        Translate translate = node.getTranslate();
        if (translate != null) {
            values = node.getTranslate().getValues();
            result.setTranslation(new Vector3d(values.get(0).floatValue(), values.get(1).floatValue(), values.get(2).floatValue()));
        }
        if ((rotate = node.getRotate("rotateZ")) != null) {
            values = rotate.getValues();
            result.setZRotation(new AxisAngle4d(values.get(0).floatValue(), values.get(1).floatValue(), values.get(2).floatValue(), MathUtils.degreesToRadians(values.get(3).floatValue())));
        }
        if ((rotate = node.getRotate("rotateY")) != null) {
            values = rotate.getValues();
            result.setYRotation(new AxisAngle4d(values.get(0).floatValue(), values.get(1).floatValue(), values.get(2).floatValue(), MathUtils.degreesToRadians(values.get(3).floatValue())));
        }
        if ((rotate = node.getRotate("rotateX")) != null) {
            values = rotate.getValues();
            result.setXRotation(new AxisAngle4d(values.get(0).floatValue(), values.get(1).floatValue(), values.get(2).floatValue(), MathUtils.degreesToRadians(values.get(3).floatValue())));
        }
        if ((scale = node.getScale()) != null) {
            values = scale.getValues();
            result.setScale(new Vector3d(values.get(0).floatValue(), values.get(1).floatValue(), values.get(2).floatValue()));
        }
        return result;
    }

    private void loadAnimations(SceneGraphNode node, COLLADA colladaRoot) {
        AnimatableTransform animatableTransform = node.getAnimatableTransform();
        if (animatableTransform == null) {
            return;
        }
        double angleMin = -180.0;
        double angleMax = 180.0;
        for (Animation animation : colladaRoot.getAnimations()) {
            for (Channel channel : animation.getChannels()) {
                TransformAnimator animator;
                if (!node.getName().equals(channel.getTargetNodeId())) continue;
                String samplerId = channel.getSamplerId();
                String transformSid = channel.getTargetTransformSid();
                List<Float> inputs = animation.getInputValues(samplerId);
                List<Float> outputs = animation.getOutputValues(samplerId);
                if ("translate".equals(transformSid)) {
                    animator = new Vector3dAnimator(this.toVectorMap(inputs, outputs), false);
                    animatableTransform.setAnimator(AnimatableTransform.Channel.TRANSLATION, (Vector3dAnimator)animator);
                    continue;
                }
                if ("rotateX".equals(transformSid)) {
                    animator = new AngleAnimator(this.toScalarMap(inputs, outputs), false, angleMin, angleMax);
                    animatableTransform.setAnimator(AnimatableTransform.Channel.X_ROTATION, (DoubleAnimator)animator);
                    continue;
                }
                if ("rotateY".equals(transformSid)) {
                    animator = new AngleAnimator(this.toScalarMap(inputs, outputs), false, angleMin, angleMax);
                    animatableTransform.setAnimator(AnimatableTransform.Channel.Y_ROTATION, (DoubleAnimator)animator);
                    continue;
                }
                if ("rotateZ".equals(transformSid)) {
                    animator = new AngleAnimator(this.toScalarMap(inputs, outputs), false, angleMin, angleMax);
                    animatableTransform.setAnimator(AnimatableTransform.Channel.Z_ROTATION, (DoubleAnimator)animator);
                    continue;
                }
                if (!"scale".equals(transformSid)) continue;
                animator = new Vector3dAnimator(this.toVectorMap(inputs, outputs), false);
                animatableTransform.setAnimator(AnimatableTransform.Channel.SCALE, (Vector3dAnimator)animator);
            }
        }
    }

    private Map<Double, Double> toScalarMap(List<Float> inputs, List<Float> outputs) {
        assert (inputs.size() == outputs.size());
        HashMap<Double, Double> result = new HashMap<Double, Double>();
        for (int i = 0; i < inputs.size(); ++i) {
            result.put(Double.valueOf(inputs.get(i).floatValue()), Double.valueOf(outputs.get(i).floatValue()));
        }
        return result;
    }

    private Map<Double, Vector3d> toVectorMap(List<Float> inputs, List<Float> outputs) {
        assert (outputs.size() == 3 * inputs.size());
        HashMap<Double, Vector3d> result = new HashMap<Double, Vector3d>();
        int i = 0;
        int j = 0;
        while (i < inputs.size()) {
            Vector3d value = new Vector3d(outputs.get(j).floatValue(), outputs.get(j + 1).floatValue(), outputs.get(j + 2).floatValue());
            result.put(Double.valueOf(inputs.get(i).floatValue()), value);
            ++i;
            j += 3;
        }
        return result;
    }
}

