/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.render.scanconverter;

import com.sodiumarc.patchwork.render.mesh.PolyMaterial;
import com.sodiumarc.patchwork.render.mesh.Polygon3D;
import com.sodiumarc.patchwork.render.scanconverter.InterpolatedTuple3f;
import com.sodiumarc.patchwork.render.scanconverter.SCEdge;
import com.sodiumarc.patchwork.render.scanconverter.SCFeature;
import com.sodiumarc.patchwork.render.scanconverter.SCVertex;
import com.sodiumarc.patchwork.render.scenegraph.CoordinateSystem;
import com.sodiumarc.patchwork.render.scenegraph.PointLight;
import com.sodiumarc.patchwork.util.Collection.MultiHashMap;
import com.sodiumarc.patchwork.util.GeometricAxis;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;

public class SCPolygon {
    private final Polygon3D _polygon3D;
    private int _startRow = Integer.MAX_VALUE;
    private int _endRow = Integer.MIN_VALUE;
    private final MultiHashMap<Integer, SCEdge> _edgesByStartRow = new MultiHashMap();
    private final List<SCEdge> _activeEdges = new ArrayList<SCEdge>();
    private int _currentRow = -1;
    private final SCVertex _spanVertex = new SCVertex();
    private final SCVertex _spanDelta = new SCVertex();
    private int _spanXStart = 0;
    private int _spanXEnd = 0;
    private static Comparator<SCEdge> ROW_CROSSING_COMPARATOR = new Comparator<SCEdge>(){

        @Override
        public int compare(SCEdge e0, SCEdge e1) {
            if (e0.getXCurrent() == e1.getXCurrent()) {
                if (e0.getXEnd() == e1.getXEnd()) {
                    return 0;
                }
                return e0.getXEnd() < e1.getXEnd() ? -1 : 1;
            }
            return e0.getXCurrent() < e1.getXCurrent() ? -1 : 1;
        }
    };

    public SCPolygon(Polygon3D polygon, Map<InterpolatedTuple3f, PointLight> lights, Set<InterpolatedTuple3f> interpolationKeys, Set<SCFeature> features) {
        this._polygon3D = polygon;
        Color3f polyColor = new Color3f(0.5f, 0.5f, 0.5f);
        boolean separateColors = features.contains((Object)SCFeature.SHADOWS);
        Map<InterpolatedTuple3f, List<Color3f>> lightColors = this.getLightColors(polygon, lights, polyColor, separateColors);
        for (int i = 1; i < polygon.getVertexCount(); ++i) {
            this.addEdge(polygon, i - 1, i, lightColors, interpolationKeys);
        }
        this.addEdge(polygon, polygon.getVertexCount() - 1, 0, lightColors, interpolationKeys);
    }

    public Polygon3D getPolygon3D() {
        return this._polygon3D;
    }

    public int getYStart() {
        return this._startRow;
    }

    public void toYStart() {
        this._currentRow = this.getYStart();
        this.updateEdges(this._currentRow);
    }

    public void toYNext() {
        this.updateEdges(++this._currentRow);
    }

    public void toXNext() {
        this._spanVertex.addDelta(this._spanDelta);
    }

    public int getYEnd() {
        return this._endRow;
    }

    public int getSpanXStart() {
        return this._spanXStart;
    }

    public int getSpanXEnd() {
        return this._spanXEnd;
    }

    public SCVertex getSpanStartVertex() {
        return this.getLeadingEdge().getRowEntryVertex();
    }

    public SCVertex getSpanEndVertex() {
        return this.getTrailingEdge().getRowEntryVertex();
    }

    public SCVertex getSpanCurrentVertex() {
        return this._spanVertex;
    }

    private SCEdge getLeadingEdge() {
        return this._activeEdges.get(0);
    }

    private SCEdge getTrailingEdge() {
        return this._activeEdges.get(this._activeEdges.size() - 1);
    }

    private void addEdge(Polygon3D polygon, int fromIndex, int toIndex, Map<InterpolatedTuple3f, List<Color3f>> lightColors, Set<InterpolatedTuple3f> keys) {
        Point3d vertex0 = polygon.getVertex(fromIndex);
        Point3d vertex1 = polygon.getVertex(toIndex);
        if (Math.floor(vertex0.y) != Math.floor(vertex1.y)) {
            Map<InterpolatedTuple3f, Tuple3f> values0 = this.valuesForVertex(polygon, fromIndex, lightColors, keys);
            Map<InterpolatedTuple3f, Tuple3f> values1 = this.valuesForVertex(polygon, toIndex, lightColors, keys);
            SCEdge edge = new SCEdge(vertex0, values0, vertex1, values1);
            this._startRow = Math.min(this._startRow, edge.getYStart());
            this._endRow = Math.max(this._endRow, edge.getYEnd());
            this._edgesByStartRow.putLast(edge.getYStart(), edge);
        }
    }

    private void updateEdges(int newRow) {
        Iterator<SCEdge> iter = this._activeEdges.iterator();
        while (iter.hasNext()) {
            SCEdge edge = iter.next();
            if (edge.getYEnd() < newRow) {
                iter.remove();
                continue;
            }
            edge.toYNext();
        }
        for (SCEdge edge : this._edgesByStartRow.getAll(newRow)) {
            edge.toYStart();
            this._activeEdges.add(edge);
        }
        Collections.sort(this._activeEdges, ROW_CROSSING_COMPARATOR);
        if (!this._activeEdges.isEmpty()) {
            this._spanDelta.setStepDelta(this.getLeadingEdge().getRowEntryVertex(), this.getTrailingEdge().getRowEntryVertex(), GeometricAxis.X);
            this._spanVertex.set(this.getLeadingEdge().getRowEntryVertex());
        }
        this._spanXStart = (int)Math.ceil(this.getLeadingEdge().getRowEntryVertex().displayCoords().x);
        double xEnd = this.getTrailingEdge().getRowEntryVertex().displayCoords().x;
        double xEndFloor = Math.floor(xEnd);
        this._spanXEnd = xEnd == xEndFloor ? (int)xEndFloor - 1 : (int)xEndFloor;
    }

    private Map<InterpolatedTuple3f, List<Color3f>> getLightColors(Polygon3D polygon, Map<InterpolatedTuple3f, PointLight> lights, Color3f defaultDiffuseColor, boolean separate) {
        Color3f diffuseColor = defaultDiffuseColor;
        PolyMaterial material = polygon.getMaterial();
        if (material != null) {
            diffuseColor = new Color3f(material.getDiffuseColor());
        }
        EnumMap<InterpolatedTuple3f, List<Color3f>> result = new EnumMap<InterpolatedTuple3f, List<Color3f>>(InterpolatedTuple3f.class);
        ArrayList<Color3f> emissiveColors = null;
        if (separate || polygon.hasVertexColors()) {
            emissiveColors = new ArrayList<Color3f>(polygon.getVertexCount());
            int n = polygon.getVertexCount();
            for (int i = 0; i < n; ++i) {
                Color3f vertexColor = polygon.getVertexColor(i);
                emissiveColors.add(vertexColor == null ? new Color3f(0.0f, 0.0f, 0.0f) : vertexColor);
            }
        }
        for (Map.Entry<InterpolatedTuple3f, PointLight> entry : lights.entrySet()) {
            List<Color3f> litColors = entry.getValue().lightPolygon(polygon, diffuseColor, CoordinateSystem.CAMERA);
            if (separate) {
                result.put(entry.getKey(), litColors);
                continue;
            }
            if (emissiveColors == null) {
                emissiveColors = new ArrayList(polygon.getVertexCount());
            }
            int n = polygon.getVertexCount();
            for (int i = 0; i < n; ++i) {
                if (i >= emissiveColors.size()) {
                    emissiveColors.add(litColors.get(i));
                    continue;
                }
                Color3f emissiveColor = (Color3f)emissiveColors.get(i);
                emissiveColor.add(litColors.get(i));
            }
        }
        if (emissiveColors != null) {
            result.put(InterpolatedTuple3f.EMISSIVE_COLOR, emissiveColors);
        }
        return result;
    }

    private Map<InterpolatedTuple3f, Tuple3f> valuesForVertex(Polygon3D polygon, int vertexIndex, Map<InterpolatedTuple3f, List<Color3f>> lightColors, Set<InterpolatedTuple3f> keys) {
        EnumMap<InterpolatedTuple3f, Tuple3f> result = new EnumMap<InterpolatedTuple3f, Tuple3f>(InterpolatedTuple3f.class);
        for (InterpolatedTuple3f key : keys) {
            switch (key) {
                case CAMERA_COORDS: {
                    Point3d point = polygon.getVertex(vertexIndex, CoordinateSystem.CAMERA);
                    if (point == null) break;
                    result.put(key, new Point3f(point));
                    break;
                }
                case EMISSIVE_COLOR: 
                case LIGHT0_COLOR: 
                case LIGHT1_COLOR: 
                case LIGHT2_COLOR: 
                case LIGHT3_COLOR: {
                    List<Color3f> colors = lightColors.get((Object)key);
                    if (colors == null) break;
                    result.put(key, colors.get(vertexIndex));
                    break;
                }
                case INVERSE_TEXTURE_COORDS: {
                    if (!polygon.hasTextureCoords()) break;
                    result.put(key, new Point3f(polygon.getTextureCoords(vertexIndex)));
                }
            }
        }
        return result;
    }
}

