/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.render.mesh;

import com.sodiumarc.patchwork.render.mesh.PolyMaterial;
import com.sodiumarc.patchwork.render.mesh.PolyMesh3D;
import com.sodiumarc.patchwork.render.scenegraph.CoordinateSystem;
import com.sodiumarc.patchwork.util.VectorUtils;
import java.util.Iterator;
import java.util.List;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.apache.log4j.Logger;

public class Polygon3D {
    private final int _index;
    private final PolyMesh3D _mesh;
    private List<Integer> _vertexIndices;
    private List<Integer> _vertexColorIndices;
    private List<Integer> _textureCoordIndices;
    private final int _materialIndex;
    private final Vector3d _normal;
    private String _groupIdentifier;

    Polygon3D(PolyMesh3D mesh, int index, List<Integer> vetexIndices, List<Integer> vertexColorIndices, List<Integer> textureCoordIndices, Vector3d normal, int materialIndex) {
        assert (vetexIndices.size() >= 3);
        assert (vertexColorIndices == null || vertexColorIndices.size() == vetexIndices.size());
        assert (textureCoordIndices == null || textureCoordIndices.size() == vetexIndices.size());
        this._mesh = mesh;
        this._index = index;
        this._vertexIndices = vetexIndices;
        this._vertexColorIndices = vertexColorIndices;
        this._textureCoordIndices = textureCoordIndices;
        this._normal = normal == null ? this.computeNormal() : normal;
        this._materialIndex = materialIndex;
    }

    public int getIndex() {
        return this._index;
    }

    public PolyMesh3D getMesh() {
        return this._mesh;
    }

    public Point3d getVertex(int polyIndex) {
        return this._mesh.getVertices().get(this._vertexIndices.get(polyIndex));
    }

    public Point3d getVertex(int polyIndex, CoordinateSystem system) {
        if (system == null) {
            return this.getVertex(polyIndex);
        }
        List<Point3d> alternates = this._mesh.getAlternateVertices(system);
        if (alternates == null) {
            return null;
        }
        return alternates.get(this._vertexIndices.get(polyIndex));
    }

    public Color3f getVertexColor(int polyIndex) {
        return this.hasVertexColors() ? this._mesh.getColors().get(this._vertexColorIndices.get(polyIndex)) : null;
    }

    public Point3d getTextureCoords(int polyIndex) {
        return this.hasTextureCoords() ? this._mesh.getTextureCoordinates().get(this._textureCoordIndices.get(polyIndex)) : null;
    }

    public int getVertexCount() {
        return this._vertexIndices.size();
    }

    public PolyMaterial getMaterial() {
        if (this._materialIndex == -1) {
            return null;
        }
        List<PolyMaterial> materials = this._mesh.getMaterials();
        return materials.get(this._materialIndex);
    }

    public int getMaterialIndex() {
        return this._materialIndex;
    }

    public Iterator<Point3d> getVertexIterator(final CoordinateSystem system) {
        final Iterator<Integer> indexIter = this._vertexIndices.iterator();
        return new Iterator<Point3d>(){

            @Override
            public boolean hasNext() {
                return indexIter.hasNext();
            }

            @Override
            public Point3d next() {
                int index = (Integer)indexIter.next();
                return system == null ? Polygon3D.this._mesh.getVertices().get(index) : Polygon3D.this._mesh.getAlternateVertices(system).get(index);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public List<Integer> getVertexIndices() {
        return this._vertexIndices;
    }

    public int getVertexIndex(int polyIndex) {
        return this._vertexIndices.get(polyIndex);
    }

    public List<Integer> getVertexColorIndices() {
        return this._vertexColorIndices;
    }

    public List<Integer> getTextureCoordIndices() {
        return this._textureCoordIndices;
    }

    public Vector3d getNormal() {
        return this._normal;
    }

    public boolean hasVertexColors() {
        return this._vertexColorIndices != null;
    }

    public boolean hasTextureCoords() {
        return this._textureCoordIndices != null;
    }

    public String getGroupIdentifier() {
        return this._groupIdentifier;
    }

    public void setGroupIdentifier(String groupIdentifier) {
        this._groupIdentifier = groupIdentifier;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(\"" + this._groupIdentifier + "\") " + this._vertexIndices;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this._index;
        return result;
    }

    void setVertexIndices(List<Integer> vertexIndices) {
        this._vertexIndices = vertexIndices;
    }

    void setVertexColorIndices(List<Integer> vertexColorIndices) {
        this._vertexColorIndices = vertexColorIndices;
    }

    void setTextureCoordIndices(List<Integer> textureCoordIndices) {
        this._textureCoordIndices = textureCoordIndices;
    }

    private Vector3d computeNormal() {
        Point3d vertex0 = new Point3d();
        Vector3d cpVector1 = new Vector3d();
        Vector3d cpVector2 = new Vector3d();
        Vector3d normal = new Vector3d();
        vertex0.set(this.getVertex(0));
        int i = 0;
        for (i = 1; i < this.getVertexCount(); ++i) {
            cpVector1.set(this.getVertex(i));
            if (!cpVector1.equals(vertex0)) break;
        }
        cpVector1.sub(vertex0);
        do {
            if (++i >= this.getVertexCount()) {
                Logger.getLogger(this.getClass()).debug("Failed to compute normal. Degenerate polygon?");
                break;
            }
            cpVector2.set(this.getVertex(i));
            cpVector2.sub(vertex0);
        } while (VectorUtils.parallel(cpVector1, cpVector2, 0.0));
        normal.cross(cpVector1, cpVector2);
        normal.normalize();
        return normal;
    }
}

