/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.render.mesh;

import com.sodiumarc.patchwork.util.VectorUtils;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

public class Plane {
    private final Point3d planePoint;
    private final Vector3d planeUnitNormal;

    public Plane(Point3d planePoint, Vector3d planeUnitNormal) {
        this.planePoint = planePoint;
        this.planeUnitNormal = planeUnitNormal;
        this.planeUnitNormal.normalize();
    }

    public Point3d getPlanePoint() {
        return this.planePoint;
    }

    public Vector3d getPlaneUnitNormal() {
        return this.planeUnitNormal;
    }

    public double pointDistance(Point3d point) {
        return VectorUtils.pointPlaneDistance(point, this.planePoint, this.planeUnitNormal);
    }

    public double parametricLineIntersection(Point3d e0, Point3d e1) {
        return VectorUtils.parametricLinePlaneIntersection(e0, e1, this.planePoint, this.planeUnitNormal);
    }
}

