/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.render.mesh;

import com.sodiumarc.patchwork.render.mesh.Edge;
import com.sodiumarc.patchwork.util.VectorUtils;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

public class Path {
    private final List<Point3d> _vertices;
    private final LinkedList<Integer> _vertexIndices = new LinkedList();
    private double _totalLength = 0.0;

    public Path(List<Point3d> vertices) {
        assert (vertices.size() >= 2) : "vertex count " + vertices.size() + " < 2";
        this._vertices = vertices;
    }

    public List<Point3d> getVertices() {
        return this._vertices;
    }

    public int getVertexCount() {
        return this._vertexIndices.size();
    }

    public int getVertexIndex(int pathIndex) {
        return this._vertexIndices.get(pathIndex);
    }

    public Point3d getVertex(int pathIndex) {
        return this._vertices.get(this.getVertexIndex(pathIndex));
    }

    public double getTotalLength() {
        return this._totalLength;
    }

    public Path detach() {
        ArrayList<Point3d> vertices = new ArrayList<Point3d>(this.getVertexCount());
        for (int i = 0; i < this.getVertexCount(); ++i) {
            vertices.add(this._vertices.get(this.getVertexIndex(i)));
        }
        Integer[] indices = new Integer[this.getVertexCount()];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = i;
        }
        Path result = new Path(vertices);
        result.setVertexIndices(indices);
        return result;
    }

    public void prepend(Edge edge, boolean absorbParallel) {
        if (this.getVertexCount() == 0) {
            this._vertexIndices.addFirst(edge.getVertex1Index());
            this._vertexIndices.addFirst(edge.getVertex0Index());
        } else {
            int farIndex;
            if (edge.getVertex0Index() == this.getFirstVertexIndex()) {
                farIndex = edge.getVertex1Index();
            } else if (edge.getVertex1Index() == this.getFirstVertexIndex()) {
                farIndex = edge.getVertex0Index();
            } else {
                throw new IllegalArgumentException("Edge does not adjoin path.");
            }
            Vector3d edgeVector = edge.getEdgeVector(new Vector3d());
            Vector3d segmentVector = new Vector3d(this.getVertex(1));
            segmentVector.sub(this.getVertex(0));
            if (absorbParallel && VectorUtils.parallel(edgeVector, segmentVector, 0.01)) {
                this._vertexIndices.set(0, farIndex);
            } else {
                this._vertexIndices.addFirst(farIndex);
            }
        }
        this._totalLength += edge.getLength();
    }

    public void append(Edge edge, boolean absorbParallel) {
        if (this.getVertexCount() == 0) {
            this._vertexIndices.addFirst(edge.getVertex1Index());
            this._vertexIndices.addFirst(edge.getVertex0Index());
        } else {
            int farIndex;
            if (edge.getVertex0Index() == this.getLastVertexIndex()) {
                farIndex = edge.getVertex1Index();
            } else if (edge.getVertex1Index() == this.getLastVertexIndex()) {
                farIndex = edge.getVertex0Index();
            } else {
                throw new IllegalArgumentException("Edge does not adjoin path.");
            }
            Vector3d edgeVector = edge.getEdgeVector(new Vector3d());
            Vector3d segmentVector = new Vector3d(this.getVertex(this._vertexIndices.size() - 1));
            segmentVector.sub(this.getVertex(this._vertexIndices.size() - 2));
            if (absorbParallel && VectorUtils.parallel(edgeVector, segmentVector, 0.01)) {
                this._vertexIndices.set(this._vertexIndices.size() - 1, farIndex);
            } else {
                this._vertexIndices.addLast(farIndex);
            }
        }
        this._totalLength += edge.getLength();
    }

    public void prepend(Path path) {
        if (this.getVertexCount() == 0) {
            this._vertexIndices.addAll(path.getVertexIndices());
        } else if (path.getLastVertexIndex() == this.getFirstVertexIndex()) {
            for (int i = path.getVertexCount() - 1; i >= 0; --i) {
                this._vertexIndices.addFirst(path.getVertexIndex(i));
            }
        } else {
            throw new IllegalArgumentException("Path does not adjoin this path.");
        }
        this._totalLength += path.getTotalLength();
    }

    public void append(Path path) {
        if (this.getVertexCount() == 0) {
            this._vertexIndices.addAll(path.getVertexIndices());
        } else if (path.getFirstVertexIndex() == this.getLastVertexIndex()) {
            for (int i = 1; i < path.getVertexCount(); ++i) {
                this._vertexIndices.addLast(path.getVertexIndex(i));
            }
        } else {
            throw new IllegalArgumentException("Path does not adjoin this path.");
        }
        this._totalLength += path.getTotalLength();
    }

    public void setVertexIndices(Integer ... vertexIndices) {
        assert (vertexIndices.length >= 2) : "vertex count " + vertexIndices.length + " < 2";
        this._vertexIndices.clear();
        this._vertexIndices.addAll(Arrays.asList(vertexIndices));
        Vector3d segVec = new Vector3d();
        this._totalLength = 0.0;
        for (int i = 1; i < this._vertexIndices.size(); ++i) {
            segVec.sub(this._vertices.get(this._vertexIndices.get(i)), this._vertices.get(this._vertexIndices.get(i - 1)));
            this._totalLength += segVec.length();
        }
    }

    public List<Integer> getVertexIndices() {
        return Collections.unmodifiableList(this._vertexIndices);
    }

    public int getFirstVertexIndex() {
        if (this._vertexIndices.isEmpty()) {
            return -1;
        }
        return this._vertexIndices.getFirst();
    }

    public int getLastVertexIndex() {
        if (this._vertexIndices.isEmpty()) {
            return -1;
        }
        return this._vertexIndices.getLast();
    }

    public boolean isLoop() {
        if (this.getVertexCount() == 0) {
            return false;
        }
        return this.getFirstVertexIndex() == this.getLastVertexIndex();
    }

    public void shrinkLoop() {
        if (!this.isLoop()) {
            return;
        }
        if (this.getVertexCount() == 2) {
            return;
        }
        Vector3d firstSegmentVector = new Vector3d(this.getVertex(1));
        firstSegmentVector.sub(this.getVertex(0));
        Vector3d lastSegmentVector = new Vector3d(this.getVertex(this._vertexIndices.size() - 1));
        lastSegmentVector.sub(this.getVertex(this._vertexIndices.size() - 2));
        if (VectorUtils.parallel(firstSegmentVector, lastSegmentVector, 0.01)) {
            this._vertexIndices.removeLast();
            this._vertexIndices.set(0, this.getLastVertexIndex());
        }
    }

    public Path2D.Double toPath2D() {
        Path2D.Double result = new Path2D.Double();
        for (int j = 0; j < this.getVertexCount(); ++j) {
            Point3d point = this.getVertex(j);
            if (j == 0) {
                result.moveTo(point.x, point.y);
                continue;
            }
            result.lineTo(point.x, point.y);
        }
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + this._vertexIndices;
    }
}

