/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.render.control;

import com.sodiumarc.patchwork.FileUtils;
import com.sodiumarc.patchwork.generate.Card;
import com.sodiumarc.patchwork.generate.GeneratorResourceIO;
import com.sodiumarc.patchwork.render.BoundingBox3D;
import com.sodiumarc.patchwork.render.HoleMap;
import com.sodiumarc.patchwork.render.RenderResourceIO;
import com.sodiumarc.patchwork.render.control.ImageOutput;
import com.sodiumarc.patchwork.render.control.InputScene;
import com.sodiumarc.patchwork.render.control.RenderControl;
import com.sodiumarc.patchwork.render.control.RenderImageProperty;
import com.sodiumarc.patchwork.render.control.SceneLayer;
import com.sodiumarc.patchwork.render.mesh.PolyMesh3D;
import com.sodiumarc.patchwork.render.scenegraph.Camera;
import com.sodiumarc.patchwork.render.scenegraph.SceneGraphNode;
import com.sodiumarc.patchwork.render.scenegraph.Transform3D;
import com.sodiumarc.patchwork.util.Collection.CollectionUtils;
import com.sodiumarc.patchwork.util.Collection.Range;
import com.sodiumarc.patchwork.util.ColorUtils;
import com.sodiumarc.patchwork.util.GeometricAxis;
import com.sodiumarc.patchwork.util.Rectangle4d;
import com.sodiumarc.patchwork.util.StringUtils;
import com.sodiumarc.patchwork.util.image.ImageFilter;
import com.sodiumarc.patchwork.util.image.ImageUtils;
import com.sodiumarc.patchwork.util.xml.XMLUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import javax.vecmath.Point3d;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public class RenderImage
implements Comparable<RenderImage> {
    public static final String IMAGE_BASE_ATTR_NAME = "image_base";
    public static final String FILE_EXTENSION = "zip";
    private final String name;
    private final File storeDirectory;
    private final Map<RenderImageProperty, String> properties;
    private BufferedImage substituteImage;
    private BufferedImage baseImage;
    private HoleMap holeMap;
    private static final String IMAGE_ARCHIVE_FILENAME = "image.png";
    private static final String HOLE_ARCHIVE_FILENAME = "hole.png";
    private static final String PROPERTIES_ARCHIVE_FILENAME = ".properties";

    public static String completeImageName(String name, Node contextNode) {
        if (name == null) {
            return null;
        }
        if (name.indexOf(".") >= 0) {
            return name;
        }
        String imageBase = RenderImage.getImageBase(contextNode);
        if (imageBase != null) {
            return imageBase + "." + name;
        }
        Logger.getLogger(RenderImage.class).warn("No image base found for " + name);
        return name;
    }

    public static String getImageBase(Node contextNode) {
        String imageBase = null;
        while (imageBase == null && contextNode != null) {
            imageBase = XMLUtils.getAttributes(contextNode).get(IMAGE_BASE_ATTR_NAME);
            contextNode = contextNode.getParentNode();
        }
        return imageBase;
    }

    public static long getLasModTime(String name, File storeDirectory) {
        String propsFilename = FileUtils.addExtension(name, "properties");
        File propsFile = new File(storeDirectory, propsFilename);
        return propsFile.lastModified();
    }

    public static boolean exists(String name, File storeDirectory) {
        String propsFilename = FileUtils.addExtension(name, "properties");
        File propsFile = new File(storeDirectory, propsFilename);
        return propsFile.exists();
    }

    public static RenderImage load(String name, File storeDirectory) {
        Map<RenderImageProperty, String> loadedProperties = null;
        try {
            loadedProperties = RenderResourceIO.getInstance().getImageProperties(storeDirectory, name);
        }
        catch (FileNotFoundException e) {
            Logger.getLogger(RenderImage.class).warn("Properties not found for " + name + ": ", e);
        }
        catch (IOException e) {
            Logger.getLogger(RenderImage.class).warn("Error reading properties for " + name + ": ", e);
        }
        if (loadedProperties == null) {
            return null;
        }
        return new RenderImage(name, storeDirectory, null, null, loadedProperties);
    }

    public RenderImage(String name, File storeDirectory, BufferedImage image, HoleMap holeMap, InputScene scene, ImageOutput output, String layerID) {
        this.name = name;
        this.storeDirectory = storeDirectory;
        this.properties = new EnumMap<RenderImageProperty, String>(RenderImageProperty.class);
        this.baseImage = image;
        this.holeMap = holeMap == null ? new HoleMap() : holeMap;
        this.computeProperties(scene, output, layerID);
    }

    public RenderImage(String name, File storeDirectory, BufferedImage image, HoleMap holeMap, Map<RenderImageProperty, String> properties) {
        assert (name != null) : "Null name not allowed";
        this.name = name;
        this.storeDirectory = storeDirectory;
        this.properties = properties;
        this.baseImage = image;
        this.holeMap = holeMap;
    }

    public String getName() {
        return this.name;
    }

    public String getImageFilename() {
        return this.isEmpty() ? null : FileUtils.addExtension(this.name, "png");
    }

    public List<String> getLayerIDs() {
        return this.getProperty(RenderImageProperty.LAYER_IDS, List.class);
    }

    public List<String> getMatchingLayerIDs(List<String> idPatterns) {
        ArrayList<String> result = new ArrayList<String>();
        for (String idPattern : idPatterns) {
            Pattern pattern = Pattern.compile(idPattern);
            for (String layerID : this.getLayerIDs()) {
                if (!pattern.matcher(layerID).matches()) continue;
                result.add(layerID);
            }
        }
        return result;
    }

    public <T> T getProperty(RenderImageProperty property, Class<T> valueType) {
        String str = this.properties.get((Object)property);
        if (str == null) {
            return (T)property.getDefaultValue();
        }
        return property.decodeValue(str, valueType);
    }

    public Map<RenderImageProperty, String> getProperties() {
        return this.properties;
    }

    public void setProperty(RenderImageProperty property, Object value) {
        String str = property.encodeValue(value);
        this.properties.put(property, str);
    }

    public BufferedImage getImage() {
        BufferedImage substitute = this.getSubstituteImage();
        if (substitute != null) {
            return substitute;
        }
        if (this.getProperty(RenderImageProperty.SUBSTITUTED, Boolean.class).booleanValue()) {
            return null;
        }
        return this.getBaseImage();
    }

    public BufferedImage getBaseImage() {
        if (this.baseImage == null) {
            try {
                this.baseImage = RenderResourceIO.getInstance().getOutputImage(this.storeDirectory, this.name);
            }
            catch (IOException e) {
                Logger.getLogger(RenderImage.class).warn("Error reading image for " + this.name + ": ", e);
                return null;
            }
        }
        return this.baseImage;
    }

    public BufferedImage getSubstituteImage() {
        if (this.substituteImage != null) {
            return this.substituteImage;
        }
        BufferedImage baseImage = this.getBaseImage();
        if (baseImage != null) {
            BufferedImage substituteUnscaled;
            try {
                substituteUnscaled = RenderResourceIO.getInstance().getSubstituteImage(this.name);
            }
            catch (IOException e) {
                Logger.getLogger(RenderImage.class).warn("Error reading image for " + this.name + ": ", e);
                return null;
            }
            if (substituteUnscaled != null) {
                this.substituteImage = ImageUtils.scale(substituteUnscaled, baseImage.getWidth(), baseImage.getHeight());
            }
        }
        return this.substituteImage;
    }

    public boolean isEmpty() {
        return this.getImage() == null;
    }

    public HoleMap getHoleMap() {
        if (this.holeMap == null) {
            BufferedImage holeMapImage = null;
            try {
                String filename = this.getHoleMapFilename();
                holeMapImage = RenderResourceIO.getInstance().getOutputImage(this.storeDirectory, filename);
            }
            catch (IOException e) {
                Logger.getLogger(RenderImage.class).warn("Error reading image for " + this.name + ": ", e);
            }
            if (holeMapImage != null) {
                Point offset = this.getOffset();
                this.holeMap = new HoleMap(holeMapImage, offset.x, offset.y, false);
            } else {
                this.holeMap = new HoleMap();
            }
        }
        return this.holeMap;
    }

    public Camera getCamera() {
        Transform3D transform = this.getProperty(RenderImageProperty.CAMERA_TRANSFORM, Transform3D.class);
        return transform == null ? null : new Camera(this.getName(), transform);
    }

    public double getNearClipDistance() {
        return this.getProperty(RenderImageProperty.NEAR_CLIP_DISTANCE, Double.class);
    }

    public Rectangle4d getReferenceRectangle(boolean boundsProportional) {
        Rectangle4d refRect = this.getProperty(RenderImageProperty.REFERENCE_RECTANGLE, Rectangle4d.class);
        if (refRect == null) {
            return null;
        }
        return boundsProportional ? this.getProjectedBounds().toProportional(refRect) : RenderControl.CAMERA_VIEWPORT.toProportional(refRect);
    }

    public BoundingBox3D getReferenceBounds3D() {
        return this.getProperty(RenderImageProperty.REFERENCE_BOUNDS, BoundingBox3D.class);
    }

    public void drawReferenceRectangle() {
        if (this.isEmpty()) {
            return;
        }
        Rectangle4d refRect = this.getReferenceRectangle(true);
        Point offset = this.getOffset();
        if (refRect != null) {
            refRect = Card.CARD_RECT.fromProportional(refRect);
            Graphics g = this.getImage().getGraphics();
            g.setColor(Color.RED);
            g.drawRect((int)refRect.getX() - offset.x, (int)refRect.getY() - offset.y, (int)refRect.getWidth(), (int)refRect.getHeight());
            g.dispose();
        }
    }

    public Dimension getImageSize() {
        if (this.isEmpty()) {
            return new Dimension(0, 0);
        }
        BufferedImage image = this.getImage();
        return new Dimension(image.getWidth(), image.getHeight());
    }

    public Rectangle4d getImageRect() {
        Point offset = this.getOffset();
        Dimension size = this.getImageSize();
        return new Rectangle4d(offset.x, offset.y, size.width, size.height);
    }

    public Point getOffset() {
        return this.getProperty(RenderImageProperty.IMAGE_OFFSET, Point.class);
    }

    public Rectangle4d getProjectedBounds() {
        return this.getProperty(RenderImageProperty.PROJECTED_BOUNDS, Rectangle4d.class);
    }

    public Rectangle4d getHotspotProjectedBounds(String hotspotID) {
        for (int i = 0; i < RenderImageProperty.HOTSPOT_ID_PROPERTIES.length; ++i) {
            String id = this.getProperty(RenderImageProperty.HOTSPOT_ID_PROPERTIES[i], String.class);
            if (!hotspotID.equals(id)) continue;
            return this.getProperty(RenderImageProperty.HOTSPOT_BOUNDS_PROPERTIES[i], Rectangle4d.class);
        }
        return null;
    }

    public Rectangle4d getBoundsProportionalTo(RenderImage proportionalToImage) {
        Rectangle4d bounds = this.getProjectedBounds();
        Rectangle4d proportionalToBounds = proportionalToImage.getProjectedBounds();
        if (bounds == null || proportionalToBounds == null) {
            return null;
        }
        return proportionalToBounds.toProportional(bounds);
    }

    public List<RenderImage> generateShadows(int stages, Range<Integer> radiusRange, Range<Float> alphaRange, List<? extends ImageFilter> filters) {
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RenderImage> result = new ArrayList<RenderImage>(stages);
        int radiusStep = stages <= 1 ? 0 : (radiusRange.getMax() - radiusRange.getMin()) / (stages - 1);
        float alphaStep = stages <= 1 ? 0.0f : (alphaRange.getMin().floatValue() - alphaRange.getMax().floatValue()) / (float)(stages - 1);
        int radius = radiusRange.getMin();
        float alpha = alphaRange.getMax().floatValue();
        for (int i = 0; i < stages; ++i) {
            EnumMap<RenderImageProperty, String> properties = new EnumMap<RenderImageProperty, String>(RenderImageProperty.class);
            BufferedImage shadow = this.generateShadow(this.baseImage, radius, alpha, filters, properties);
            String shadowName = this.name + "_SHADOW" + Integer.toString(i);
            result.add(new RenderImage(shadowName, null, shadow, new HoleMap(), properties));
            radius += radiusStep;
            alpha += alphaStep;
        }
        return result;
    }

    public void write() throws IOException {
        this.writeImage();
        this.writeProperties();
    }

    public void store() throws IOException {
        String filename = FileUtils.addExtension(this.name, FILE_EXTENSION);
        FileOutputStream ostream = new FileOutputStream(new File(this.storeDirectory, filename));
        this.store(ostream);
        ((OutputStream)ostream).close();
    }

    public void store(OutputStream ostream) throws IOException {
        ByteArrayOutputStream zipBytes = new ByteArrayOutputStream();
        ZipOutputStream zipOut = new ZipOutputStream(new BufferedOutputStream(zipBytes));
        zipOut.putNextEntry(new ZipEntry(IMAGE_ARCHIVE_FILENAME));
        ByteArrayOutputStream imageBytes = new ByteArrayOutputStream();
        MemoryCacheImageOutputStream imageOut = new MemoryCacheImageOutputStream(imageBytes);
        ImageIO.write((RenderedImage)this.baseImage, "png", imageOut);
        imageBytes.close();
        zipOut.write(imageBytes.toByteArray());
        zipOut.closeEntry();
        HoleMap holeMap = this.getHoleMap();
        if (!holeMap.isEmpty()) {
            zipOut.putNextEntry(new ZipEntry(HOLE_ARCHIVE_FILENAME));
            holeMap.mapRegion(this.getImageRect().getBounds());
            imageBytes = new ByteArrayOutputStream();
            imageOut = new MemoryCacheImageOutputStream(imageBytes);
            ImageIO.write((RenderedImage)holeMap.createHoleImage(), "png", imageOut);
            imageBytes.close();
            zipOut.write(imageBytes.toByteArray());
            zipOut.closeEntry();
        }
        zipOut.putNextEntry(new ZipEntry(PROPERTIES_ARCHIVE_FILENAME));
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(zipOut));
        RenderImageProperty.toProperties(this.properties).store(writer, null);
        zipOut.closeEntry();
        zipOut.close();
        ostream.write(zipBytes.toByteArray());
    }

    public void publish() throws IOException {
        GeneratorResourceIO.getInstance().writeOutputImage(this.getImage(), this.getImageFilename());
    }

    public File getStoreDirectory() {
        return this.storeDirectory;
    }

    @Override
    public int compareTo(RenderImage o) {
        if (o == null) {
            return 1;
        }
        int dirCompare = this.storeDirectory.compareTo(o.storeDirectory);
        if (dirCompare != 0) {
            return dirCompare;
        }
        return this.name.compareTo(o.name);
    }

    public String toString() {
        return "RenderedImage [name=" + this.name + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.storeDirectory == null ? 0 : this.storeDirectory.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RenderImage other = (RenderImage)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.storeDirectory == null ? other.storeDirectory != null : !this.storeDirectory.equals(other.storeDirectory));
    }

    private String getHoleMapFilename() {
        return this.name + "_HOLE";
    }

    private void computeProperties(InputScene scene, ImageOutput output, String layerID) {
        Camera camera = scene.getSceneGraph().getCamera(output.getCameraID());
        Point adjustedOrigin = null;
        if (camera != null) {
            SceneGraphNode node;
            String originNodeId;
            PolyMesh3D referenceMesh;
            PolyMesh3D frameMesh = scene.getFrameMesh(output);
            if (frameMesh != null) {
                BoundingBox3D bbox = frameMesh.getBoundingBox();
                double clipDistance = Math.abs(bbox.getRange(GeometricAxis.Z).getMin());
                this.setProperty(RenderImageProperty.NEAR_CLIP_DISTANCE, clipDistance);
                this.setProperty(RenderImageProperty.PROJECTED_BOUNDS, camera.getProjectedBounds(frameMesh));
            }
            PolyMesh3D polyMesh3D = referenceMesh = layerID == null ? scene.getReferenceMesh(output) : scene.getReferenceMesh(output, layerID);
            if (referenceMesh != null) {
                BoundingBox3D bbox = referenceMesh.getBoundingBox();
                this.setProperty(RenderImageProperty.REFERENCE_BOUNDS, bbox);
                this.setProperty(RenderImageProperty.REFERENCE_RECTANGLE, camera.getProjectedBounds(referenceMesh));
            }
            this.setProperty(RenderImageProperty.CAMERA_TRANSFORM, camera.getCumulativeTransform());
            Map<String, PolyMesh3D> hotspotMeshes = scene.getHotspotMeshes(output);
            int hotspotIndex = 0;
            for (Map.Entry<String, PolyMesh3D> entry : hotspotMeshes.entrySet()) {
                Rectangle4d hotspotBounds = camera.getProjectedBounds(entry.getValue());
                this.setProperty(RenderImageProperty.HOTSPOT_ID_PROPERTIES[hotspotIndex], entry.getKey());
                this.setProperty(RenderImageProperty.HOTSPOT_BOUNDS_PROPERTIES[hotspotIndex], hotspotBounds);
                if (++hotspotIndex < RenderImageProperty.HOTSPOT_ID_PROPERTIES.length) continue;
                break;
            }
            if ((originNodeId = output.getProperties().getOriginNodeID()) != null && (node = CollectionUtils.first(scene.getSceneGraph().getNodes(originNodeId))) != null) {
                Point3d origin = node.getOriginInGlobalCoords();
                origin = camera.globalToCamera(origin);
                origin = camera.cameraToProjected(origin);
                origin = camera.projectedToDisplay(origin, output.getTotalViewport(), Card.CARD_DIMENSION, new Point3d());
                adjustedOrigin = new Point((int)origin.x, (int)origin.y);
            }
        }
        List<Object> layerIDs = new ArrayList();
        if (layerID != null) {
            layerIDs = Collections.singletonList(layerID);
        } else {
            for (SceneLayer layer : scene.getLayers(output)) {
                layerIDs.add(layer.getID());
            }
        }
        this.setProperty(RenderImageProperty.SUBSTITUTED, output.getProperties().isSubstituted());
        this.setProperty(RenderImageProperty.LAYER_IDS, layerIDs);
        Rectangle4d totalImageRect = output.getTotalImageRect();
        Point offset = adjustedOrigin == null ? new Point((int)totalImageRect.getX(), (int)totalImageRect.getY()) : new Point(-adjustedOrigin.x, -adjustedOrigin.y);
        this.setProperty(RenderImageProperty.IMAGE_OFFSET, offset);
    }

    private BufferedImage generateShadow(BufferedImage composite, int radius, float alpha, List<? extends ImageFilter> filters, Map<RenderImageProperty, String> properties) {
        int iterations = radius < 4 ? 1 : 4;
        int iteradius = (int)Math.ceil((double)radius / (double)iterations);
        int[] radii = new int[iterations];
        for (int i = 0; i < iterations; ++i) {
            radii[i] = iteradius;
        }
        int margin = radius;
        BufferedImage silhouette = ImageUtils.silhouette(ImageUtils.copy(composite), ColorUtils.blend(ColorUtils.CLEAR_COLOR, Color.BLACK, alpha), ColorUtils.CLEAR_COLOR);
        BufferedImage result = ImageUtils.addBorder(silhouette, ColorUtils.CLEAR_COLOR, margin);
        for (int r : radii) {
            result = ImageUtils.boxBlur(result, r);
        }
        result = ImageUtils.fadeMargins(result, new Rectangle4d(radius, radius, Card.CARD_SIZE, Card.CARD_SIZE));
        for (ImageFilter imageFilter : filters) {
            result = imageFilter.apply(result, null);
        }
        int crop = (int)Math.floor((float)radius * 0.6f);
        result = result.getSubimage(crop, crop, result.getWidth() - 2 * crop, result.getHeight() - 2 * crop);
        properties.put(RenderImageProperty.IMAGE_OFFSET, StringUtils.encodePoint(new Point(crop - radius, crop - radius)));
        return result;
    }

    private void writeImage() throws IOException {
        RenderResourceIO resourceIO = RenderResourceIO.getInstance();
        resourceIO.writeOutputImage(this.baseImage, this.storeDirectory, this.name);
        HoleMap holeMap = this.getHoleMap();
        if (!holeMap.isEmpty()) {
            holeMap.mapRegion(this.getImageRect().getBounds());
            resourceIO.writeOutputImage(holeMap.createHoleImage(), this.storeDirectory, this.getHoleMapFilename());
        }
    }

    private void writeProperties() throws IOException {
        RenderResourceIO.getInstance().writeOutputImageProperties(RenderImageProperty.toProperties(this.properties), this.storeDirectory, this.name);
    }
}

