/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.render.control;

import com.sodiumarc.patchwork.FileUtils;
import com.sodiumarc.patchwork.render.DeepImage;
import com.sodiumarc.patchwork.render.HoleMap;
import com.sodiumarc.patchwork.render.RenderObject;
import com.sodiumarc.patchwork.render.RenderQuality;
import com.sodiumarc.patchwork.render.RenderResourceIO;
import com.sodiumarc.patchwork.render.WritableDeepImage;
import com.sodiumarc.patchwork.render.control.Background;
import com.sodiumarc.patchwork.render.control.EdgeAppearance;
import com.sodiumarc.patchwork.render.control.FillAppearance;
import com.sodiumarc.patchwork.render.control.ImageOutput;
import com.sodiumarc.patchwork.render.control.ImageOutputID;
import com.sodiumarc.patchwork.render.control.ImageOutputLayerID;
import com.sodiumarc.patchwork.render.control.InputScene;
import com.sodiumarc.patchwork.render.control.InputSceneID;
import com.sodiumarc.patchwork.render.control.RenderImage;
import com.sodiumarc.patchwork.render.control.RenderImageProperty;
import com.sodiumarc.patchwork.render.control.RenderProgressObserver;
import com.sodiumarc.patchwork.render.control.SceneLayer;
import com.sodiumarc.patchwork.render.mesh.PolyMesh3D;
import com.sodiumarc.patchwork.render.scenegraph.Camera;
import com.sodiumarc.patchwork.render.scenegraph.PointLight;
import com.sodiumarc.patchwork.util.Collection.CollectionUtils;
import com.sodiumarc.patchwork.util.Rectangle4d;
import com.sodiumarc.patchwork.util.image.ImageUtils;
import com.sodiumarc.patchwork.util.xml.XMLUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class RenderControl {
    public static final Rectangle4d BLENDER_VIEWPORT = new Rectangle4d(-0.45, -0.45, 0.9, 0.9);
    public static final Rectangle4d CAMERA_VIEWPORT = new Rectangle4d(-0.5, -0.5, 1.0, 1.0);
    public static final RenderCondition DEFAULT_CONDITION = RenderCondition.NEVER;
    private final List<RenderProgressObserver> observers;
    private final Map<InputSceneID, InputScene> loadedScenesByID;
    private RenderQuality quality = RenderQuality.FASTEST;
    private static RenderControl INSTANCE;
    private static final Logger LOGGER;
    private static final Logger REFERENCE_RECTANGLE_LOGGER;
    private static final Logger TIMESTAMPED_IMAGE_LOGGER;
    private static int ID_COUNTER;

    public static String newUniqueIDString() {
        return Long.toHexString(System.currentTimeMillis()) + "_" + Long.toHexString(ID_COUNTER++);
    }

    public static RenderControl getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RenderControl();
        }
        return INSTANCE;
    }

    public RenderControl() {
        this.observers = new ArrayList<RenderProgressObserver>();
        this.loadedScenesByID = new HashMap<InputSceneID, InputScene>();
    }

    public void addRenderProgressObserver(RenderProgressObserver observer) {
        this.observers.add(observer);
    }

    public void removeRenderProgressObserver(RenderProgressObserver observer) {
        this.observers.remove(observer);
    }

    public void setRenderQuality(RenderQuality quality) {
        this.quality = quality;
    }

    public Set<InputSceneID> getSceneIDs() throws IOException, ParserConfigurationException, SAXException {
        HashSet<InputSceneID> result = new HashSet<InputSceneID>();
        for (Document document : RenderResourceIO.getInstance().getXMLDocuments()) {
            Element docNode = document.getDocumentElement();
            String filename = XMLUtils.getFilename(docNode);
            Set<String> sceneLocalIDs = InputScene.getLocalSceneIDs(document);
            assert (sceneLocalIDs.size() > 0) : "No scenes found in file: " + sceneLocalIDs;
            if (sceneLocalIDs.size() == 1) {
                result.add(new InputSceneID(filename, null));
                continue;
            }
            for (String sceneLocalID : sceneLocalIDs) {
                result.add(new InputSceneID(filename, sceneLocalID));
            }
        }
        return result;
    }

    public long getLastModificationTime(InputSceneID sceneID) throws IOException, ParserConfigurationException, SAXException {
        RenderResourceIO resourceIO = RenderResourceIO.getInstance();
        String filename = sceneID.getFilename();
        File xmlFile = new File(resourceIO.getXmlInputDir(), filename);
        long xmlModTime = xmlFile.lastModified();
        Document document = resourceIO.getXMLDocument(sceneID.getFilename());
        String colladaFilename = InputScene.getInputFilename(document, sceneID.getSceneLocalID());
        if (colladaFilename == null) {
            colladaFilename = InputScene.getInputFilename(document, sceneID.getSceneLocalID());
        }
        assert (colladaFilename != null) : "No collada file: " + sceneID;
        File colladaFile = new File(resourceIO.getColladaInputDir(), colladaFilename);
        long colladaModTime = colladaFile.lastModified();
        return Math.max(xmlModTime, colladaModTime);
    }

    public Set<ImageOutputID> getImageOutputIDs(InputSceneID id, boolean fromDisk) throws IOException, ParserConfigurationException, SAXException {
        HashSet<ImageOutputID> result = new HashSet<ImageOutputID>();
        if (fromDisk) {
            for (String name : FileUtils.getAllFilenames(RenderResourceIO.getInstance().getImageOutputDir(), "properties")) {
                String imageName = FileUtils.getFilenameWithoutExtension(name);
                if (!imageName.startsWith(id.getStringForm())) continue;
                result.add(new ImageOutputID(imageName));
            }
        } else {
            InputScene scene = this.getInputScene(id);
            if (scene.isAutoCreateImages()) {
                scene.loadData();
            }
            for (ImageOutput output : scene.getImageOutputs()) {
                result.add(new ImageOutputID(id, output.getID()));
            }
        }
        return result;
    }

    public Set<ImageOutputLayerID> getLayerIDs(ImageOutputID id) throws IOException, ParserConfigurationException, SAXException {
        LinkedHashSet<ImageOutputLayerID> result = new LinkedHashSet<ImageOutputLayerID>();
        if (this.isRenderImageCurrent(id)) {
            RenderImage image = this.getRenderImage(id, RenderCondition.NEVER);
            for (String layerID : image.getLayerIDs()) {
                result.add(new ImageOutputLayerID(id, layerID));
            }
        } else {
            InputScene scene = this.getInputScene(id.getSceneID());
            scene.loadData();
            ImageOutput imageOutput = scene.getImageOutput(id.getImageLocalID());
            if (imageOutput == null) {
                LOGGER.warn("Missing image output: " + id);
            } else {
                for (SceneLayer layer : scene.getLayers(imageOutput)) {
                    result.add(new ImageOutputLayerID(id, layer.getID()));
                }
            }
        }
        return result;
    }

    public long[] getFrameTimes(ImageOutputLayerID id) throws ParserConfigurationException, SAXException, IOException {
        InputScene scene = this.getInputScene(id.getSceneID());
        scene.loadData();
        NavigableSet<Double> frames = scene.getSceneGraph().getKeyframes();
        long[] result = new long[frames.size()];
        int resultIndex = 0;
        for (Double frameDouble : scene.getSceneGraph().getKeyframes()) {
            result[resultIndex++] = (long)(frameDouble * 1000.0);
        }
        return result;
    }

    public boolean isRenderImageCurrent(ImageOutputLayerID id) throws IOException, ParserConfigurationException, SAXException {
        File storeDirectory = RenderResourceIO.getInstance().getLayerOutputDir();
        if (!RenderImage.exists(id.getStringForm(), storeDirectory)) {
            return false;
        }
        long imageModTime = RenderImage.getLasModTime(id.getStringForm(), storeDirectory);
        long sceneModTime = this.getLastModificationTime(id.getSceneID());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(id + ": image mod = " + new Date(imageModTime) + " scene mod = " + new Date(sceneModTime));
        }
        return imageModTime >= sceneModTime;
    }

    public boolean isRenderImageCurrent(ImageOutputID id) throws IOException, ParserConfigurationException, SAXException {
        long sceneModTime;
        long imageModTime = RenderImage.getLasModTime(id.getStringForm(), RenderResourceIO.getInstance().getImageOutputDir());
        return imageModTime >= (sceneModTime = this.getLastModificationTime(id.getSceneID()));
    }

    public RenderImage getLineImage(ImageOutputLayerID id) throws IOException, ParserConfigurationException, SAXException {
        return this.renderLayer(id, false, true);
    }

    public RenderImage getRenderImage(Object id, RenderCondition renderCondition) throws IOException, ParserConfigurationException, SAXException {
        if (id instanceof ImageOutputID) {
            return this.getRenderImage((ImageOutputID)id, renderCondition);
        }
        return this.getRenderImage((ImageOutputLayerID)id, renderCondition);
    }

    public RenderImage getRenderImage(ImageOutputLayerID id, RenderCondition renderCondition) throws IOException, ParserConfigurationException, SAXException {
        RenderImage image = null;
        if (renderCondition != RenderCondition.ALWAYS && (image = RenderImage.load(id.getStringForm(), RenderResourceIO.getInstance().getLayerOutputDir())) != null && this.isRenderImageCurrent(id)) {
            return image;
        }
        if (renderCondition != RenderCondition.NEVER) {
            image = this.renderLayer(id, true, true);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Rendering image: " + id);
            }
            if (image != null) {
                image.write();
            }
        }
        return image;
    }

    public RenderImage getRenderImage(ImageOutputID id, RenderCondition renderCondition) throws IOException, ParserConfigurationException, SAXException {
        RenderResourceIO resourceIO = RenderResourceIO.getInstance();
        RenderImage image = null;
        if (renderCondition != RenderCondition.ALWAYS && (image = RenderImage.load(id.getStringForm(), resourceIO.getImageOutputDir())) != null && this.isRenderImageCurrent(id)) {
            return image;
        }
        if (renderCondition != RenderCondition.NEVER) {
            this.fireImageRenderStarted(id);
            ArrayList<RenderImage> images = new ArrayList<RenderImage>();
            CollectionUtils.addIfNotNull(images, this.renderBackground(id));
            EnumMap<RenderImageProperty, String> compositeProperties = new EnumMap<RenderImageProperty, String>(RenderImageProperty.class);
            for (ImageOutputLayerID layerId : this.getLayerIDs(id)) {
                RenderImage layerImage = this.getRenderImage(layerId, RenderCondition.NEVER);
                if (layerImage == null) continue;
                images.add(layerImage);
                compositeProperties.putAll(layerImage.getProperties());
            }
            image = this.createComposite(id.getStringForm(), resourceIO.getImageOutputDir(), images, compositeProperties);
            if (image != null) {
                image.write();
                if (TIMESTAMPED_IMAGE_LOGGER.isDebugEnabled()) {
                    String tempImageName = id + "_" + System.currentTimeMillis();
                    resourceIO.writeTemporaryImage(image.getImage(), tempImageName);
                }
            } else {
                LOGGER.warn("No layers found for image: " + id);
            }
            this.fireImageRenderComplete(id);
        }
        return image;
    }

    public RenderImage getLayerImage(RenderImage image, String layerID, RenderCondition renderCondition) throws IOException, ParserConfigurationException, SAXException {
        ImageOutputLayerID id = new ImageOutputLayerID(new ImageOutputID(image.getName()), layerID);
        return this.getRenderImage(id, renderCondition);
    }

    public RenderImage getLayerComposite(ImageOutputID id, List<String> layerIDs, String dominantLayerID) throws IOException, ParserConfigurationException, SAXException {
        if (layerIDs == null) {
            return this.getRenderImage(id, DEFAULT_CONDITION);
        }
        assert (!layerIDs.isEmpty()) : "layerIDs is empty (for image: " + id + ")";
        String compositeName = id + "_LYRS" + RenderControl.newUniqueIDString();
        EnumMap<RenderImageProperty, String> compositeProperties = new EnumMap<RenderImageProperty, String>(RenderImageProperty.class);
        ArrayList<RenderImage> images = new ArrayList<RenderImage>();
        for (String layerID : layerIDs) {
            RenderImage image = this.getRenderImage(new ImageOutputLayerID(id, layerID), RenderCondition.NEVER);
            assert (image != null) : "Missing image: " + image + ", layerID = " + layerID;
            Map<RenderImageProperty, String> imageProperties = image.getProperties();
            for (RenderImageProperty property : RenderImageProperty.values()) {
                String value = imageProperties.get((Object)property);
                if (value == null || dominantLayerID != null && !layerID.equals(dominantLayerID)) continue;
                compositeProperties.put(property, value);
            }
            images.add(image);
        }
        return this.createComposite(compositeName, images, compositeProperties);
    }

    public List<RenderImage> getAllMatching(String imageOutputIDPattern, List<String> layerIDs, String dominantLayerID) throws IOException, ParserConfigurationException, SAXException {
        TreeSet<RenderImage> treeSet = new TreeSet<RenderImage>();
        Pattern pattern = Pattern.compile(imageOutputIDPattern);
        for (InputSceneID sceneID : this.getSceneIDs()) {
            Set<ImageOutputID> imageOutputIDs = this.getImageOutputIDs(sceneID, true);
            for (ImageOutputID imageOutputID : imageOutputIDs) {
                if (!pattern.matcher(imageOutputID.getStringForm()).matches()) continue;
                if (layerIDs != null && layerIDs.size() == 1) {
                    String layerID = CollectionUtils.first(layerIDs);
                    ImageOutputLayerID layerImageID = new ImageOutputLayerID(imageOutputID, layerID);
                    RenderImage image = this.getRenderImage(layerImageID, DEFAULT_CONDITION);
                    assert (image != null) : "Missing image: " + layerImageID;
                    treeSet.add(image);
                    continue;
                }
                treeSet.add(this.getLayerComposite(imageOutputID, layerIDs, dominantLayerID));
            }
        }
        return new ArrayList<RenderImage>(treeSet);
    }

    public RenderImage createComposite(String name, List<RenderImage> images) {
        return this.createComposite(name, null, images, null);
    }

    public RenderImage createComposite(String name, File storeDirectory, List<RenderImage> images) {
        return this.createComposite(name, storeDirectory, images, null);
    }

    public RenderImage createComposite(String name, List<RenderImage> images, Map<RenderImageProperty, String> compositeProperties) {
        return this.createComposite(name, null, images, compositeProperties);
    }

    public RenderImage createComposite(String name, File storeDirectory, List<RenderImage> images, Map<RenderImageProperty, String> compositeProperties) {
        boolean propertiesProvided;
        if (images.size() == 0) {
            return null;
        }
        if (name == null) {
            name = CollectionUtils.last(images).getName().hashCode() + "_COMP" + RenderControl.newUniqueIDString();
        }
        boolean bl = propertiesProvided = compositeProperties != null;
        if (compositeProperties == null) {
            compositeProperties = new EnumMap<RenderImageProperty, String>(RenderImageProperty.class);
        }
        Rectangle4d compositeRect = null;
        ArrayList<String> compositeLayerIDs = new ArrayList<String>();
        for (RenderImage image : images) {
            compositeLayerIDs.addAll(image.getLayerIDs());
            Rectangle4d imageRect = image.getImageRect();
            if (compositeRect == null) {
                compositeRect = new Rectangle4d(imageRect);
                continue;
            }
            compositeRect = compositeRect.combine(imageRect);
        }
        BufferedImage composite = null;
        HoleMap compositeHoleMap = new HoleMap();
        if (compositeRect != null) {
            Rectangle compositeBounds = compositeRect.getBounds();
            compositeProperties.put(RenderImageProperty.IMAGE_OFFSET, RenderImageProperty.IMAGE_OFFSET.encodeValue(new Point(compositeBounds.x, compositeBounds.y)));
            composite = new BufferedImage(compositeBounds.width, compositeBounds.height, 2);
            Graphics2D graphics = (Graphics2D)composite.getGraphics();
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            for (RenderImage image : images) {
                if (!propertiesProvided) {
                    compositeProperties.putAll(image.getProperties());
                }
                if (image.isEmpty()) continue;
                Point imageOffset = image.getOffset();
                HoleMap imageHoleMap = image.getHoleMap();
                imageHoleMap.applyTo(composite, 0, 0);
                imageHoleMap.applyTo(compositeHoleMap);
                graphics.drawImage((Image)image.getImage(), imageOffset.x - compositeBounds.x, imageOffset.y - compositeBounds.y, null);
            }
            graphics.dispose();
        }
        if (storeDirectory == null) {
            storeDirectory = images.get(0).getStoreDirectory();
        }
        RenderImage result = new RenderImage(name, storeDirectory, composite, compositeHoleMap, compositeProperties);
        result.setProperty(RenderImageProperty.LAYER_IDS, compositeLayerIDs);
        result.setProperty(RenderImageProperty.SUBSTITUTED, false);
        return result;
    }

    public RenderImage createDummy(String name, Dimension size) {
        BufferedImage dummy = new BufferedImage(size.width, size.height, 2);
        ImageUtils.fill(dummy, Color.BLACK);
        return new RenderImage(name, null, dummy, new HoleMap(), new EnumMap<RenderImageProperty, String>(RenderImageProperty.class));
    }

    public void clearCache() {
        this.loadedScenesByID.clear();
    }

    private InputScene getInputScene(InputSceneID id) throws ParserConfigurationException, SAXException, IOException {
        InputScene scene = this.loadedScenesByID.get(id);
        if (scene == null) {
            Map<String, InputScene> inputsByID = InputScene.loadFromFile(id.getFilename());
            String sceneLocalID = id.getSceneLocalID();
            InputScene inputScene = scene = sceneLocalID != null ? inputsByID.get(sceneLocalID) : CollectionUtils.firstValue(inputsByID);
            assert (scene != null) : "Invalid scene ID: " + id;
            this.loadedScenesByID.put(id, scene);
        }
        return scene;
    }

    private RenderImage renderLayer(ImageOutputLayerID id, boolean drawFill, boolean drawEdges) throws IOException, ParserConfigurationException, SAXException {
        InputScene scene = this.getInputScene(id.getSceneID());
        scene.loadData();
        ImageOutput output = scene.getImageOutput(id.getImageLocalID());
        SceneLayer layer = scene.getLayer(output, id.getLayerID());
        if (output.getBlowupOfImageID() != null) {
            return this.renderBlowup(id);
        }
        this.fireImageRenderStarted(id);
        if (layer == null) {
            LOGGER.warn("No such layer image :" + id);
            return null;
        }
        assert (layer != null) : "Invalid layer ID: " + id.getLayerID();
        Rectangle4d solidImageRect = output.getSolidImageRect();
        Rectangle4d totalImageRect = output.getTotalImageRect();
        Dimension totalImageSize = new Dimension((int)totalImageRect.getWidth(), (int)totalImageRect.getHeight());
        double shadowBias = 0.1;
        int shadowSampleRadius = 2;
        Collection<PolyMesh3D> meshes = scene.getMeshes(output, layer);
        Camera camera = scene.getSceneGraph().getCamera(output.getCameraID());
        List<PolyMesh3D> preparedMeshes = camera.prepareForScanConversion(meshes, output.getTotalViewport(), totalImageSize, this.quality);
        Collection<PointLight> lights = scene.getSceneGraph().getLightsInCameraCoords(output.getCameraID()).values();
        Map<String, FillAppearance> fillAppearanceByMeshID = scene.getFillAppearanceByMeshID(output);
        Map<String, EdgeAppearance> edgeAppearanceByMeshID = scene.getEdgeAppearanceByMeshID(output);
        LOGGER.debug("Drawing shapes...");
        ArrayList<RenderObject> objects = new ArrayList<RenderObject>();
        for (PolyMesh3D mesh : preparedMeshes) {
            FillAppearance fillAppearance = fillAppearanceByMeshID.get(mesh.getIdentifier());
            EdgeAppearance edgeAppearance = edgeAppearanceByMeshID.get(mesh.getIdentifier());
            objects.add(new RenderObject(mesh, fillAppearance, edgeAppearance, this.quality));
        }
        ArrayList<DeepImage> images = new ArrayList<DeepImage>();
        int objectIndex = 0;
        for (RenderObject object : objects) {
            LOGGER.debug(" Drawing object \"" + object.getIdentifier() + "\"");
            this.fireObjectRenderStarted(object.getIdentifier(), objectIndex, objects.size());
            images.addAll(object.draw(lights, drawFill, drawEdges));
            this.fireObjectRenderComplete(object.getIdentifier(), objectIndex, objects.size());
            ++objectIndex;
        }
        WritableDeepImage composite = WritableDeepImage.composeImages(images, new WritableDeepImage(totalImageSize));
        RenderImage result = new RenderImage(id.getStringForm(), RenderResourceIO.getInstance().getLayerOutputDir(), composite.getImage(), composite.getHoleMap(), scene, output, layer.getID());
        if (REFERENCE_RECTANGLE_LOGGER.isDebugEnabled()) {
            result.drawReferenceRectangle();
        }
        this.fireImageRenderComplete(id);
        return result;
    }

    private RenderImage renderBlowup(ImageOutputLayerID id) throws IOException, ParserConfigurationException, SAXException {
        this.fireImageRenderStarted(id);
        InputScene scene = this.getInputScene(id.getSceneID());
        ImageOutput output = scene.getImageOutput(id.getImageLocalID());
        String blowupOfImageID = output.getBlowupOfImageID();
        ImageOutputID blowupImageID = new ImageOutputID(id.getSceneID(), blowupOfImageID);
        ImageOutput blowupImageOutput = scene.getImageOutput(blowupOfImageID);
        if (blowupImageOutput == null) {
            LOGGER.warn("Blowup image output not found: " + blowupImageOutput);
            return null;
        }
        RenderImage blowupRenderImage = this.getRenderImage(new ImageOutputLayerID(blowupImageID, id.getLayerID()), RenderCondition.NEVER);
        if (blowupRenderImage == null) {
            return null;
        }
        BufferedImage blowupImage = blowupRenderImage.getImage();
        if (blowupImage == null) {
            return null;
        }
        Rectangle4d destImageRect = output.getTotalImageRect();
        Rectangle4d littleImageRect = output.getTotalViewport();
        Rectangle4d bigImageRect = blowupImageOutput.getTotalViewport();
        littleImageRect = bigImageRect.toProportional(littleImageRect);
        Rectangle4d blowupRect = new Rectangle4d(0.0, 0.0, blowupImage.getWidth(), blowupImage.getHeight()).fromProportional(littleImageRect);
        BufferedImage blowupSubimage = blowupImage.getSubimage((int)blowupRect.getX(), (int)blowupRect.getY(), (int)blowupRect.getWidth(), (int)blowupRect.getHeight());
        blowupSubimage = ImageUtils.scale(blowupSubimage, (int)destImageRect.getWidth(), (int)destImageRect.getHeight());
        RenderImage result = new RenderImage(id.getStringForm(), RenderResourceIO.getInstance().getLayerOutputDir(), blowupSubimage, new HoleMap(), scene, output, id.getLayerID());
        this.fireImageRenderComplete(id);
        return result;
    }

    private RenderImage renderBackground(ImageOutputID id) throws ParserConfigurationException, SAXException, IOException {
        InputScene scene = this.getInputScene(id.getSceneID());
        scene.loadData();
        ImageOutput output = scene.getImageOutput(id.getImageLocalID());
        if (output == null) {
            LOGGER.warn("Missing image output: " + id);
            return null;
        }
        Background background = output.getProperties().getBackground();
        if (background == null) {
            return null;
        }
        Rectangle4d totalImageRect = output.getTotalImageRect();
        BufferedImage destImage = new BufferedImage((int)totalImageRect.getWidth(), (int)totalImageRect.getHeight(), 2);
        BufferedImage sourceImage = null;
        try {
            sourceImage = RenderResourceIO.getInstance().getInputImage(background.getFilename());
        }
        catch (IOException e) {
            LOGGER.warn("Failed to read background image: " + background.getFilename());
            return null;
        }
        Rectangle4d bgImageRect = new Rectangle4d(new Dimension(sourceImage.getWidth(), sourceImage.getHeight()));
        Rectangle destRect = new Rectangle(0, 0, (int)totalImageRect.getWidth(), (int)totalImageRect.getHeight());
        switch (background.getScaleMode()) {
            case NONE: {
                Graphics2D g = (Graphics2D)destImage.getGraphics();
                g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                g.setComposite(AlphaComposite.Src);
                g.drawImage((Image)sourceImage, 0, 0, null);
                g.dispose();
                break;
            }
            case FIT_CAMERA: {
                Rectangle4d sourceRect = bgImageRect.fromProportional(CAMERA_VIEWPORT.toProportional(output.getTotalViewport()));
                ImageUtils.drawImage(sourceImage, destImage, sourceRect.getBounds(), destRect);
                break;
            }
            case FIT_IMAGE: {
                ImageUtils.drawImage(sourceImage, destImage, bgImageRect.getBounds(), destRect);
            }
        }
        return new RenderImage(id.getStringForm(), RenderResourceIO.getInstance().getLayerOutputDir(), destImage, new HoleMap(), scene, output, null);
    }

    private void fireImageRenderStarted(ImageOutputLayerID layerID) {
        for (RenderProgressObserver observer : this.observers) {
            observer.imageRenderStarted(layerID);
        }
    }

    private void fireImageRenderStarted(ImageOutputID layerID) {
        for (RenderProgressObserver observer : this.observers) {
            observer.imageRenderStarted(layerID);
        }
    }

    private void fireImageRenderComplete(ImageOutputLayerID layerID) {
        for (RenderProgressObserver observer : this.observers) {
            observer.imageRenderComplete(layerID);
        }
    }

    private void fireImageRenderComplete(ImageOutputID layerID) {
        for (RenderProgressObserver observer : this.observers) {
            observer.imageRenderComplete(layerID);
        }
    }

    private void fireObjectRenderStarted(String objectID, int objectIndex, int totalObjectCount) {
        for (RenderProgressObserver observer : this.observers) {
            observer.objectRenderStarted(objectID, objectIndex, totalObjectCount);
        }
    }

    private void fireObjectRenderComplete(String objectID, int objectIndex, int totalObjectCount) {
        for (RenderProgressObserver observer : this.observers) {
            observer.objectRenderComplete(objectID, objectIndex, totalObjectCount);
        }
    }

    static {
        LOGGER = Logger.getLogger(RenderControl.class);
        REFERENCE_RECTANGLE_LOGGER = Logger.getLogger(RenderControl.class.getCanonicalName() + "|refRect");
        TIMESTAMPED_IMAGE_LOGGER = Logger.getLogger(RenderControl.class.getCanonicalName() + "|timestampedImage");
        ID_COUNTER = 0;
    }

    public static enum RenderCondition {
        ALWAYS,
        NEVER,
        IF_NOT_CURRENT;

    }
}

