/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.render.control;

import com.sodiumarc.patchwork.render.BoundingBox3D;
import com.sodiumarc.patchwork.render.mesh.PolyMesh3D;
import com.sodiumarc.patchwork.util.NegatableRegex;
import com.sodiumarc.patchwork.util.xml.DocumentNodeDecoder;
import com.sodiumarc.patchwork.util.xml.XMLUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Point3d;
import org.w3c.dom.Node;

public class MeshSubstitution {
    public static String ELEMENT_NAME = "substitution";
    public static String RENDER_PATTERN_ATTR_NAME = "render_pattern";
    public static String LOGICAL_PATTERN_ATTR_NAME = "logical_pattern";
    public static String HIDE_UNMATCHED_ATTR_NAME = "hide_unmatched";
    public static DocumentNodeDecoder<MeshSubstitution> DECODER = new DocumentNodeDecoder<MeshSubstitution>(){

        @Override
        public MeshSubstitution decode(Node node) {
            assert (node != null) : "Null node";
            if (!node.getLocalName().equals(ELEMENT_NAME)) {
                return null;
            }
            Map<String, String> attributes = XMLUtils.getAttributes(node);
            String renderPattern = attributes.get(RENDER_PATTERN_ATTR_NAME);
            String logicalPattern = attributes.get(LOGICAL_PATTERN_ATTR_NAME);
            boolean hideUnmatched = Boolean.valueOf(HIDE_UNMATCHED_ATTR_NAME);
            return new MeshSubstitution(renderPattern, logicalPattern, hideUnmatched);
        }
    };
    private final NegatableRegex renderPattern;
    private final NegatableRegex logicalPattern;
    private final boolean hideUnmatched;
    private final Map<String, String> substitutionTable;

    public MeshSubstitution(String renderPattern, String logicalPattern, boolean hideUnmatched) {
        this.renderPattern = new NegatableRegex(renderPattern, false);
        this.logicalPattern = new NegatableRegex(logicalPattern, false);
        this.hideUnmatched = hideUnmatched;
        this.substitutionTable = new HashMap<String, String>();
    }

    public Map<String, String> initSubstitutionTable(Collection<PolyMesh3D> meshes, double maxMatchDistance) {
        this.substitutionTable.clear();
        Collection<PolyMesh3D> logicalMeshes = this.getMatchingMeshes(meshes, this.logicalPattern);
        Collection<PolyMesh3D> renderMeshes = this.getMatchingMeshes(meshes, this.renderPattern);
        for (PolyMesh3D renderMesh : renderMeshes) {
            BoundingBox3D renderBounds = renderMesh.getBoundingBox();
            double closestMatchDistance = Double.POSITIVE_INFINITY;
            PolyMesh3D closestMatchMesh = null;
            for (PolyMesh3D logicalMesh : logicalMeshes) {
                BoundingBox3D inputBounds = logicalMesh.getBoundingBox();
                double matchDistance = this.getMatchDistance(renderBounds, inputBounds);
                if (!(matchDistance < maxMatchDistance) || !(matchDistance < closestMatchDistance)) continue;
                closestMatchDistance = matchDistance;
                closestMatchMesh = logicalMesh;
            }
            if (closestMatchMesh == null) continue;
            this.substitutionTable.put(closestMatchMesh.getIdentifier(), renderMesh.getIdentifier());
        }
        return this.substitutionTable;
    }

    public Map<String, String> getSubstitutionTable() {
        return this.substitutionTable;
    }

    public Set<String> getMatchedIDs() {
        HashSet<String> result = new HashSet<String>();
        result.addAll(this.substitutionTable.keySet());
        result.addAll(this.substitutionTable.values());
        return result;
    }

    public String substitute(String id) {
        if (this.substitutionTable.containsKey(id)) {
            return this.substitutionTable.get(id);
        }
        return id;
    }

    public Set<String> substitute(Set<String> meshIDs) {
        HashSet<String> result = new HashSet<String>();
        for (String id : meshIDs) {
            result.add(this.substitute(id));
        }
        return result;
    }

    public boolean isHideUnmatched() {
        return this.hideUnmatched;
    }

    private Collection<PolyMesh3D> getMatchingMeshes(Collection<PolyMesh3D> meshes, NegatableRegex pattern) {
        ArrayList<PolyMesh3D> result = new ArrayList<PolyMesh3D>(meshes.size());
        for (PolyMesh3D mesh : meshes) {
            if (!pattern.matches(mesh.getIdentifier())) continue;
            result.add(mesh);
        }
        return result;
    }

    private double getMatchDistance(BoundingBox3D bounds0, BoundingBox3D bounds1) {
        Point3d point0 = new Point3d();
        Point3d point1 = new Point3d();
        bounds0.getLower(point0);
        bounds1.getLower(point1);
        double lowerDist = point0.distance(point1);
        bounds0.getUpper(point0);
        bounds1.getUpper(point1);
        double upperDist = point0.distance(point1);
        return Math.max(lowerDist, upperDist);
    }
}

