/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.render.control;

import com.sodiumarc.patchwork.generate.GameConfig;
import com.sodiumarc.patchwork.sketch.SketchFiller;
import com.sodiumarc.patchwork.sketch.Splotcher;
import com.sodiumarc.patchwork.util.ColorComponent;
import com.sodiumarc.patchwork.util.ColorUtils;
import com.sodiumarc.patchwork.util.image.ImageFilter;
import com.sodiumarc.patchwork.util.image.ImageUtils;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Properties;

public enum KnownImageFilter {
    SPLOTCH("Splotch Effect"){

        @Override
        public ImageFilter getInstance() {
            try {
                return Splotcher.getDefaultInstance();
            }
            catch (IOException e) {
                return null;
            }
        }
    }
    ,
    SKETCH("Sketch Effect"){

        @Override
        public ImageFilter getInstance() {
            try {
                return SketchFiller.getDefaultInstance();
            }
            catch (IOException e) {
                return null;
            }
        }
    }
    ,
    SOLID_FILL("Solid Fill"){

        @Override
        public ImageFilter getInstance() {
            return new ImageFilter(){

                @Override
                public BufferedImage apply(BufferedImage input, Properties properties) {
                    if (properties == null) {
                        properties = new Properties();
                    }
                    int intRGB = Integer.decode(GameConfig.interpretRGBConstant(properties.getProperty("hexRGB", "#ffffff")));
                    int alpha = Integer.decode(properties.getProperty("hexAlpha", "#ff"));
                    int intARGB = ColorUtils.setComponent(intRGB, ColorComponent.ALPHA, alpha);
                    ImageUtils.fill(input, ColorUtils.toColor(intARGB));
                    return input;
                }
            };
        }
    }
    ,
    ALPHA_MASK("Apha Mask"){

        @Override
        public ImageFilter getInstance() {
            return new ImageFilter(){

                @Override
                public BufferedImage apply(BufferedImage input, Properties properties) {
                    if (properties == null) {
                        properties = new Properties();
                    }
                    int minIntensity = Integer.decode(properties.getProperty("hexMinIntesity", "#ff"));
                    int maxIntensity = Integer.decode(properties.getProperty("hexMaxIntesity", "#00"));
                    ImageUtils.intensityToAlpha(input, minIntensity, maxIntensity);
                    return input;
                }
            };
        }
    };

    private final String displayName;

    public abstract ImageFilter getInstance();

    public String toString() {
        return this.displayName;
    }

    private KnownImageFilter(String displayName) {
        this.displayName = displayName;
    }
}

