/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.render.control;

import com.sodiumarc.patchwork.FileUtils;

public class InputSceneID
implements Comparable<InputSceneID> {
    private final String stringForm;

    public InputSceneID(String filename, String sceneLocalID) {
        String idBase = FileUtils.getFilenameWithoutExtension(filename);
        this.stringForm = sceneLocalID == null ? idBase : idBase + "_" + sceneLocalID;
    }

    public InputSceneID(String stringForm) {
        this.stringForm = stringForm;
    }

    public String getFilename() {
        String[] idParts = this.stringForm.split("_");
        return FileUtils.addExtension(idParts[0], "xml");
    }

    public String getSceneLocalID() {
        String[] idParts = this.stringForm.split("_");
        if (idParts.length < 2) {
            return null;
        }
        return idParts[1];
    }

    public String getStringForm() {
        return this.stringForm;
    }

    @Override
    public int compareTo(InputSceneID o) {
        return this.stringForm.compareTo(o.stringForm);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.stringForm == null ? 0 : this.stringForm.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InputSceneID other = (InputSceneID)obj;
        return !(this.stringForm == null ? other.stringForm != null : !this.stringForm.equals(other.stringForm));
    }

    public String toString() {
        return this.getStringForm();
    }
}

