/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.render.control;

import com.sodiumarc.patchwork.render.control.ImageOutputID;
import com.sodiumarc.patchwork.render.control.InputSceneID;
import java.text.DecimalFormat;

public class ImageOutputLayerID
implements Comparable<ImageOutputLayerID> {
    public static final String SUFFIX_DELIMITER = "_L";
    public static final String FRAME_DELIMITER = "_F";
    private final ImageOutputID imageOutputID;
    private final String layerID;
    private final long frameTime;

    public static boolean isWellFormedID(String stringForm) {
        return ImageOutputLayerID.getLayerSuffix(stringForm) != null && ImageOutputLayerID.getImageOutputID(stringForm) != null;
    }

    public static String getLayerSuffix(String stringForm) {
        if (stringForm == null || stringForm.isEmpty()) {
            return null;
        }
        int splitIndex = stringForm.lastIndexOf(SUFFIX_DELIMITER);
        if (splitIndex == -1) {
            return null;
        }
        return stringForm.substring(splitIndex + 2);
    }

    public static String getLayerID(String stringForm) {
        String suffix = ImageOutputLayerID.getLayerSuffix(stringForm);
        String[] suffixParts = suffix.split(FRAME_DELIMITER);
        return suffixParts[0];
    }

    public static long getFrameTime(String stringForm) {
        String suffix = ImageOutputLayerID.getLayerSuffix(stringForm);
        String[] suffixParts = suffix.split(FRAME_DELIMITER);
        if (suffixParts.length < 2) {
            return -1L;
        }
        return Long.valueOf(suffixParts[1]);
    }

    public static String getImageOutputID(String stringForm) {
        if (stringForm == null || stringForm.isEmpty()) {
            return null;
        }
        int splitIndex = stringForm.lastIndexOf(SUFFIX_DELIMITER);
        if (splitIndex == -1) {
            return null;
        }
        return stringForm.substring(0, splitIndex);
    }

    public ImageOutputLayerID(ImageOutputID imageOutputID, String layerID) {
        this(imageOutputID, layerID, -1L);
    }

    public ImageOutputLayerID(ImageOutputID imageOutputID, String layerID, long frameTime) {
        this.imageOutputID = imageOutputID;
        this.layerID = layerID;
        this.frameTime = frameTime;
    }

    public ImageOutputLayerID(String stringForm) {
        this.imageOutputID = new ImageOutputID(ImageOutputLayerID.getImageOutputID(stringForm));
        this.layerID = ImageOutputLayerID.getLayerID(stringForm);
        this.frameTime = ImageOutputLayerID.getFrameTime(stringForm);
    }

    public ImageOutputID getImageOutputID() {
        return this.imageOutputID;
    }

    public String getLayerID() {
        return this.layerID;
    }

    public String getStringForm() {
        String noFrame = this.imageOutputID.getStringForm() + SUFFIX_DELIMITER + this.layerID;
        long frameTime = this.getFrameTime();
        if (frameTime < 0L) {
            return noFrame;
        }
        DecimalFormat formatter = new DecimalFormat("00000");
        return noFrame + FRAME_DELIMITER + formatter.format(frameTime);
    }

    public InputSceneID getSceneID() {
        return this.imageOutputID.getSceneID();
    }

    public String getImageLocalID() {
        return this.imageOutputID.getImageLocalID();
    }

    public long getFrameTime() {
        return this.frameTime;
    }

    @Override
    public int compareTo(ImageOutputLayerID o) {
        return this.getStringForm().compareTo(o.getStringForm());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.frameTime ^ this.frameTime >>> 32);
        result = 31 * result + (this.imageOutputID == null ? 0 : this.imageOutputID.hashCode());
        result = 31 * result + (this.layerID == null ? 0 : this.layerID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImageOutputLayerID other = (ImageOutputLayerID)obj;
        if (this.frameTime != other.frameTime) {
            return false;
        }
        if (this.imageOutputID == null ? other.imageOutputID != null : !this.imageOutputID.equals(other.imageOutputID)) {
            return false;
        }
        return !(this.layerID == null ? other.layerID != null : !this.layerID.equals(other.layerID));
    }

    public String toString() {
        return this.getStringForm();
    }
}

