/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.render.control;

import com.sodiumarc.patchwork.render.control.ImageOutput;
import com.sodiumarc.patchwork.render.control.InputScene;
import com.sodiumarc.patchwork.render.mesh.PolyMesh3D;
import com.sodiumarc.patchwork.render.scenegraph.Camera;
import com.sodiumarc.patchwork.util.xml.DocumentNodeDecoder;
import com.sodiumarc.patchwork.util.xml.XMLUtils;
import java.awt.Rectangle;
import java.util.Map;
import org.w3c.dom.Node;

public class CrossCameraMap {
    public static String ELEMENT_NAME = "cross_cam_map";
    public static String SRC_ID_ATTR_NAME = "src_id";
    public static String DEST_ID_ATTR_NAME = "dest_id";
    public static String MESH_ID_ATTR_NAME = "mesh_id";
    public static DocumentNodeDecoder<CrossCameraMap> DECODER = new DocumentNodeDecoder<CrossCameraMap>(){

        @Override
        public CrossCameraMap decode(Node node) {
            assert (node != null) : "Null node";
            if (!node.getLocalName().equals(ELEMENT_NAME)) {
                return null;
            }
            Map<String, String> attributes = XMLUtils.getAttributes(node);
            return new CrossCameraMap(attributes.get(SRC_ID_ATTR_NAME), attributes.get(DEST_ID_ATTR_NAME), attributes.get(MESH_ID_ATTR_NAME));
        }
    };
    private final String srcImageOutputID;
    private final String destImageOutputID;
    private final String meshID;

    public CrossCameraMap(String srcCameraID, String destCameraID, String meshID) {
        this.srcImageOutputID = srcCameraID;
        this.destImageOutputID = destCameraID;
        this.meshID = meshID;
    }

    public Rectangle getBounds(InputScene scene) {
        ImageOutput srcOutput = scene.getImageOutput(this.srcImageOutputID);
        Camera srcCamera = scene.getSceneGraph().getCamera(srcOutput.getCameraID());
        PolyMesh3D srcFrameMesh = scene.getFrameMesh(srcOutput);
        ImageOutput destOutput = scene.getImageOutput(this.destImageOutputID);
        PolyMesh3D destFrameMesh = scene.getFrameMesh(srcOutput);
        return null;
    }
}

