/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.render.control;

import com.sodiumarc.patchwork.render.BoundingBox3D;
import com.sodiumarc.patchwork.render.mesh.PolyMesh3D;
import com.sodiumarc.patchwork.render.scenegraph.Camera;
import com.sodiumarc.patchwork.render.scenegraph.SceneGraph;
import com.sodiumarc.patchwork.render.scenegraph.SceneGraphNode;
import com.sodiumarc.patchwork.render.scenegraph.Transform3D;
import com.sodiumarc.patchwork.util.Collection.CollectionUtils;
import com.sodiumarc.patchwork.util.StringUtils;
import com.sodiumarc.patchwork.util.VectorUtils;
import com.sodiumarc.patchwork.util.xml.DocumentNodeDecoder;
import com.sodiumarc.patchwork.util.xml.XMLUtils;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public class CameraInterpolator {
    public static final String ELEMENT_NAME = "interp_cameras";
    public static final String FROM_CAMERA_ID = "from_camera_id";
    public static final String TO_CAMERA_ID = "to_camera_id";
    public static final String FROM_FRAME_ID = "from_frame_id";
    public static final String TO_FRAME_ID = "to_frame_id";
    public static final String STEPS_ATTR_NAME = "steps";
    public static final String FRACTIONS_ATTR_NAME = "fractions";
    public static final String ID_PREFIX_ATTR_NAME = "id_prefix";
    public static DocumentNodeDecoder<CameraInterpolator> DECODER = new DocumentNodeDecoder<CameraInterpolator>(){

        @Override
        public CameraInterpolator decode(Node node) {
            assert (node != null) : "Null node";
            if (!node.getLocalName().equals(CameraInterpolator.ELEMENT_NAME)) {
                return null;
            }
            Map<String, String> attributes = XMLUtils.getAttributes(node);
            String fractionsStr = attributes.get(CameraInterpolator.FRACTIONS_ATTR_NAME);
            if (fractionsStr != null) {
                double[] fractions = StringUtils.decodeDoubleArray(fractionsStr);
                return new CameraInterpolator(attributes.get(CameraInterpolator.FROM_CAMERA_ID), attributes.get(CameraInterpolator.TO_CAMERA_ID), attributes.get(CameraInterpolator.FROM_FRAME_ID), attributes.get(CameraInterpolator.TO_FRAME_ID), fractions, attributes.get(CameraInterpolator.ID_PREFIX_ATTR_NAME));
            }
            String stepsStr = attributes.get(CameraInterpolator.STEPS_ATTR_NAME);
            int steps = stepsStr == null ? 1 : Integer.valueOf(stepsStr);
            return new CameraInterpolator(attributes.get(CameraInterpolator.FROM_CAMERA_ID), attributes.get(CameraInterpolator.TO_CAMERA_ID), attributes.get(CameraInterpolator.FROM_FRAME_ID), attributes.get(CameraInterpolator.TO_FRAME_ID), steps, attributes.get(CameraInterpolator.ID_PREFIX_ATTR_NAME));
        }
    };
    private final String fromCameraID;
    private final String toCameraID;
    private final String fromFrameID;
    private final String toFrameID;
    private final String idPrefix;
    private final double[] interpFractions;
    private static final Logger LOGGER = Logger.getLogger(CameraInterpolator.class);

    public CameraInterpolator(String fromCameraID, String toCameraID, String fromFrameID, String toFrameID, int steps, String idPrefix) {
        this.fromCameraID = fromCameraID;
        this.toCameraID = toCameraID;
        this.fromFrameID = fromFrameID;
        this.toFrameID = toFrameID;
        this.idPrefix = idPrefix;
        this.interpFractions = new double[steps];
        double stepSize = 1.0 / (double)(steps + 1);
        for (int i = 0; i < steps; ++i) {
            this.interpFractions[i] = (double)(i + 1) * stepSize;
        }
    }

    public CameraInterpolator(String fromCameraID, String toCameraID, String fromFrameID, String toFrameID, double[] interpFractions, String namePattern) {
        this.fromCameraID = fromCameraID;
        this.toCameraID = toCameraID;
        this.fromFrameID = fromFrameID;
        this.toFrameID = toFrameID;
        this.idPrefix = namePattern;
        this.interpFractions = interpFractions;
    }

    public void addCameras(SceneGraph sceneGraph) {
        Camera fromCamera = sceneGraph.getCamera(this.fromCameraID);
        Camera toCamera = sceneGraph.getCamera(this.toCameraID);
        assert (fromCamera != null) : "Camera not found: " + this.fromCameraID;
        assert (toCamera != null) : "Camera not found: " + this.toCameraID;
        LOGGER.debug("Generating cameras between " + fromCamera.getGlobalPosition() + " and " + toCamera.getGlobalPosition());
        Transform3D fromTransform = fromCamera.getCumulativeTransform();
        Vector3d deltaVector = new Vector3d(toCamera.getGlobalPosition());
        deltaVector.sub(fromCamera.getGlobalPosition());
        DecimalFormat formatter = new DecimalFormat("000");
        Vector3d translation = new Vector3d();
        for (int i = 0; i < this.interpFractions.length; ++i) {
            translation.set(deltaVector);
            translation.scale(this.interpFractions[i]);
            String cameraID = "CAM" + this.idPrefix + formatter.format(i);
            if (sceneGraph.cameraExists(cameraID)) {
                Logger.getLogger(this.getClass()).warn("Camera already exists: " + cameraID);
                continue;
            }
            Transform3D cumulativeTransform = new Transform3D();
            cumulativeTransform.setTranslation(translation);
            cumulativeTransform.mul(fromTransform);
            Camera interpCam = new Camera(cameraID);
            SceneGraphNode cameraParentNode = new SceneGraphNode(cameraID, cumulativeTransform, interpCam);
            sceneGraph.getRoot().addChild(cameraParentNode);
            String frameMeshID = cameraID + ";" + "FRAME" + "_" + cameraID;
            PolyMesh3D interpFrameMesh = this.getInterpolatedFrameMesh(sceneGraph, frameMeshID, fromCamera, this.fromFrameID, toCamera, this.toFrameID, this.interpFractions[i]);
            if (interpFrameMesh != null) {
                SceneGraphNode frameParentNode = new SceneGraphNode(frameMeshID, null, interpFrameMesh);
                cameraParentNode.addChild(frameParentNode);
            }
            LOGGER.debug("Generated camera at " + interpCam.getGlobalPosition());
        }
    }

    private PolyMesh3D getInterpolatedFrameMesh(SceneGraph sceneGraph, String interpMeshID, Camera fromCamera, String fromFrameID, Camera toCamera, String toFrameID, double fraction) {
        PolyMesh3D fromFrameMesh = this.getFrameInCameraCoords(sceneGraph, fromCamera, fromFrameID);
        PolyMesh3D toFrameMesh = this.getFrameInCameraCoords(sceneGraph, toCamera, toFrameID);
        if (fromFrameMesh == null || toFrameMesh == null) {
            LOGGER.warn("Failed to interpolate frame mesh.");
            return null;
        }
        BoundingBox3D fromBox = fromFrameMesh.getBoundingBox();
        Point3d fromLower = new Point3d();
        Point3d fromUpper = new Point3d();
        fromBox.getLower(fromLower);
        fromBox.getUpper(fromUpper);
        BoundingBox3D toBox = toFrameMesh.getBoundingBox();
        Point3d toLower = new Point3d();
        Point3d toUpper = new Point3d();
        toBox.getLower(toLower);
        toBox.getUpper(toUpper);
        Point3d interpLower = new Point3d();
        Point3d interpUpper = new Point3d();
        VectorUtils.getLinePoint(fromLower, toLower, fraction, interpLower);
        VectorUtils.getLinePoint(fromUpper, toUpper, fraction, interpUpper);
        ArrayList<Point3d> vertices = new ArrayList<Point3d>();
        vertices.add(new Point3d(interpLower.x, interpLower.y, interpLower.z));
        vertices.add(new Point3d(interpLower.x, interpUpper.y, interpLower.z));
        vertices.add(new Point3d(interpUpper.x, interpUpper.y, interpLower.z));
        vertices.add(new Point3d(interpUpper.x, interpLower.y, interpLower.z));
        PolyMesh3D interpolatedMesh = new PolyMesh3D(interpMeshID, vertices);
        interpolatedMesh.addPolygonIndexed(Arrays.asList(0, 1, 2, 3), null, null, null, -1);
        return interpolatedMesh;
    }

    private PolyMesh3D getFrameInCameraCoords(SceneGraph sceneGraph, Camera camera, String frameID) {
        String framePattern = frameID != null ? camera.getId() + ";" + frameID : camera.getId() + ";" + "FRAME" + ".*";
        Set<PolyMesh3D> frameMeshes = camera.getDescendantMeshesMatching(framePattern);
        if (frameMeshes.size() != 1) {
            LOGGER.warn("Expected 1 frame mesh for camera \"" + camera.getId() + "\", found " + frameMeshes.size());
            return null;
        }
        String meshID = CollectionUtils.first(frameMeshes).getIdentifier();
        return sceneGraph.getMeshInCameraCoords(meshID, camera.getId());
    }
}

