/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.render.control;

import com.sodiumarc.patchwork.util.xml.DocumentNodeDecoder;
import com.sodiumarc.patchwork.util.xml.XMLUtils;
import java.util.Map;
import org.w3c.dom.Node;

public class Background {
    public static final String ELEMENT_NAME = "background";
    public static final String FILENAME_ATTR_NAME = "filename";
    public static final String SCALE_MODE_ATTR_NAME = "scale_mode";
    public static DocumentNodeDecoder<Background> DECODER = new DocumentNodeDecoder<Background>(){

        @Override
        public Background decode(Node node) {
            assert (node != null) : "Null node";
            if (!node.getLocalName().equals(Background.ELEMENT_NAME)) {
                return null;
            }
            Map<String, String> attributes = XMLUtils.getAttributes(node);
            return new Background(attributes.get(Background.FILENAME_ATTR_NAME), ScaleMode.valueOf(attributes.get(Background.SCALE_MODE_ATTR_NAME).toUpperCase()));
        }
    };
    private final String filename;
    private final ScaleMode scaleMode;

    public Background(String filename, ScaleMode scaleMode) {
        this.filename = filename;
        this.scaleMode = scaleMode;
    }

    public String getFilename() {
        return this.filename;
    }

    public ScaleMode getScaleMode() {
        return this.scaleMode;
    }

    public static enum ScaleMode {
        NONE,
        FIT_CAMERA,
        FIT_IMAGE;

    }
}

