/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.render;

import com.sodiumarc.patchwork.render.DefaultEdgeRenderer;
import com.sodiumarc.patchwork.render.LineStyle;
import com.sodiumarc.patchwork.render.RenderResourceIO;
import com.sodiumarc.patchwork.render.WritableDeepImage;
import com.sodiumarc.patchwork.render.mesh.Path;
import com.sodiumarc.patchwork.render.mesh.PolyMesh3D;
import com.sodiumarc.patchwork.render.scanconverter.ScanConverter;
import com.sodiumarc.patchwork.sketch.SketchAsset;
import com.sodiumarc.patchwork.util.Collection.Pair;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

public class SketchEdgeRenderer
extends DefaultEdgeRenderer {
    public static final int CLIP_REGION_WIDTH = 10;
    public static final int MITRE_LIMIT = 1;
    private final Map<Pair<Float, Float>, SketchAsset> _assetCache = new HashMap<Pair<Float, Float>, SketchAsset>();
    private final BufferedImage _lineImage = RenderResourceIO.getInstance().getInputImage("lines/pencil_line_small.jpg");
    private static SketchEdgeRenderer DEFAULT_INSTANCE;
    private static float BASE_SCALE;
    private static float BASE_ALPHA;
    private static final ScanConverter SCAN_CONVERTER;

    public static SketchEdgeRenderer getDefaultInstance() throws IOException {
        if (DEFAULT_INSTANCE == null) {
            DEFAULT_INSTANCE = new SketchEdgeRenderer();
        }
        return DEFAULT_INSTANCE;
    }

    public void drawPaths(WritableDeepImage destination, List<Path> paths, LineStyle style) {
        for (Path path : paths) {
            this.drawPath(destination, path.detach(), style);
        }
    }

    public void drawPath(WritableDeepImage destination, Path path, LineStyle style) {
        if (style == null) {
            style = LineStyle.DEFAULT_BLACK;
        }
        Point offset = destination.getOffset();
        WritableDeepImage pathDeepImage = new WritableDeepImage(destination.getBounds());
        BufferedImage pathImage = new BufferedImage(destination.getWidth(), destination.getHeight(), 2);
        Graphics2D graphics = (Graphics2D)pathImage.getGraphics();
        PolyMesh3D pathMesh = this.drawPath(graphics, offset, path, style);
        graphics.dispose();
        SCAN_CONVERTER.scanConvert(Collections.singleton(pathMesh), null, pathDeepImage);
        graphics = (Graphics2D)pathDeepImage.getImage().getGraphics();
        graphics.setComposite(AlphaComposite.Src);
        graphics.drawImage((Image)pathImage, 0, 0, null);
        graphics.dispose();
        destination.compositeImage(pathDeepImage, 1, true);
    }

    @Override
    public void drawPath(Graphics2D graphics, Path path, LineStyle style) {
        if (style == null) {
            style = LineStyle.DEFAULT_BLACK;
        }
        SketchAsset lineSketch = this.getLineImage(style.getWidth(), 1.0f);
        BufferedImage lineImage = this.createExtendedLine(lineSketch, 3, style.getColor());
        graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        AffineTransform transform = new AffineTransform();
        double totalOuterLength = 0.0;
        for (int i = 0; i < path.getVertexCount() - 1; ++i) {
            graphics.setClip(this.getEdgeClippingPath(path, i, 10.0));
            Point3d vertex0 = path.getVertex(i);
            Point3d vertex1 = path.getVertex(i + 1);
            double pathSegmentLength = Math.sqrt(Math.pow(vertex1.x - vertex0.x, 2.0) + Math.pow(vertex1.y - vertex0.y, 2.0));
            double lineImageRemaining = (double)lineImage.getHeight() - totalOuterLength;
            if (lineImageRemaining < pathSegmentLength) {
                totalOuterLength = 10.0;
            }
            transform.setToIdentity();
            transform.translate(vertex0.getX(), vertex0.getY());
            transform.rotate(this.getEdgeAngle(vertex0, vertex1));
            transform.translate(-lineImage.getWidth() / 2, -totalOuterLength);
            graphics.drawImage(lineImage, transform, null);
            graphics.setClip(null);
            totalOuterLength += pathSegmentLength;
        }
    }

    private PolyMesh3D drawPath(Graphics2D graphics, Point offset, Path path, LineStyle style) {
        PolyMesh3D pathMesh = new PolyMesh3D("depth", path.getVertices(), null);
        graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        graphics.translate(-offset.x, -offset.y);
        SketchAsset lineSketch = this.getLineImage(style.getWidth(), 1.0f);
        BufferedImage lineImage = this.createExtendedLine(lineSketch, 3, style.getColor());
        AffineTransform transform = new AffineTransform();
        double totalOuterLength = 0.0;
        for (int i = 0; i < path.getVertexCount() - 1; ++i) {
            Path clipPath = this.getEdgeClippingPath3D(path, i, 10.0);
            pathMesh.addPolygon(clipPath.getVertices(), null, null, null, null);
            graphics.setClip(clipPath.toPath2D());
            Point3d vertex0 = path.getVertex(i);
            Point3d vertex1 = path.getVertex(i + 1);
            double pathSegmentLength = Math.sqrt(Math.pow(vertex1.x - vertex0.x, 2.0) + Math.pow(vertex1.y - vertex0.y, 2.0));
            double lineImageRemaining = (double)lineImage.getHeight() - totalOuterLength;
            if (lineImageRemaining < pathSegmentLength) {
                totalOuterLength = 10.0;
            }
            transform.setToIdentity();
            transform.translate(vertex0.getX(), vertex0.getY());
            transform.rotate(this.getEdgeAngle(vertex0, vertex1));
            transform.translate(-lineImage.getWidth() / 2, -totalOuterLength);
            graphics.setColor(Color.BLACK);
            graphics.drawLine((int)vertex0.x, (int)vertex0.y, (int)vertex1.x, (int)vertex1.y);
            totalOuterLength += pathSegmentLength;
        }
        graphics.dispose();
        return pathMesh;
    }

    private BufferedImage createExtendedLine(SketchAsset line, int multiplier, Color color) {
        BufferedImage lineImage = line.makeSplotchImage(color);
        BufferedImage doubleLengthImage = new BufferedImage(lineImage.getWidth(), lineImage.getHeight() * multiplier, 2);
        Graphics2D graphics = (Graphics2D)doubleLengthImage.getGraphics();
        AffineTransform transform = new AffineTransform();
        for (int i = 0; i < multiplier; ++i) {
            transform.setToIdentity();
            transform.translate(0.0, i * lineImage.getHeight());
            graphics.drawImage(lineImage, transform, null);
        }
        graphics.dispose();
        return doubleLengthImage;
    }

    private double getEdgeAngle(Point3d vertex0, Point3d vertex1) {
        double x0 = vertex0.getX();
        double y0 = vertex0.getY();
        double x1 = vertex1.getX();
        double y1 = vertex1.getY();
        double edgeDeltaX = x1 - x0;
        double edgeDeltaY = y1 - y0;
        double theta = edgeDeltaY == 0.0 ? (edgeDeltaX > 0.0 ? 4.71238898038469 : 1.5707963267948966) : (edgeDeltaY < 0.0 ? Math.PI - Math.atan(edgeDeltaX / edgeDeltaY) : (edgeDeltaX > 0.0 ? Math.PI * 2 - Math.atan(edgeDeltaX / edgeDeltaY) : -Math.atan(edgeDeltaX / edgeDeltaY)));
        return theta;
    }

    private Point2D.Double getRightMitrePoint(Path path, int cornerIndex, double width, boolean preceding) {
        Point3d vertex0 = cornerIndex > 0 ? path.getVertex(cornerIndex - 1) : null;
        Point3d corner = path.getVertex(cornerIndex);
        Point3d vertex1 = cornerIndex < path.getVertexCount() - 1 ? path.getVertex(cornerIndex + 1) : null;
        double theta = 0.0;
        double seamRadius = width;
        if (vertex0 != null && vertex1 != null) {
            double theta0 = this.getEdgeAngle(vertex0, corner);
            double theta1 = this.getEdgeAngle(corner, vertex1);
            if (this.shouldMitre(path, cornerIndex)) {
                theta = (theta0 + theta1) / 2.0;
                double delTheta = Math.abs(theta - theta0);
                seamRadius = width / Math.cos(delTheta);
            } else {
                theta = preceding ? theta0 : theta1;
            }
        } else if (vertex0 != null) {
            theta = this.getEdgeAngle(vertex0, corner);
        } else if (vertex1 != null) {
            theta = this.getEdgeAngle(corner, vertex1);
        }
        Point2D.Double result = new Point2D.Double(seamRadius, 0.0);
        AffineTransform transform = new AffineTransform();
        transform.rotate(theta);
        transform.transform(result, result);
        return result;
    }

    private Vector3d getRightMitreVector(Path path, int cornerIndex, double width, boolean preceding) {
        Point3d vertex0 = cornerIndex > 0 ? path.getVertex(cornerIndex - 1) : null;
        Point3d corner = path.getVertex(cornerIndex);
        Point3d vertex1 = cornerIndex < path.getVertexCount() - 1 ? path.getVertex(cornerIndex + 1) : null;
        double theta = 0.0;
        double seamRadius = width;
        if (vertex0 != null && vertex1 != null) {
            double theta0 = this.getEdgeAngle(vertex0, corner);
            double theta1 = this.getEdgeAngle(corner, vertex1);
            if (this.shouldMitre(path, cornerIndex)) {
                theta = (theta0 + theta1) / 2.0;
                double delTheta = Math.abs(theta - theta0);
                seamRadius = width / Math.cos(delTheta);
            } else {
                theta = preceding ? theta0 : theta1;
            }
        } else if (vertex0 != null) {
            theta = this.getEdgeAngle(vertex0, corner);
        } else if (vertex1 != null) {
            theta = this.getEdgeAngle(corner, vertex1);
        }
        Point2D.Double point2D = new Point2D.Double(seamRadius, 0.0);
        AffineTransform transform = new AffineTransform();
        transform.rotate(theta);
        transform.transform(point2D, point2D);
        return new Vector3d(point2D.x, point2D.y, 0.0);
    }

    private boolean shouldMitre(Path path, int cornerIndex) {
        if (cornerIndex == 0 || cornerIndex == path.getVertexCount() - 1) {
            return false;
        }
        Point3d vertex0 = path.getVertex(cornerIndex - 1);
        Point3d corner = path.getVertex(cornerIndex);
        Point3d vertex1 = path.getVertex(cornerIndex + 1);
        double theta0 = this.getEdgeAngle(vertex0, corner);
        double theta1 = this.getEdgeAngle(corner, vertex1);
        double thetaB = Math.abs(theta1 - theta0);
        if (thetaB > Math.PI) {
            thetaB = Math.PI * 2 - thetaB;
        }
        return thetaB < 1.0;
    }

    private Path2D.Double getEdgeClippingPath(Path path, int edgeStartIndex, double width) {
        Point3d vertex0 = path.getVertex(edgeStartIndex);
        Point3d vertex1 = path.getVertex(edgeStartIndex + 1);
        double x0 = vertex0.getX();
        double y0 = vertex0.getY();
        double x1 = vertex1.getX();
        double y1 = vertex1.getY();
        Point2D.Double startMitre = this.getRightMitrePoint(path, edgeStartIndex, width, false);
        Point2D.Double endMitre = this.getRightMitrePoint(path, edgeStartIndex + 1, width, true);
        Path2D.Double clipPath = new Path2D.Double();
        clipPath.moveTo(x0 + startMitre.x, y0 + startMitre.y);
        clipPath.lineTo(x1 + endMitre.x, y1 + endMitre.y);
        clipPath.lineTo(x1 - endMitre.x, y1 - endMitre.y);
        clipPath.lineTo(x0 - startMitre.x, y0 - startMitre.y);
        clipPath.closePath();
        return clipPath;
    }

    private Path getEdgeClippingPath3D(Path path, int edgeStartIndex, double width) {
        Point3d vertex0 = path.getVertex(edgeStartIndex);
        Point3d vertex1 = path.getVertex(edgeStartIndex + 1);
        Vector3d startMitre = this.getRightMitreVector(path, edgeStartIndex, width, false);
        Vector3d endMitre = this.getRightMitreVector(path, edgeStartIndex + 1, width, true);
        ArrayList<Point3d> pathPoints = new ArrayList<Point3d>();
        Point3d point = new Point3d();
        point.add(vertex0, startMitre);
        pathPoints.add(point);
        point = new Point3d();
        point.add(vertex1, endMitre);
        pathPoints.add(point);
        point = new Point3d();
        point.sub(vertex1, endMitre);
        pathPoints.add(point);
        point = new Point3d();
        point.sub(vertex0, startMitre);
        pathPoints.add(point);
        Path result = new Path(pathPoints);
        result.setVertexIndices(0, 1, 2, 3);
        return result;
    }

    private SketchAsset getLineImage(float scale, float alpha) {
        Pair<Float, Float> key = new Pair<Float, Float>(Float.valueOf(scale *= BASE_SCALE), Float.valueOf(alpha *= BASE_ALPHA));
        SketchAsset lineAsset = this._assetCache.get(key);
        if (lineAsset == null) {
            lineAsset = new SketchAsset("line", this._lineImage, scale, alpha);
            this._assetCache.put(key, lineAsset);
        }
        return lineAsset;
    }

    static {
        BASE_SCALE = 0.6f;
        BASE_ALPHA = 0.8f;
        SCAN_CONVERTER = new ScanConverter();
    }
}

