/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.render;

import com.sodiumarc.patchwork.render.DeepImage;
import com.sodiumarc.patchwork.render.EdgeProcessor;
import com.sodiumarc.patchwork.render.EdgeRenderer;
import com.sodiumarc.patchwork.render.LineStyle;
import com.sodiumarc.patchwork.render.RenderQuality;
import com.sodiumarc.patchwork.render.RenderResourceIO;
import com.sodiumarc.patchwork.render.SketchEdgeRenderer;
import com.sodiumarc.patchwork.render.WritableDeepImage;
import com.sodiumarc.patchwork.render.control.EdgeAppearance;
import com.sodiumarc.patchwork.render.control.FillAppearance;
import com.sodiumarc.patchwork.render.mesh.Edge;
import com.sodiumarc.patchwork.render.mesh.Path;
import com.sodiumarc.patchwork.render.mesh.PolyMesh3D;
import com.sodiumarc.patchwork.render.mesh.Polygon3D;
import com.sodiumarc.patchwork.render.scanconverter.SCFeature;
import com.sodiumarc.patchwork.render.scanconverter.ScanConverter;
import com.sodiumarc.patchwork.render.scenegraph.CoordinateSystem;
import com.sodiumarc.patchwork.render.scenegraph.PointLight;
import com.sodiumarc.patchwork.util.Collection.CompoundIterable;
import com.sodiumarc.patchwork.util.ColorUtils;
import com.sodiumarc.patchwork.util.Filter;
import com.sodiumarc.patchwork.util.VectorUtils;
import com.sodiumarc.patchwork.util.image.ImageUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import javax.vecmath.Point3d;
import org.apache.log4j.Logger;

public class RenderShape {
    private final PolyMesh3D _mesh;
    private final EdgeProcessor _edgeProcessor;
    private final List<Path2D.Double> _internalBoundaryPaths2D;
    private final List<Path2D.Double> _externalBoundaryPaths2D;
    private final List<Path> _degeneratePaths;
    private final Rectangle _bounds;
    private final FillAppearance _fillAppearance;
    private final EdgeAppearance _edgeAppearance;
    private final String _identifier;
    private static final int BORDER = 10;
    private static final Logger LOGGER = Logger.getLogger(RenderShape.class);
    private static final Logger SCAN_CONVERTED_LOGGER = Logger.getLogger(RenderShape.class.getCanonicalName() + "|scanConverted");

    public RenderShape(PolyMesh3D mesh, String identifier, EdgeProcessor edgeProcessor, FillAppearance fillAppearance, EdgeAppearance edgeAppearance) throws IOException {
        assert (mesh != null);
        assert (identifier != null);
        this._identifier = identifier;
        this._mesh = mesh;
        if (edgeProcessor == null) {
            this._edgeProcessor = new EdgeProcessor();
            this._edgeProcessor.processEdges(Collections.singleton(mesh));
        } else {
            this._edgeProcessor = edgeProcessor;
        }
        this._fillAppearance = fillAppearance == null ? FillAppearance.DEFAULT_INSTANCE : fillAppearance;
        this._edgeAppearance = edgeAppearance == null ? EdgeAppearance.DEFAULT_INSTANCE : edgeAppearance;
        this._internalBoundaryPaths2D = new ArrayList<Path2D.Double>();
        this._externalBoundaryPaths2D = new ArrayList<Path2D.Double>();
        this._degeneratePaths = new ArrayList<Path>();
        this.getBoundaryPaths(new TotalBoundarySegmentFilter(this._identifier), this._internalBoundaryPaths2D, this._externalBoundaryPaths2D);
        this._bounds = this.getBounds(this._externalBoundaryPaths2D);
    }

    public boolean isDrawable() {
        return this._fillAppearance.isRendered() && this._bounds.width > 0 && this._bounds.height > 0;
    }

    public DeepImage draw(Collection<PointLight> lights, RenderQuality quality, boolean forceErase) {
        if (!this.isDrawable()) {
            return null;
        }
        boolean erase = forceErase || this._fillAppearance.isErase();
        boolean billboard = this._fillAppearance.isBillboard();
        WritableDeepImage scanConverted = new WritableDeepImage(this._bounds.width, this._bounds.height);
        Filter<Polygon3D> polyFilter = new Filter<Polygon3D>(){

            @Override
            public boolean accept(Polygon3D poly) {
                return RenderShape.this._identifier.equals(poly.getGroupIdentifier());
            }
        };
        scanConverted.setOffset(this._bounds.getLocation());
        EnumSet<SCFeature> features = EnumSet.noneOf(SCFeature.class);
        if (quality == RenderQuality.NICEST) {
            features.add(SCFeature.SHADOWS);
        }
        ScanConverter.getDefaultInstance().scanConvert(Collections.singleton(this._mesh), features, lights, polyFilter, scanConverted);
        scanConverted.setName(this.getIdentifier());
        BufferedImage interior = ImageUtils.fillExterior(scanConverted.getImage(), ColorUtils.CLEAR_COLOR, 0, 10);
        if (billboard || quality != RenderQuality.FASTEST) {
            interior = this._fillAppearance.applyFilters(interior, this._bounds.getLocation());
        }
        this.applyAlphaMask(interior, scanConverted, erase, billboard);
        if (SCAN_CONVERTED_LOGGER.isDebugEnabled()) {
            this.writeDebugImage(this.getIdentifier() + "_SC", scanConverted.getImage());
            this.writeDebugImage(this.getIdentifier() + "_SCD", scanConverted.createDepthImage());
        }
        if (erase) {
            Graphics2D graphics = scanConverted.getImage().createGraphics();
            graphics.setComposite(AlphaComposite.Clear);
            graphics.fillRect(0, 0, scanConverted.getWidth(), scanConverted.getHeight());
            graphics.dispose();
        }
        return scanConverted;
    }

    public DeepImage drawEdges() throws IOException {
        WritableDeepImage result = new WritableDeepImage(this._bounds.width + 20, this._bounds.height + 20);
        result.setOffset(new Point(this._bounds.x - 10, this._bounds.y - 10));
        SketchEdgeRenderer edgeRenderer = SketchEdgeRenderer.getDefaultInstance();
        ArrayList<Path> silhouettePaths = new ArrayList<Path>(this._edgeProcessor.getPaths(new VisibleBoundarySegmentFilter(this._identifier)));
        EdgeProcessor.EdgeSegmentFilter creaseFilter = new EdgeProcessor.EdgeSegmentFilter(){

            @Override
            public boolean accept(Edge edge, Point3d segmentVertex0, Point3d segmentVertex1, Collection<Polygon3D> frontGroups, Collection<Polygon3D> backGroups) {
                if (!RenderShape.this._identifier.equals(edge.getPoly1To0GroupId()) || !RenderShape.this._identifier.equals(edge.getPoly0To1GroupId())) {
                    return false;
                }
                return edge.getCreaseAngle() > RenderShape.this._edgeAppearance.getDrawAngle() && frontGroups.size() == 0;
            }
        };
        ArrayList<Path> creasePaths = new ArrayList<Path>(this._edgeProcessor.getPaths(creaseFilter));
        edgeRenderer.drawPaths(result, creasePaths, this._edgeAppearance.getStyle(EdgeAppearance.EdgeType.CREASE));
        edgeRenderer.drawPaths(result, silhouettePaths, this._edgeAppearance.getStyle(EdgeAppearance.EdgeType.BOUNDARY));
        return result;
    }

    public void drawBounds(BufferedImage destination, Color color) {
        Rectangle bounds = this.getBounds();
        Graphics2D graphics = destination.createGraphics();
        graphics.setColor(color);
        graphics.drawRect(bounds.x, bounds.y, bounds.width, bounds.height);
        graphics.dispose();
    }

    public void drawIntersection(BufferedImage destination, RenderShape other, Color color) {
        Rectangle otherBounds;
        Rectangle myBounds = this.getBounds();
        if (myBounds.intersects(otherBounds = other.getBounds())) {
            Rectangle intersection = myBounds.intersection(otherBounds);
            Graphics2D graphics = destination.createGraphics();
            graphics.setColor(color);
            graphics.drawRect(intersection.x, intersection.y, intersection.width, intersection.height);
            graphics.dispose();
        }
    }

    public void drawBoundaryPaths(BufferedImage destination, Color externalColor, Color internalColor) {
        Graphics2D graphics = destination.createGraphics();
        graphics.setColor(externalColor);
        for (Path2D.Double path : this._externalBoundaryPaths2D) {
            graphics.draw(path);
        }
        graphics.dispose();
    }

    public void drawDegeneratePaths(BufferedImage destination, EdgeRenderer edgeRenderer, LineStyle style) {
        Graphics2D graphics = destination.createGraphics();
        for (Path path : this._degeneratePaths) {
            edgeRenderer.drawPath(graphics, path, style);
            edgeRenderer.drawPathVertices(graphics, path, style);
        }
        graphics.dispose();
    }

    public Rectangle getBounds() {
        return this._bounds;
    }

    public Collection<Path> getDegeneratePaths() {
        return Collections.unmodifiableCollection(this._degeneratePaths);
    }

    public String getIdentifier() {
        return this._identifier;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._identifier + "]";
    }

    public int hashCode() {
        return this._identifier.hashCode();
    }

    private BufferedImage applyAlphaMask(BufferedImage interior, WritableDeepImage destination, boolean erase, boolean billboard) {
        BufferedImage destImage = destination.getImage();
        Graphics2D graphics = destImage.createGraphics();
        graphics.setComposite(AlphaComposite.Clear);
        graphics.fillRect(0, 0, destImage.getWidth(), destImage.getHeight());
        graphics.setComposite(AlphaComposite.SrcOver);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics.translate(-this._bounds.x, -this._bounds.y);
        graphics.setColor(Color.WHITE);
        for (Path2D.Double path : this._externalBoundaryPaths2D) {
            graphics.fill(path);
        }
        graphics.setColor(ColorUtils.CLEAR_COLOR);
        graphics.setComposite(AlphaComposite.Src);
        for (Path2D.Double path : this._internalBoundaryPaths2D) {
            graphics.fill(path);
        }
        if (SCAN_CONVERTED_LOGGER.isDebugEnabled()) {
            this.writeDebugImage(this.getIdentifier() + "_MASK", destImage);
        }
        if (erase) {
            destination.setHoleMapFromImage(true);
            if (SCAN_CONVERTED_LOGGER.isDebugEnabled()) {
                this.writeDebugImage(this.getIdentifier() + "_HOLE", destination.getHoleMap().createHoleImage());
            }
        } else {
            graphics.translate(this._bounds.x, this._bounds.y);
            graphics.setComposite(billboard ? AlphaComposite.Src : AlphaComposite.SrcAtop);
            graphics.drawImage((Image)interior, -10, -10, null);
            graphics.dispose();
        }
        return destImage;
    }

    private void getBoundaryPaths(EdgeProcessor.EdgeSegmentFilter filter, List<Path2D.Double> internalPaths, List<Path2D.Double> externalPaths) {
        internalPaths.clear();
        externalPaths.clear();
        this._degeneratePaths.clear();
        ArrayList<Path> silhouettePaths = new ArrayList<Path>(this._edgeProcessor.getPaths(filter));
        if (silhouettePaths.size() == 0) {
            LOGGER.warn("No silhouette paths for \"" + this._identifier + "\"");
        }
        for (Path path : silhouettePaths) {
            if (path.isLoop() && path.getVertexCount() >= 4) continue;
            LOGGER.warn("Degenerate path for \"" + this._identifier + "\": " + path);
            this._degeneratePaths.add(path);
        }
        LinkedList allPaths2D = (LinkedList)this.toPaths2D(silhouettePaths, new LinkedList<Path2D.Double>());
        while (!allPaths2D.isEmpty()) {
            Path2D.Double double_ = (Path2D.Double)allPaths2D.removeFirst();
            boolean internal = false;
            for (Path2D.Double otherPath : new CompoundIterable<Path2D.Double>(allPaths2D, externalPaths)) {
                if (!otherPath.contains(double_.getCurrentPoint())) continue;
                internal = true;
                break;
            }
            if (internal) {
                internalPaths.add(double_);
                continue;
            }
            externalPaths.add(double_);
        }
        LOGGER.debug("Shape \"" + this._identifier + "\" has " + externalPaths.size() + " external and " + internalPaths.size() + " internal boundary paths.");
    }

    private Collection<Path2D.Double> toPaths2D(Collection<Path> paths, Collection<Path2D.Double> result) {
        result.clear();
        for (Path path : paths) {
            result.add(path.toPath2D());
        }
        return result;
    }

    private Rectangle getBounds(List<Path2D.Double> paths) {
        RectangularShape totalBounds = null;
        for (Path2D.Double path : paths) {
            if (totalBounds == null) {
                totalBounds = path.getBounds();
                continue;
            }
            totalBounds = ((Rectangle2D)totalBounds).createUnion(path.getBounds());
        }
        if (totalBounds == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        return totalBounds.getBounds();
    }

    private void writeDebugImage(String imageName, BufferedImage image) {
        try {
            RenderResourceIO.getInstance().writeTemporaryImage(image, imageName);
        }
        catch (FileNotFoundException e) {
            LOGGER.warn("Failed to write debug image: " + imageName, e);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to write debug image: " + imageName, e);
        }
    }

    private static class LocalDepthComparator
    implements Comparator<Polygon3D> {
        private final Point3d _location;
        private static final Point3d EYE_POINT = new Point3d(0.0, 0.0, 0.0);

        public LocalDepthComparator(Point3d location) {
            this._location = location;
        }

        @Override
        public int compare(Polygon3D poly1, Polygon3D poly2) {
            Point3d poly1Point = poly1.getVertex(0, CoordinateSystem.CAMERA);
            Point3d poly2Point = poly2.getVertex(0, CoordinateSystem.CAMERA);
            double p1Dist = VectorUtils.parametricLinePlaneIntersection(EYE_POINT, this._location, poly1Point, poly1.getNormal());
            double p2Dist = VectorUtils.parametricLinePlaneIntersection(EYE_POINT, this._location, poly2Point, poly2.getNormal());
            return Double.compare(p1Dist, p2Dist);
        }
    }

    private static class VisibleBoundarySegmentFilter
    implements EdgeProcessor.EdgeSegmentFilter {
        private final String _groupId;

        public VisibleBoundarySegmentFilter(String groupId) {
            this._groupId = groupId;
        }

        @Override
        public boolean accept(Edge edge, Point3d segmentVertex0, Point3d segmentVertex1, Collection<Polygon3D> frontPolys, Collection<Polygon3D> backPolys) {
            if (!edge.isGroupBoundaryEdge() || !frontPolys.isEmpty()) {
                return false;
            }
            boolean backPolysContainsGroup = false;
            for (Polygon3D polygon : backPolys) {
                if (!this._groupId.equals(polygon.getGroupIdentifier())) continue;
                backPolysContainsGroup = true;
                break;
            }
            if (this._groupId.equals(edge.getPoly1To0GroupId()) || this._groupId.equals(edge.getPoly0To1GroupId())) {
                return !backPolysContainsGroup;
            }
            if (backPolysContainsGroup) {
                if (backPolys.size() == 1) {
                    return true;
                }
                Point3d midpoint = VectorUtils.midPoint(segmentVertex0, segmentVertex1);
                ArrayList<Polygon3D> backPolyList = new ArrayList<Polygon3D>(backPolys);
                Collections.sort(backPolyList, new LocalDepthComparator(midpoint));
                if (this._groupId.equals(((Polygon3D)backPolyList.get(0)).getGroupIdentifier())) {
                    return true;
                }
            }
            return false;
        }
    }

    private static class TotalBoundarySegmentFilter
    implements EdgeProcessor.EdgeSegmentFilter {
        private final String _groupId;

        TotalBoundarySegmentFilter(String groupId) {
            this._groupId = groupId;
        }

        @Override
        public boolean accept(Edge edge, Point3d segmentVertex0, Point3d segmentVertex1, Collection<Polygon3D> frontPolys, Collection<Polygon3D> backPolys) {
            if (!edge.isGroupBoundaryEdge()) {
                return false;
            }
            if (!this._groupId.equals(edge.getPoly1To0GroupId()) && !this._groupId.equals(edge.getPoly0To1GroupId())) {
                return false;
            }
            for (Polygon3D polygon : new CompoundIterable<Polygon3D>(frontPolys, backPolys)) {
                if (!this._groupId.equals(polygon.getGroupIdentifier())) continue;
                return false;
            }
            return true;
        }
    }
}

