/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.render;

import com.sodiumarc.patchwork.util.ColorComponent;
import com.sodiumarc.patchwork.util.ColorUtils;
import com.sodiumarc.patchwork.util.MathUtils;
import com.sodiumarc.patchwork.util.image.ImageUtils;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Arrays;

public class HoleMap {
    public static int MAX_SIZE = 4000;
    private Rectangle mappedRegion;
    private float[] mapData;
    final float defaultValue = 1.0f;

    public HoleMap() {
    }

    public HoleMap(BufferedImage source, int xOffset, int yOffset, boolean invert) {
        this.setFrom(source, xOffset, yOffset, invert);
    }

    public boolean isEmpty() {
        return this.mappedRegion == null;
    }

    public void setFrom(BufferedImage source, int xOffset, int yOffset, boolean invert) {
        this.mapRegion(new Rectangle(xOffset, yOffset, source.getWidth(), source.getHeight()));
        for (int x = 0; x < source.getWidth(); ++x) {
            for (int y = 0; y < source.getHeight(); ++y) {
                int intVal = ColorUtils.getComponent(source.getRGB(x, y), ColorComponent.ALPHA);
                float floatVal = (float)intVal / 255.0f;
                if (invert) {
                    floatVal = 1.0f - floatVal;
                }
                this.setHoleValue(this.mapData, this.mappedRegion, x + xOffset, y + yOffset, floatVal);
            }
        }
    }

    public float getHoleValue(int x, int y) {
        if (this.mappedRegion == null || !this.mappedRegion.contains(x, y)) {
            return 1.0f;
        }
        return this.getHoleValue(this.mapData, this.mappedRegion, x, y);
    }

    public void setHoleValue(int x, int y, float value) {
        if (value == 1.0f) {
            return;
        }
        if (this.mappedRegion == null || !this.mappedRegion.contains(x, y)) {
            this.mapRegion(new Rectangle(x, y, 1, 1));
        }
        this.setHoleValue(this.mapData, this.mappedRegion, x, y, (byte)(value * 255.0f));
    }

    public void mapRegion(Rectangle region) {
        if (this.mappedRegion == null || !this.mappedRegion.contains(region)) {
            Rectangle newRegion;
            Rectangle rectangle = newRegion = this.mappedRegion == null ? region : this.mappedRegion.createUnion(region).getBounds();
            assert (newRegion.width <= MAX_SIZE) : "Maximum width exceeded" + newRegion.width;
            assert (newRegion.height <= MAX_SIZE) : "Maximum height exceeded" + newRegion.height;
            float[] newData = new float[newRegion.width * newRegion.height];
            Arrays.fill(newData, 1.0f);
            if (this.mappedRegion != null && this.mapData != null) {
                int n = this.mappedRegion.x + this.mappedRegion.width;
                for (int x = this.mappedRegion.x; x < n; ++x) {
                    int m = this.mappedRegion.y + this.mappedRegion.height;
                    for (int y = this.mappedRegion.y; y < m; ++y) {
                        this.setHoleValue(newData, newRegion, x, y, this.getHoleValue(this.mapData, this.mappedRegion, x, y));
                    }
                }
            }
            this.mappedRegion = newRegion;
            this.mapData = newData;
        }
    }

    public void prepareToAccept(HoleMap other) {
        if (other.mappedRegion != null) {
            this.mapRegion(other.mappedRegion);
        }
    }

    public void applyTo(BufferedImage destination, int xOffset, int yOffset) {
        if (this.mappedRegion == null) {
            return;
        }
        for (int x = 0; x < destination.getWidth(); ++x) {
            for (int y = 0; y < destination.getHeight(); ++y) {
                this.applyTo(destination, xOffset, yOffset, x + xOffset, y + yOffset);
            }
        }
    }

    public void applyTo(BufferedImage destination, int xOffset, int yOffset, int x, int y) {
        int newAlpha;
        float holeValue = this.getHoleValue(x, y);
        if ((double)holeValue == 1.0) {
            return;
        }
        int xDest = x - xOffset;
        int yDest = y - yOffset;
        int destColor = destination.getRGB(xDest, yDest);
        if ((double)holeValue == 0.0) {
            newAlpha = 0;
        } else {
            int alpha = ColorUtils.getComponent(destColor, ColorComponent.ALPHA);
            newAlpha = (int)((float)alpha * holeValue);
        }
        destColor = ColorUtils.setComponent(destColor, ColorComponent.ALPHA, newAlpha);
        destination.setRGB(xDest, yDest, destColor);
    }

    public void applyTo(HoleMap destination) {
        if (this.mappedRegion == null) {
            return;
        }
        destination.prepareToAccept(this);
        for (int x = 0; x < this.mappedRegion.width; ++x) {
            for (int y = 0; y < this.mappedRegion.width; ++y) {
                this.applyTo(destination, x + this.mappedRegion.x, y + this.mappedRegion.y);
            }
        }
    }

    public void applyTo(HoleMap destination, int x, int y) {
        float holeValue = this.getHoleValue(x, y);
        if ((double)holeValue == 1.0) {
            return;
        }
        if ((double)holeValue == 0.0) {
            destination.setHoleValue(x, y, 0.0f);
        } else {
            destination.setHoleValue(x, y, holeValue * destination.getHoleValue(x, y));
        }
    }

    public BufferedImage createHoleImage() {
        if (this.mappedRegion == null) {
            return null;
        }
        BufferedImage result = new BufferedImage(this.mappedRegion.width, this.mappedRegion.height, 2);
        ImageUtils.fill(result, Color.WHITE);
        for (int y = 0; y < this.mappedRegion.height; ++y) {
            for (int x = 0; x < this.mappedRegion.width; ++x) {
                float value = this.mapData[y * this.mappedRegion.width + x];
                Color color = new Color(value, value, value, value);
                result.setRGB(x, y, ColorUtils.toIntARGB(color));
            }
        }
        return result;
    }

    private void setHoleValue(float[] data, Rectangle mapRegion, int x, int y, float value) {
        int xMap = x - mapRegion.x;
        int yMap = y - mapRegion.y;
        int index = yMap * mapRegion.width + xMap;
        data[index] = MathUtils.clamp(value, 0.0f, 1.0f);
    }

    private float getHoleValue(float[] data, Rectangle mapRegion, int x, int y) {
        int xMap = x - mapRegion.x;
        int yMap = y - mapRegion.y;
        int index = yMap * mapRegion.width + xMap;
        return data[index];
    }
}

