/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.render;

import com.sodiumarc.patchwork.render.DepthFunction;
import com.sodiumarc.patchwork.util.ColorComponent;
import com.sodiumarc.patchwork.util.ColorUtils;
import com.sodiumarc.patchwork.util.MathUtils;
import java.awt.image.BufferedImage;

public class DepthMap
implements DepthFunction {
    private final int _width;
    private final int _height;
    private final double[][] _data;
    private double _minDepth = Double.POSITIVE_INFINITY;
    private double _maxDepth = Double.NEGATIVE_INFINITY;

    public DepthMap(int width, int height) {
        this._width = width;
        this._height = height;
        this._data = new double[width][height];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                this._data[x][y] = Double.POSITIVE_INFINITY;
            }
        }
    }

    public int getWidth() {
        return this._width;
    }

    public int getHeight() {
        return this._height;
    }

    public void setDepth(int x, int y, double depth) {
        this._data[x][y] = depth;
        if (depth > this._maxDepth) {
            this._maxDepth = depth;
        }
        if (depth < this._minDepth) {
            this._minDepth = depth;
        }
    }

    @Override
    public double getDepth(int x, int y) {
        if (x < 0 || x >= this._width || y < 0 || y >= this._height) {
            return Double.POSITIVE_INFINITY;
        }
        return this._data[x][y];
    }

    public double getMaxFiniteDepth() {
        return this._maxDepth;
    }

    public double getMinFiniteDepth() {
        return this._minDepth;
    }

    public BufferedImage createDepthImage() {
        BufferedImage result = new BufferedImage(this._width, this._height, 2);
        for (int y = 0; y < this._height; ++y) {
            for (int x = 0; x < this._width; ++x) {
                double depth = this._data[x][y];
                if (Double.isInfinite(depth)) continue;
                int color = -16777216;
                double dFraction = MathUtils.rangeFraction(depth, this._maxDepth, this._minDepth);
                int value = ColorUtils.clampComponent((int)(255.0 * dFraction));
                for (ColorComponent component : ColorComponent.RGB_ONLY) {
                    color = ColorUtils.setComponent(color, component, value);
                }
                result.setRGB(x, y, color);
            }
        }
        return result;
    }
}

