/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.render;

import com.sodiumarc.patchwork.render.EdgeRenderer;
import com.sodiumarc.patchwork.render.LineStyle;
import com.sodiumarc.patchwork.render.mesh.MeshUtils;
import com.sodiumarc.patchwork.render.mesh.Path;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.List;
import javax.vecmath.Point3d;
import org.apache.log4j.Logger;

public class DefaultEdgeRenderer
implements EdgeRenderer {
    private boolean _drawPathVertices = false;
    private final Logger _logger = Logger.getLogger(this.getClass());

    @Override
    public void drawPaths(Graphics2D graphics, List<Path> paths, LineStyle style) {
        for (Path path : paths) {
            this.drawPath(graphics, path.detach(), style);
            if (!this._drawPathVertices) continue;
            this.drawPathVertices(graphics, path, style);
        }
    }

    @Override
    public void drawPath(Graphics2D graphics, Path path, LineStyle style) {
        if (style == null) {
            style = LineStyle.DEFAULT_BLACK;
        }
        for (int i = 0; i < path.getVertexCount() - 1; ++i) {
            this.drawEdge(graphics, path.getVertex(i), path.getVertex(i + 1), style.getColor());
        }
    }

    @Override
    public void drawPathVertices(Graphics2D graphics, Path path, LineStyle style) {
        if (style == null) {
            style = LineStyle.DEFAULT_BLACK;
        }
        for (int i = 0; i < path.getVertexCount(); ++i) {
            MeshUtils.drawVertex(graphics, path.getVertex(i), style.getColor(), 2, "" + path.getVertexIndex(i));
        }
    }

    protected void drawEdge(Graphics2D graphics, Point3d vertex0, Point3d vertex1, Color color) {
        graphics.setColor(color);
        graphics.drawLine((int)vertex0.getX(), (int)vertex0.getY(), (int)vertex1.getX(), (int)vertex1.getY());
    }
}

