/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.render;

import com.sodiumarc.patchwork.util.Collection.Range;
import com.sodiumarc.patchwork.util.GeometricAxis;
import com.sodiumarc.patchwork.util.VectorUtils;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

public class BoundingBox3D {
    private final Point3d lower = new Point3d();
    private final Point3d upper = new Point3d();

    public BoundingBox3D() {
    }

    public BoundingBox3D(Point3d min, Point3d max) {
        if (min != null) {
            this.lower.set(min);
        }
        if (min != null) {
            this.upper.set(max);
        }
    }

    public void getLower(Point3d point) {
        point.set(this.lower);
    }

    public void getUpper(Point3d point) {
        point.set(this.upper);
    }

    public Double getDimension(GeometricAxis axis) {
        Point3d point = new Point3d();
        this.getLower(point);
        double min = VectorUtils.getComponent(point, axis);
        this.getUpper(point);
        double max = VectorUtils.getComponent(point, axis);
        return max - min;
    }

    public Range<Double> getRange(GeometricAxis axis) {
        Point3d point = new Point3d();
        this.getLower(point);
        double min = VectorUtils.getComponent(point, axis);
        this.getUpper(point);
        double max = VectorUtils.getComponent(point, axis);
        return new Range<Double>(min, max);
    }

    public Vector3d getDiagonal() {
        Point3d point = new Point3d();
        this.getUpper(point);
        Vector3d result = new Vector3d(point);
        this.getLower(point);
        result.sub(point);
        return result;
    }

    public boolean nearlyEquals(BoundingBox3D other, double maxDistance) {
        Point3d point = new Point3d();
        Point3d otherPoint = new Point3d();
        this.getLower(point);
        other.getLower(otherPoint);
        if (point.distance(otherPoint) > maxDistance) {
            return false;
        }
        this.getUpper(point);
        other.getUpper(otherPoint);
        return !(point.distance(otherPoint) > maxDistance);
    }

    public List<Point3d> getAllCornerPoints() {
        Point3d upper = new Point3d();
        Point3d lower = new Point3d();
        this.getLower(lower);
        this.getUpper(upper);
        ArrayList<Point3d> result = new ArrayList<Point3d>();
        result.add(lower);
        result.add(new Point3d(upper.x, lower.y, lower.z));
        result.add(new Point3d(lower.x, upper.y, lower.z));
        result.add(new Point3d(lower.x, lower.y, upper.z));
        result.add(upper);
        result.add(new Point3d(lower.x, upper.y, upper.z));
        result.add(new Point3d(upper.x, lower.y, upper.z));
        result.add(new Point3d(upper.x, upper.y, lower.z));
        return result;
    }

    public Point3d getCenterPoint() {
        Point3d upper = new Point3d();
        Point3d lower = new Point3d();
        this.getLower(lower);
        this.getUpper(upper);
        return new Point3d((lower.x + upper.x) / 2.0, (lower.y + upper.y) / 2.0, (lower.z + upper.z) / 2.0);
    }

    public void combine(BoundingBox3D boundingBox) {
        Point3d lower1 = boundingBox.lower;
        Point3d upper1 = boundingBox.upper;
        this.lower.set(Math.min(this.lower.x, lower1.x), Math.min(this.lower.y, lower1.y), Math.min(this.lower.z, lower1.z));
        this.upper.set(Math.max(this.upper.x, upper1.x), Math.max(this.upper.y, upper1.y), Math.max(this.upper.z, upper1.z));
    }
}

