/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.generate.condition;

import com.sodiumarc.patchwork.app.scenecomposer.as3.AS3ConversionUtils;
import com.sodiumarc.patchwork.app.scenecomposer.as3.TemplateLibrary;
import com.sodiumarc.patchwork.generate.condition.TransitionCondition;
import com.sodiumarc.patchwork.util.StringTemplate;
import com.sodiumarc.patchwork.util.StringUtils;
import com.sodiumarc.patchwork.util.xml.DocumentNodeDecoder;
import com.sodiumarc.patchwork.util.xml.XMLUtils;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

public class CompoundCondition
extends TransitionCondition {
    public static String ELEMENT_NAME = "compound_condition";
    public static String SATISFY_ALL_ATTR_NAME = "satisfy_all";
    public static String NEGATE_ATTR_NAME = "negate";
    public static DocumentNodeDecoder<CompoundCondition> DECODER = new DocumentNodeDecoder<CompoundCondition>(){

        @Override
        public CompoundCondition decode(Node node) {
            assert (node != null) : "Null node";
            if (!node.getLocalName().equals(ELEMENT_NAME)) {
                return null;
            }
            Map<String, String> attributes = XMLUtils.getAttributes(node);
            return new CompoundCondition(XMLUtils.decodeChildren(node, TransitionCondition.TRANSITION_DECODERS), Boolean.valueOf(attributes.get(SATISFY_ALL_ATTR_NAME)), Boolean.valueOf(attributes.get(NEGATE_ATTR_NAME)));
        }
    };
    private final List<? extends TransitionCondition> subConditions;
    private final boolean satisfyAll;
    private final boolean negate;

    public CompoundCondition(List<? extends TransitionCondition> subConditions, boolean satisfyAll, boolean negate) {
        this.subConditions = subConditions;
        this.satisfyAll = satisfyAll;
        this.negate = negate;
    }

    @Override
    public String toAS3String(TemplateLibrary templates) throws ParseException {
        StringTemplate template = templates.getTemplate(this.getClass());
        assert (template != null) : "Missing template: " + this.getClass();
        template.setParameterValue("CONDITIONS", StringUtils.toDelimitedList(AS3ConversionUtils.toAS3String(this.subConditions, templates), ","));
        template.setParameterValue("SATISFY_ALL", Boolean.toString(this.satisfyAll));
        template.setParameterValue("NEGATE", Boolean.toString(this.negate));
        return template.getProcessedText();
    }
}

