/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.generate;

import com.sodiumarc.patchwork.FileUtils;
import com.sodiumarc.patchwork.generate.GeneratorAppProperties;
import com.sodiumarc.patchwork.util.ResourceIO;
import com.sodiumarc.patchwork.util.xml.XMLUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.stream.FileImageOutputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class GeneratorResourceIO
extends ResourceIO {
    public static final String AS3_EXTENSION = "as";
    public static final String PROPERTIES_EXTENSION = "properties";
    public static final String IMAGE_EXTENSION = "png";
    private final File imageInputDir = new File(GeneratorAppProperties.BASE_DIR.getValue(), GeneratorAppProperties.IMAGE_INPUT_DIR.getValue());
    private final File xmlInputDir = new File(GeneratorAppProperties.BASE_DIR.getValue(), GeneratorAppProperties.XML_INPUT_DIR.getValue());
    private final File imageOutputDir = new File(GeneratorAppProperties.BASE_DIR.getValue(), GeneratorAppProperties.IMAGE_OUTPUT_DIR.getValue());
    private final File as3OutputDir = new File(GeneratorAppProperties.BASE_DIR.getValue(), GeneratorAppProperties.AS3_OUTPUT_DIR.getValue());
    private static final GeneratorResourceIO INSTANCE = new GeneratorResourceIO();

    public static GeneratorResourceIO getInstance() {
        return INSTANCE;
    }

    public Document getXMLDocument(String filename) throws IOException, ParserConfigurationException, SAXException {
        return XMLUtils.getXMLDocument(new File(this.xmlInputDir, filename), true);
    }

    public List<Document> getXMLDocuments() throws IOException, ParserConfigurationException, SAXException {
        return this.getXMLDocuments(this.xmlInputDir);
    }

    public void writeAS3File(String content, String filename) throws IOException {
        filename = FileUtils.ensureExtension(filename, AS3_EXTENSION);
        File outputFile = new File(this.as3OutputDir, filename);
        FileUtils.writeString(content, outputFile);
    }

    public BufferedImage getBufferedImage(String name) throws IOException {
        String filename = FileUtils.ensureExtension(name, IMAGE_EXTENSION);
        File file = new File(this.imageInputDir, filename);
        return ImageIO.read(file);
    }

    public void writeInputImage(BufferedImage image, String filename) throws FileNotFoundException, IOException {
        filename = FileUtils.ensureExtension(filename, IMAGE_EXTENSION);
        File outputFile = new File(this.imageInputDir, filename);
        ImageIO.write((RenderedImage)image, FileUtils.getFileExtension(filename), new FileImageOutputStream(outputFile));
    }

    public void writeOutputImage(BufferedImage image, String filename) throws FileNotFoundException, IOException {
        filename = FileUtils.ensureExtension(filename, IMAGE_EXTENSION);
        File outputFile = new File(this.imageOutputDir, filename);
        ImageIO.write((RenderedImage)image, FileUtils.getFileExtension(filename), new FileImageOutputStream(outputFile));
    }

    private GeneratorResourceIO() {
    }
}

