/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.generate;

import com.sodiumarc.patchwork.app.scenecomposer.as3.AS3Convertible;
import com.sodiumarc.patchwork.app.scenecomposer.as3.TemplateLibrary;
import com.sodiumarc.patchwork.generate.Card;
import com.sodiumarc.patchwork.generate.GeneratorResourceIO;
import com.sodiumarc.patchwork.util.StringTemplate;
import com.sodiumarc.patchwork.util.xml.DocumentNodeDecoder;
import com.sodiumarc.patchwork.util.xml.XMLUtils;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class GameConfig
implements AS3Convertible {
    public static final String DEFAULT_BG_COLOR = "0xEEEEEE";
    public static String ELEMENT_NAME = "game_config";
    public static String PROLOGUE_CARD_ID_ATTR = "prologue_card_id";
    public static String PROLOGUE_END_STATE_ID_ATTR = "prologue_end_state_id";
    public static DocumentNodeDecoder<GameConfig> DECODER = new DocumentNodeDecoder<GameConfig>(){

        @Override
        public GameConfig decode(Node node) {
            assert (node != null) : "Null node";
            if (!node.getLocalName().equals(ELEMENT_NAME)) {
                return null;
            }
            Map<String, String> attributes = XMLUtils.getAttributes(node);
            return new GameConfig(attributes.get(PROLOGUE_CARD_ID_ATTR), attributes.get(PROLOGUE_END_STATE_ID_ATTR));
        }
    };
    private List<Card> cards;
    private Map<String, Card> cardsByID;
    private final String prologueCardID;
    private final String prologueEndStateID;

    public static GameConfig loadFromFile(String inputFilename) throws IOException, ParserConfigurationException, SAXException {
        Document document = GeneratorResourceIO.getInstance().getXMLDocument(inputFilename);
        return DECODER.decode(document.getDocumentElement());
    }

    public static String interpretRGBConstant(String constant) {
        if (constant == null) {
            return null;
        }
        if ("GRID".equals(constant)) {
            return DEFAULT_BG_COLOR;
        }
        return constant;
    }

    public GameConfig(String prologueCardID, String prologueEndStateID) {
        this.prologueCardID = prologueCardID;
        this.prologueEndStateID = prologueEndStateID;
    }

    public Set<String> getCardFilenames() {
        HashSet<String> result = new HashSet<String>();
        try {
            for (Document document : GeneratorResourceIO.getInstance().getXMLDocuments()) {
                result.add(XMLUtils.getFilename(document.getDocumentElement()));
            }
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass()).warn("Error reading card files", e);
        }
        return result;
    }

    public Set<String> getCardIDs() {
        HashSet<String> result = new HashSet<String>();
        try {
            for (Document document : GeneratorResourceIO.getInstance().getXMLDocuments()) {
                result.add(Card.getCardID(document));
            }
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass()).warn("Error reading card IDs", e);
        }
        return result;
    }

    public List<Card> getCards() throws IOException, ParserConfigurationException, SAXException {
        if (this.cards == null) {
            this.cards = new ArrayList<Card>();
            this.cardsByID = new HashMap<String, Card>();
            for (Document document : GeneratorResourceIO.getInstance().getXMLDocuments()) {
                Card card = Card.DECODER.decode(document.getDocumentElement());
                this.cards.add(card);
                this.cardsByID.put(card.getId(), card);
            }
        }
        return this.cards;
    }

    public Card getCard(String filename) throws IOException, ParserConfigurationException, SAXException {
        Document document = GeneratorResourceIO.getInstance().getXMLDocument(filename);
        return Card.DECODER.decode(document.getDocumentElement());
    }

    @Override
    public String toAS3String(TemplateLibrary templates) throws ParseException {
        StringTemplate template = templates.getTemplate(this.getClass());
        assert (template != null) : "Missing template: " + this.getClass();
        StringTemplate addCardTemplate = templates.getTemplate(this.getClass(), "ADD_CARD");
        assert (addCardTemplate != null) : "Missing template: ADD_CARD";
        StringBuilder addCards = new StringBuilder();
        for (String cardID : this.getCardIDs()) {
            addCardTemplate.setParameterValue("CARD_ID", cardID);
            addCards.append(addCardTemplate.getProcessedText());
        }
        template.setParameterValue("ADD_CARDS", addCards.toString());
        template.setParameterValue("GRID_BG_COLOR", DEFAULT_BG_COLOR);
        template.setParameterValueQuoted("PROLOGUE_CARD_ID", this.prologueCardID);
        template.setParameterValueQuoted("PROLOGUE_END_STATE_ID", this.prologueEndStateID);
        template.setParameterValue((Object)"GRID_SIZE", 2 * Card.CARD_SIZE);
        return template.getProcessedText();
    }
}

