/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.generate;

import com.sodiumarc.patchwork.animation.AS3Animation;
import com.sodiumarc.patchwork.animation.AnimationMask;
import com.sodiumarc.patchwork.app.scenecomposer.as3.AS3ConversionUtils;
import com.sodiumarc.patchwork.app.scenecomposer.as3.TemplateLibrary;
import com.sodiumarc.patchwork.generate.Card;
import com.sodiumarc.patchwork.generate.GameConfig;
import com.sodiumarc.patchwork.generate.Hotspot;
import com.sodiumarc.patchwork.generate.condition.CardLinkCriteria;
import com.sodiumarc.patchwork.generate.condition.ConditionalStateTransition;
import com.sodiumarc.patchwork.render.control.RenderControl;
import com.sodiumarc.patchwork.render.control.RenderImage;
import com.sodiumarc.patchwork.util.Collection.CollectionUtils;
import com.sodiumarc.patchwork.util.Collection.Range;
import com.sodiumarc.patchwork.util.StringTemplate;
import com.sodiumarc.patchwork.util.xml.DocumentNodeDecoder;
import com.sodiumarc.patchwork.util.xml.XMLUtils;
import java.awt.Dimension;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

public class CardState {
    public static String ELEMENT_NAME = "card_state";
    public static String ID_ATTR_NAME = "id";
    public static String GEN_SHADOW_ATTR_NAME = "gen_shadow";
    public static String SPAWN_CARD_ID_ATTR_NAME = "spawn_card_id";
    public static String BG_COLOR_ATTR_NAME = "bg_color";
    public static String AUTO_TRANSITION_ID_ATTR_NAME = "transition_to_id";
    public static String INHERIT_FROM_ID_ATTR_NAME = "inherit_from_id";
    public static String GRID_ANCHORED_ATTR_NAME = "grid_anchored";
    public static DocumentNodeDecoder<CardState> DECODER = new DocumentNodeDecoder<CardState>(){

        @Override
        public CardState decode(Node node) {
            assert (node != null) : "Null node";
            if (!node.getLocalName().equals(ELEMENT_NAME)) {
                return null;
            }
            Map<String, String> attributes = XMLUtils.getAttributes(node);
            CardState result = new CardState(attributes.get(ID_ATTR_NAME));
            result.setAnimations(XMLUtils.decodeChildren(node, AS3Animation.getSubclassDecoders()));
            result.setHotspots(XMLUtils.decodeChildren(node, Hotspot.DECODER));
            result.setCardLinkCriteria(XMLUtils.decodeChildren(node, CardLinkCriteria.DECODER));
            result.setConditionalTransitions(XMLUtils.decodeChildren(node, ConditionalStateTransition.DECODER));
            result.setAnimationMasks(XMLUtils.decodeChildren(node, AnimationMask.DECODER));
            result.setAutoTransitionStateID(attributes.get(AUTO_TRANSITION_ID_ATTR_NAME));
            result.setSpawnCardID(attributes.get(SPAWN_CARD_ID_ATTR_NAME));
            result.setGenerateShadow(Boolean.valueOf(attributes.get(GEN_SHADOW_ATTR_NAME)));
            result.setBgColor(GameConfig.interpretRGBConstant(attributes.get(BG_COLOR_ATTR_NAME)));
            result.setInheritFromID(attributes.get(INHERIT_FROM_ID_ATTR_NAME));
            result.setGridAnchored(Boolean.valueOf(attributes.get(GRID_ANCHORED_ATTR_NAME)));
            return result;
        }
    };
    private final String id;
    private List<? extends AS3Animation> animations;
    private List<Hotspot> hotspots;
    private List<CardLinkCriteria> cardLinkCriteria;
    private List<ConditionalStateTransition> conditionalTransitions;
    private List<AnimationMask> animationMasks;
    private String autoTransitionStateID;
    private String spawnCardID;
    private String bgColor;
    private boolean generateShadow;
    private String inheritFromID;
    private boolean isGridAnchored;
    private Card card;
    private List<RenderImage> shadowImages;
    private static List<RenderImage> DEFAULT_SHADOW_IMAGES;
    private static final int SHADOW_STAGES = 2;
    private static final Range<Integer> SHADOW_RADIUS_RANGE;
    private static final Range<Float> SHADOW_ALPHA_RANGE;

    public static List<RenderImage> getDefaultShadowImages() {
        if (DEFAULT_SHADOW_IMAGES == null) {
            return Collections.emptyList();
        }
        return DEFAULT_SHADOW_IMAGES;
    }

    public CardState(String id) {
        this.id = id;
        this.animations = Collections.emptyList();
        this.cardLinkCriteria = Collections.emptyList();
        this.conditionalTransitions = Collections.emptyList();
        this.hotspots = Collections.emptyList();
        this.animationMasks = Collections.emptyList();
        if (DEFAULT_SHADOW_IMAGES == null) {
            DEFAULT_SHADOW_IMAGES = this.generateShadows(RenderControl.getInstance().createDummy("default", new Dimension(Card.CARD_SIZE, Card.CARD_SIZE)));
        }
    }

    public void init(Card card) throws IOException {
        this.card = card;
    }

    public String getID() {
        return this.id;
    }

    public String getQualifiedID() {
        return this.getCard().getId() + "." + this.id;
    }

    public List<Hotspot> getHotspots() {
        CardState inheritFrom = this.getInheritFromState();
        if (inheritFrom != null) {
            return CollectionUtils.concatenate(inheritFrom.getHotspots(), this.hotspots);
        }
        return this.hotspots;
    }

    public void setHotspots(List<Hotspot> hotspots) {
        this.hotspots = hotspots;
    }

    public List<? extends AS3Animation> getAnimations() {
        CardState inheritFrom = this.getInheritFromState();
        if (inheritFrom != null) {
            ArrayList<AS3Animation> result = new ArrayList<AS3Animation>();
            result.addAll(inheritFrom.getAnimations());
            result.addAll(this.animations);
            return result;
        }
        return this.animations;
    }

    public void setAnimations(List<? extends AS3Animation> animations) {
        this.animations = animations;
    }

    public List<CardLinkCriteria> getCardLinkCriteria() {
        CardState inheritFrom = this.getInheritFromState();
        if (inheritFrom != null) {
            return CollectionUtils.concatenate(inheritFrom.getCardLinkCriteria(), this.cardLinkCriteria);
        }
        return this.cardLinkCriteria;
    }

    public void setCardLinkCriteria(List<CardLinkCriteria> cardLinkCriteria) {
        this.cardLinkCriteria = cardLinkCriteria;
    }

    public List<ConditionalStateTransition> getConditionalTransitions() {
        CardState inheritFrom = this.getInheritFromState();
        if (inheritFrom != null) {
            return CollectionUtils.concatenate(inheritFrom.getConditionalTransitions(), this.conditionalTransitions);
        }
        return this.conditionalTransitions;
    }

    public void setConditionalTransitions(List<ConditionalStateTransition> conditionalTransitions) {
        this.conditionalTransitions = conditionalTransitions;
    }

    public void setAnimationMasks(List<AnimationMask> animationMasks) {
        this.animationMasks = animationMasks;
    }

    public List<AnimationMask> getAnimationMasks() {
        return this.animationMasks;
    }

    public String getBgColor() {
        if (this.bgColor == null) {
            CardState inheritFrom = this.getInheritFromState();
            return inheritFrom == null ? null : inheritFrom.getBgColor();
        }
        return this.bgColor;
    }

    public void setBgColor(String bgColor) {
        this.bgColor = bgColor;
    }

    public Card getCard() {
        return this.card;
    }

    public void setAutoTransitionStateID(String autoTransitionStateID) {
        this.autoTransitionStateID = autoTransitionStateID;
    }

    public void setSpawnCardID(String spawnCardID) {
        this.spawnCardID = spawnCardID;
    }

    public void setGenerateShadow(boolean generateShadow) {
        this.generateShadow = generateShadow;
    }

    public void setInheritFromID(String inheritFromID) {
        this.inheritFromID = inheritFromID;
    }

    public void setGridAnchored(boolean isGridAnchored) {
        this.isGridAnchored = isGridAnchored;
    }

    public boolean isGridAnchored() {
        return this.isGridAnchored;
    }

    public List<RenderImage> getShadowImages() throws IOException {
        if (this.generateShadow) {
            if (this.shadowImages == null) {
                this.shadowImages = this.generateShadows(this.getCompositeImage());
            }
            return this.shadowImages;
        }
        return DEFAULT_SHADOW_IMAGES;
    }

    public String toAS3String(TemplateLibrary templates) throws ParseException, IOException {
        StringTemplate template = templates.getTemplate(this.getClass());
        assert (template != null) : "Missing template: " + this.getClass();
        StringTemplate addToArrayTemplate = templates.getTemplate(AS3Animation.class, "ADD_TO_ARRAY");
        assert (addToArrayTemplate != null) : "Missing template: ADD_TO_ARRAY";
        StringBuilder animDefList = new StringBuilder();
        for (AS3Animation aS3Animation : this.getAnimations()) {
            addToArrayTemplate.clearParameterValues();
            addToArrayTemplate.setParameterValue("ANIMATION", aS3Animation.toAS3String(templates));
            animDefList.append(addToArrayTemplate.getProcessedText());
        }
        template.clearParameterValues();
        template.setParameterValue("HOTSPOTS", AS3ConversionUtils.toDelimitedList(this.getHotspots(), templates, ","));
        template.setParameterValue("CARD_LINK_CRITERIA", AS3ConversionUtils.toDelimitedList(this.getCardLinkCriteria(), templates, ","));
        template.setParameterValue("CONDITIONAL_TRANSITIONS", AS3ConversionUtils.toDelimitedList(this.getConditionalTransitions(), templates, ","));
        template.setParameterValue("ANIMATIONS", animDefList.toString());
        template.setParameterValue("MASKS", AS3ConversionUtils.toDelimitedList(this.getAnimationMasks(), templates, ""));
        template.setParameterValue("CARD_STATE_ID", this.getID());
        template.setParameterValueQuoted("TRANSITION_STATE_ID", this.autoTransitionStateID);
        template.setParameterValueQuoted("SPAWN_CARD_ID", this.spawnCardID);
        String bgColor = this.getBgColor();
        template.setParameterValue("BG_COLOR", bgColor == null ? "0xEEEEEE" : bgColor);
        template.setParameterValue("BG_ALPHA", Integer.toString(bgColor == null ? 0 : 1));
        template.setParameterValue("IS_GRID_ANCHORED", Boolean.toString(this.isGridAnchored));
        if (this.generateShadow) {
            StringTemplate stringTemplate = templates.getTemplate(this.getClass(), "CUSTOM_SHADOW");
            assert (stringTemplate != null) : "Missing template: CUSTOM_SHADOW";
            StringTemplate shadowImageTemplate = templates.getTemplate("SHADOW_IMAGE");
            assert (shadowImageTemplate != null) : "Missing template: SHADOW_IMAGE";
            StringBuilder shadows = new StringBuilder();
            List<RenderImage> shadowImages = this.getShadowImages();
            int index = 0;
            for (RenderImage shadowImage : shadowImages) {
                shadowImageTemplate.setParameterValue("IMAGE_NAME", shadowImage.getImageFilename());
                shadowImageTemplate.setParameterValue("IMAGE_INDEX", Integer.toString(index++));
                shadowImageTemplate.setParameterValue("IMAGE_COUNT", Integer.toString(shadowImages.size()));
                shadows.append(shadowImageTemplate.getProcessedText());
            }
            stringTemplate.setParameterValue("SHADOW_IMAGES", shadows.toString());
            stringTemplate.setParameterValue("CARD_STATE_ID", this.getID());
            template.setParameterValue("CUSTOM_SHADOW", stringTemplate.getProcessedText());
        }
        return template.getProcessedText();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [id=" + this.id + "]";
    }

    private RenderImage getCompositeImage() throws IOException {
        ArrayList<RenderImage> imagesToComposite = new ArrayList<RenderImage>();
        for (AS3Animation aS3Animation : this.getAnimations()) {
            CollectionUtils.addIfNotNull(imagesToComposite, CollectionUtils.first(aS3Animation.getImages(true)));
        }
        return RenderControl.getInstance().createComposite(this.getQualifiedID(), imagesToComposite);
    }

    private List<RenderImage> generateShadows(RenderImage composite) {
        if (composite == null || composite.isEmpty()) {
            return Collections.emptyList();
        }
        List filters = Collections.emptyList();
        return composite.generateShadows(2, SHADOW_RADIUS_RANGE, SHADOW_ALPHA_RANGE, filters);
    }

    private CardState getInheritFromState() {
        if (this.inheritFromID == null) {
            return null;
        }
        if (this.card == null) {
            return null;
        }
        return this.card.getState(this.inheritFromID);
    }

    static {
        SHADOW_RADIUS_RANGE = new Range<Integer>(4, 15);
        SHADOW_ALPHA_RANGE = new Range<Float>(Float.valueOf(0.5f), Float.valueOf(0.8f));
    }
}

