/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.generate;

import com.sodiumarc.patchwork.animation.AS3Animation;
import com.sodiumarc.patchwork.animation.MultiPropertyKeyframes;
import com.sodiumarc.patchwork.app.scenecomposer.as3.TemplateLibrary;
import com.sodiumarc.patchwork.generate.CardState;
import com.sodiumarc.patchwork.generate.Hotspot;
import com.sodiumarc.patchwork.render.control.RenderImage;
import com.sodiumarc.patchwork.util.Rectangle4d;
import com.sodiumarc.patchwork.util.StringTemplate;
import com.sodiumarc.patchwork.util.StringUtils;
import com.sodiumarc.patchwork.util.xml.DocumentNodeDecoder;
import com.sodiumarc.patchwork.util.xml.XMLUtils;
import java.awt.Dimension;
import java.awt.Point;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Card {
    public static String ELEMENT_NAME = "card";
    public static String ID_ATTR_NAME = "id";
    public static String STARTING_SATE_ID_ATTR_NAME = "starting_state_id";
    public static String STARTING_COORDS_ATTR_NAME = "starting_coords";
    public static int CARD_SIZE = 300;
    public static Rectangle4d CARD_RECT = new Rectangle4d(0.0, 0.0, CARD_SIZE, CARD_SIZE);
    public static Rectangle4d CANONICAL_RECT = new Rectangle4d(0.0, 0.0, 1.0, 1.0);
    public static Dimension CARD_DIMENSION = new Dimension(CARD_SIZE, CARD_SIZE);
    public static DocumentNodeDecoder<Card> DECODER = new DocumentNodeDecoder<Card>(){

        @Override
        public Card decode(Node node) {
            assert (node != null) : "Null node";
            if (!node.getLocalName().equals(ELEMENT_NAME)) {
                return null;
            }
            Map<String, String> attributes = XMLUtils.getAttributes(node);
            try {
                return new Card(attributes.get(ID_ATTR_NAME), XMLUtils.decodeChildren(node, CardState.DECODER), XMLUtils.decodeChildren(node, AS3Animation.getSubclassDecoders()), XMLUtils.decodeChildren(node, MultiPropertyKeyframes.getSubclassDecoders()), attributes.get(STARTING_SATE_ID_ATTR_NAME), StringUtils.decodePoint(attributes.get(STARTING_COORDS_ATTR_NAME)));
            }
            catch (FileNotFoundException e) {
                Logger.getLogger(Card.class).warn("Failed to instantiate: ", e);
                return null;
            }
            catch (IOException e) {
                Logger.getLogger(Card.class).warn("Failed to instantiate: ", e);
                return null;
            }
        }
    };
    public static DocumentNodeDecoder<String> ID_DECODER = new DocumentNodeDecoder<String>(){

        @Override
        public String decode(Node node) {
            assert (node != null) : "Null node";
            if (!node.getLocalName().equals(ELEMENT_NAME)) {
                return null;
            }
            Map<String, String> attributes = XMLUtils.getAttributes(node);
            return attributes.get(ID_ATTR_NAME);
        }
    };
    private final String id;
    private final Map<String, CardState> statesByID;
    private final List<AS3Animation> animations;
    private final List<MultiPropertyKeyframes> keyframes;
    private final Set<RenderImage> images;
    private final String startingStateID;
    private final Point startingCoords;

    public static String getCardID(Document document) {
        Element docNode = document.getDocumentElement();
        if (docNode.getLocalName().equals(ELEMENT_NAME)) {
            return XMLUtils.getAttributes(docNode).get(ID_ATTR_NAME);
        }
        return null;
    }

    public Card(String id, List<CardState> states, List<AS3Animation> animations, List<MultiPropertyKeyframes> keyframes, String startingStateID, Point startingCoords) throws FileNotFoundException, IOException {
        this.id = id;
        this.statesByID = new LinkedHashMap<String, CardState>();
        this.animations = animations;
        this.keyframes = keyframes;
        for (CardState state : states) {
            this.statesByID.put(state.getID(), state);
        }
        this.startingStateID = startingStateID;
        this.startingCoords = startingCoords;
        this.images = new HashSet<RenderImage>();
        ArrayList<CardState> nonTransitionStates = new ArrayList<CardState>(this.statesByID.values());
        for (CardState state : nonTransitionStates) {
            state.init(this);
            this.images.addAll(state.getShadowImages());
            for (AS3Animation aS3Animation : state.getAnimations()) {
                this.images.addAll(aS3Animation.getImages(true));
            }
        }
        for (AS3Animation anim : animations) {
            this.images.addAll(anim.getImages(true));
        }
        this.generateHotspotTransitions();
    }

    public String getId() {
        return this.id;
    }

    public List<CardState> getStates() {
        return new ArrayList<CardState>(this.statesByID.values());
    }

    public CardState getState(String id) {
        return this.statesByID.get(id);
    }

    public String getStartingStateID() {
        return this.startingStateID;
    }

    public Collection<RenderImage> getImages() {
        return this.images;
    }

    public String toAS3String(TemplateLibrary templates) throws ParseException, FileNotFoundException, IOException {
        StringTemplate template = templates.getTemplate(this.getClass());
        assert (template != null) : "Missing template: " + this.getClass();
        StringTemplate resourceTemplate = templates.getTemplate(this.getClass(), "RESOURCE");
        assert (resourceTemplate != null) : "Missing template: RESOURCE";
        StringTemplate shadowImageTemplate = templates.getTemplate("SHADOW_IMAGE");
        assert (shadowImageTemplate != null) : "Missing template: SHADOW_IMAGE";
        StringTemplate addAnimToDictTemplate = templates.getTemplate(AS3Animation.class, "ADD_TO_DICTIONARY");
        assert (addAnimToDictTemplate != null) : "Missing template: ADD_TO_DICTIONARY";
        StringTemplate addKeyframesToDictTemplate = templates.getTemplate(MultiPropertyKeyframes.class, "ADD_TO_DICTIONARY");
        assert (addKeyframesToDictTemplate != null) : "Missing template: ADD_TO_DICTIONARY";
        StringBuilder stateDefList = new StringBuilder();
        for (CardState state : this.getStates()) {
            stateDefList.append(state.toAS3String(templates));
        }
        StringBuilder resources = new StringBuilder();
        for (RenderImage resource : this.getImages()) {
            resourceTemplate.setParameterValue("IMAGE_NAME", resource.getImageFilename());
            resourceTemplate.setParameterValue("IMAGE_OFFSET", StringUtils.encodePoint(resource.getOffset()));
            resources.append(resourceTemplate.getProcessedText());
        }
        StringBuilder shadows = new StringBuilder();
        List<RenderImage> shadowImages = CardState.getDefaultShadowImages();
        int index = 0;
        for (RenderImage shadowImage : shadowImages) {
            shadowImageTemplate.setParameterValue("IMAGE_NAME", shadowImage.getImageFilename());
            shadowImageTemplate.setParameterValue("IMAGE_INDEX", Integer.toString(index++));
            shadowImageTemplate.setParameterValue("IMAGE_COUNT", Integer.toString(shadowImages.size()));
            shadows.append(shadowImageTemplate.getProcessedText());
        }
        StringBuilder animDefList = new StringBuilder();
        for (AS3Animation anim : this.animations) {
            if (anim.getID() == null) continue;
            addAnimToDictTemplate.clearParameterValues();
            addAnimToDictTemplate.setParameterValue("ID", anim.getID());
            addAnimToDictTemplate.setParameterValue("ANIMATION", anim.toAS3String(templates));
            animDefList.append(addAnimToDictTemplate.getProcessedText());
        }
        StringBuilder keyframesDefList = new StringBuilder();
        for (MultiPropertyKeyframes pkf : this.keyframes) {
            if (pkf.getID() == null) continue;
            addKeyframesToDictTemplate.clearParameterValues();
            addKeyframesToDictTemplate.setParameterValue("ID", pkf.getID());
            addKeyframesToDictTemplate.setParameterValue("KEYFRAMES", pkf.toAS3String(templates));
            keyframesDefList.append(addKeyframesToDictTemplate.getProcessedText());
        }
        template.clearParameterValues();
        template.setParameterValue("CARD_ID", this.getId());
        template.setParameterValue("CARD_STATES", stateDefList.toString());
        template.setParameterValue("STARTING_STATE_ID", this.getStartingStateID());
        template.setParameterValue("COORDS", StringUtils.encodePoint(this.startingCoords));
        template.setParameterValue("ANIMATIONS", animDefList.toString());
        template.setParameterValue("KEYFRAMES", keyframesDefList.toString());
        template.setParameterValue("RESOURCES", resources.toString());
        template.setParameterValue("SHADOW_IMAGES", shadows.toString());
        return template.getProcessedText();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [id=" + this.id + "]";
    }

    private void generateHotspotTransitions() throws FileNotFoundException, IOException {
        for (CardState state : new ArrayList<CardState>(this.statesByID.values())) {
            for (Hotspot hotspot : state.getHotspots()) {
                Hotspot.Transition transitionType = hotspot.getTransition();
                if (transitionType == Hotspot.Transition.NONE) continue;
                CardState destinationState = this.statesByID.get(hotspot.getDestinationStateID());
                if (destinationState == null) {
                    Logger.getLogger(this.getClass()).warn("Hotspot detination state not found: " + hotspot.getDestinationStateID());
                    continue;
                }
                String transitionStateID = this.getUniqueStateID(state.getID() + "__" + destinationState.getID());
                CardState transition = hotspot.createAutoTransitionState(transitionStateID, state, destinationState);
                transition.init(this);
                this.statesByID.put(transition.getID(), transition);
            }
        }
    }

    private String getUniqueStateID(String desiredID) {
        String result = desiredID;
        int index = 0;
        while (this.statesByID.containsKey(result)) {
            result = desiredID + index++;
        }
        return result;
    }
}

