/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.collada;

import com.sodiumarc.patchwork.collada.Animation;
import com.sodiumarc.patchwork.collada.Camera;
import com.sodiumarc.patchwork.collada.ColladaElement;
import com.sodiumarc.patchwork.collada.ColladaSAXHandler;
import com.sodiumarc.patchwork.collada.Effect;
import com.sodiumarc.patchwork.collada.Geometry;
import com.sodiumarc.patchwork.collada.LibraryAnimations;
import com.sodiumarc.patchwork.collada.LibraryCameras;
import com.sodiumarc.patchwork.collada.LibraryEffects;
import com.sodiumarc.patchwork.collada.LibraryGeometries;
import com.sodiumarc.patchwork.collada.LibraryLights;
import com.sodiumarc.patchwork.collada.LibraryMaterials;
import com.sodiumarc.patchwork.collada.LibraryVisualScenes;
import com.sodiumarc.patchwork.collada.Light;
import com.sodiumarc.patchwork.collada.Material;
import com.sodiumarc.patchwork.collada.Mesh;
import com.sodiumarc.patchwork.collada.VisualScene;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class COLLADA
extends ColladaElement {
    public static final String FILE_EXTENSION = "dae";
    public static final String ELEMENT_NAME = "COLLADA";

    public static COLLADA fromFile(File inputFile) throws SAXException, IOException, ParserConfigurationException {
        FileInputStream fileInputStream = new FileInputStream(inputFile);
        return COLLADA.fromInputStream(fileInputStream);
    }

    public static COLLADA fromInputStream(InputStream inputStream) throws SAXException, IOException, ParserConfigurationException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(true);
        SAXParser saxParser = factory.newSAXParser();
        ColladaSAXHandler colladaSAXHandler = new ColladaSAXHandler();
        InputSource is = new InputSource(inputStream);
        is.setEncoding("utf-8");
        saxParser.parse(is, (DefaultHandler)colladaSAXHandler);
        return colladaSAXHandler.getRoot();
    }

    public final List<VisualScene> getVisualScenes() {
        ArrayList<VisualScene> visualScenes = new ArrayList<VisualScene>();
        List<LibraryVisualScenes> libraries = this.getChildElementsByType(LibraryVisualScenes.class);
        for (LibraryVisualScenes libraryVisualScenes : libraries) {
            visualScenes.addAll(libraryVisualScenes.getVisualScenes());
        }
        return visualScenes;
    }

    public final List<Geometry> getGeometries() {
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        List<LibraryGeometries> libraries = this.getChildElementsByType(LibraryGeometries.class);
        for (LibraryGeometries libraryGeometries : libraries) {
            geometries.addAll(libraryGeometries.getGeometries());
        }
        return geometries;
    }

    public final Map<String, Geometry> getGeometiesByID() {
        HashMap<String, Geometry> result = new HashMap<String, Geometry>();
        for (Geometry geometry : this.getGeometries()) {
            result.put(geometry.getId(), geometry);
        }
        return result;
    }

    public final Map<String, Mesh> getMeshesByID() {
        HashMap<String, Mesh> result = new HashMap<String, Mesh>();
        for (Geometry geometry : this.getGeometries()) {
            result.put(geometry.getId(), geometry.getMesh());
        }
        return result;
    }

    public final List<Camera> getCameras() {
        ArrayList<Camera> cameras = new ArrayList<Camera>();
        List<LibraryCameras> libraries = this.getChildElementsByType(LibraryCameras.class);
        for (LibraryCameras libraryCameras : libraries) {
            cameras.addAll(libraryCameras.getCameras());
        }
        return cameras;
    }

    public final Map<String, Camera> getCamerasByID() {
        HashMap<String, Camera> result = new HashMap<String, Camera>();
        for (Camera camera : this.getCameras()) {
            result.put(camera.getId(), camera);
        }
        return result;
    }

    public final List<Light> getLights() {
        ArrayList<Light> lights = new ArrayList<Light>();
        List<LibraryLights> libraries = this.getChildElementsByType(LibraryLights.class);
        for (LibraryLights libraryLights : libraries) {
            lights.addAll(libraryLights.getLights());
        }
        return lights;
    }

    public final Map<String, Light> getLightsByID() {
        HashMap<String, Light> result = new HashMap<String, Light>();
        for (Light light : this.getLights()) {
            result.put(light.getId(), light);
        }
        return result;
    }

    public final List<Animation> getAnimations() {
        ArrayList<Animation> animations = new ArrayList<Animation>();
        List<LibraryAnimations> libraries = this.getChildElementsByType(LibraryAnimations.class);
        for (LibraryAnimations libraryAnimations : libraries) {
            animations.addAll(libraryAnimations.getAnimations());
        }
        return animations;
    }

    public final List<Effect> getEffects() {
        ArrayList<Effect> effects = new ArrayList<Effect>();
        List<LibraryEffects> libraries = this.getChildElementsByType(LibraryEffects.class);
        for (LibraryEffects libraryEffects : libraries) {
            effects.addAll(libraryEffects.getEffects());
        }
        return effects;
    }

    public final Map<String, Effect> getEffectsByID() {
        HashMap<String, Effect> result = new HashMap<String, Effect>();
        for (Effect effect : this.getEffects()) {
            result.put(effect.getId(), effect);
        }
        return result;
    }

    public final List<Material> getMaterials() {
        ArrayList<Material> materials = new ArrayList<Material>();
        List<LibraryMaterials> libraries = this.getChildElementsByType(LibraryMaterials.class);
        for (LibraryMaterials libraryMaterials : libraries) {
            materials.addAll(libraryMaterials.getMaterials());
        }
        return materials;
    }

    public final Map<String, Material> getMaterialsByID() {
        HashMap<String, Material> result = new HashMap<String, Material>();
        for (Material material : this.getMaterials()) {
            result.put(material.getId(), material);
        }
        return result;
    }

    COLLADA() {
        super(ELEMENT_NAME);
    }
}

