/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.viewer;

import com.sodiumarc.patchwork.util.Filter;
import com.sodiumarc.patchwork.util.GeometricAxis;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;

public abstract class UnitlessDragSensor {
    private Point lastMousePosition;
    private float cumulativeDeltaX;
    private float cumulativeDeltaY;
    private float inputScaleX = 1.0f;
    private float inputScaleY = 1.0f;
    private GeometricAxis mouseWheelAxis;
    private float wheelScale = 1.0f;
    private Filter<Point> locationFilter;
    private Filter<MouseEvent> eventFilter;
    private boolean enabled = true;

    public UnitlessDragSensor(Component target, Filter<MouseEvent> eventFilter) {
        this.eventFilter = eventFilter;
        target.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (UnitlessDragSensor.this.isRelevant(e)) {
                    UnitlessDragSensor.this.onMousePressed(e.getPoint());
                } else {
                    UnitlessDragSensor.this.lastMousePosition = null;
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                UnitlessDragSensor.this.onMouseReleased(e.getPoint());
            }
        });
        target.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                UnitlessDragSensor.this.onMouseDrag(e.getPoint());
            }
        });
        target.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (!UnitlessDragSensor.this.isRelevant(e)) {
                    return;
                }
                if (e.getScrollType() == 0) {
                    UnitlessDragSensor.this.onMouseWheel(e.getUnitsToScroll());
                }
            }
        });
    }

    public void reset() {
        this.cumulativeDeltaX = 0.0f;
        this.cumulativeDeltaY = 0.0f;
    }

    public void setInputScaleX(float inputScale) {
        this.inputScaleX = inputScale;
    }

    public void setInputScaleY(float inputScale) {
        this.inputScaleY = inputScale;
    }

    public void setMouseWheelAxis(GeometricAxis mouseWheelAxis) {
        this.mouseWheelAxis = mouseWheelAxis;
    }

    public void setMouseWheelScale(float wheelScale) {
        this.wheelScale = wheelScale;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Filter<Point> getLocationFilter() {
        return this.locationFilter;
    }

    public void setLocationFilter(Filter<Point> locationFilter) {
        this.locationFilter = locationFilter;
    }

    protected abstract void update(float var1, float var2, float var3, float var4);

    private boolean isRelevant(MouseEvent event) {
        return this.eventFilter == null || this.eventFilter.accept(event);
    }

    private void onMouseWheel(int unitsToScroll) {
        if (this.mouseWheelAxis == null) {
            return;
        }
        float scaledUnits = this.wheelScale * (float)unitsToScroll;
        float deltaX = 0.0f;
        float deltaY = 0.0f;
        if (this.mouseWheelAxis == GeometricAxis.X) {
            deltaX = scaledUnits;
        } else if (this.mouseWheelAxis == GeometricAxis.Y) {
            deltaY = scaledUnits;
        }
        this.cumulativeDeltaX += deltaX;
        this.cumulativeDeltaY += deltaY;
        if (this.enabled) {
            this.update(deltaX, deltaY, this.cumulativeDeltaX, this.cumulativeDeltaY);
        }
    }

    private void onMouseDrag(Point point) {
        if (!this.enabled) {
            return;
        }
        if (this.lastMousePosition == null) {
            return;
        }
        float deltaX = this.inputScaleX * (float)(point.x - this.lastMousePosition.x);
        float deltaY = this.inputScaleY * (float)(point.y - this.lastMousePosition.y);
        this.cumulativeDeltaX += deltaX;
        this.cumulativeDeltaY += deltaY;
        if (this.enabled) {
            this.update(deltaX, deltaY, this.cumulativeDeltaX, this.cumulativeDeltaY);
        }
        this.lastMousePosition = point;
    }

    private void onMouseReleased(Point point) {
        this.lastMousePosition = null;
    }

    private void onMousePressed(Point point) {
        if (this.locationFilter == null || this.locationFilter.accept(point)) {
            this.lastMousePosition = point;
        }
    }
}

