/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.viewer;

import com.sodiumarc.patchwork.animation.Animation;
import com.sodiumarc.patchwork.animation.AnimationListener;
import com.sodiumarc.patchwork.util.MathUtils;
import java.util.ArrayList;
import java.util.List;

public abstract class SimulationClockAnimation
implements Animation {
    private final List<AnimationListener> listeners = new ArrayList<AnimationListener>();
    private boolean isRunning;
    private long durationInMillis = 2000L;
    private boolean isLoop = false;
    private long elapsedMillis;
    private long startMillis = -1L;
    private float elapsedFraction;

    public void setElapsedTicks(int elapsedTicks, long elapsedMillis) {
        this.elapsedMillis = elapsedMillis;
        if (this.isRunning) {
            if (this.startMillis < 0L) {
                this.startMillis = elapsedMillis;
            }
            this.setElapsedMillis(elapsedMillis - this.startMillis);
        }
    }

    @Override
    public void setElapsedFraction(float elapsedFraction) {
        this.setElapsedFractionImpl(elapsedFraction);
    }

    @Override
    public float getElapsedFraction() {
        return this.elapsedFraction;
    }

    @Override
    public void setDurationInMillis(long durationInMillis) {
        this.durationInMillis = durationInMillis;
    }

    @Override
    public long getDurationInMillis() {
        return this.durationInMillis;
    }

    @Override
    public void setLoop(boolean isLoop) {
        this.isLoop = isLoop;
    }

    @Override
    public boolean isLoop() {
        return this.isLoop;
    }

    @Override
    public void start() {
        this.isRunning = true;
        this.startMillis = -1L;
        this.fireStarted();
    }

    @Override
    public void stop() {
        this.isRunning = false;
        this.fireStopped();
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    @Override
    public void addListener(AnimationListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(AnimationListener listener) {
        this.listeners.remove(listener);
    }

    protected abstract void elapsedFractionChanged(float var1);

    protected Animation getEventSource() {
        return this;
    }

    protected void animationStarted(Animation source) {
    }

    protected void animationStopped(Animation source) {
    }

    protected void elapsedFractionChanged(Animation source, float elapsedFraction) {
    }

    private void setElapsedFractionImpl(float fraction) {
        this.elapsedFraction = this.toNormalRange(fraction);
        this.elapsedFractionChanged(this.elapsedFraction);
        this.fireElapsedFractionChanged();
    }

    private void setElapsedMillis(long elapsedMillis) {
        this.setElapsedFractionImpl((float)elapsedMillis / (float)this.durationInMillis);
        if (this.elapsedFraction >= 1.0f && this.isRunning && !this.isLoop) {
            this.stop();
        }
    }

    private float toNormalRange(float elapsedFraction) {
        if (this.isLoop) {
            return elapsedFraction % 1.0f;
        }
        return MathUtils.clamp(elapsedFraction, 0.0f, 1.0f);
    }

    private void fireStarted() {
        this.animationStarted(this.getEventSource());
        for (AnimationListener listener : new ArrayList<AnimationListener>(this.listeners)) {
            listener.animationStarted(this.getEventSource());
        }
    }

    private void fireStopped() {
        this.animationStopped(this.getEventSource());
        for (AnimationListener listener : new ArrayList<AnimationListener>(this.listeners)) {
            listener.animationStopped(this.getEventSource());
        }
    }

    private void fireElapsedFractionChanged() {
        this.elapsedFractionChanged(this.getEventSource(), this.elapsedFraction);
        for (AnimationListener listener : new ArrayList<AnimationListener>(this.listeners)) {
            listener.elapsedFractionChanged(this.getEventSource(), this.elapsedFraction);
        }
    }
}

