/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.viewer;

import com.sodiumarc.patchwork.app.scenecomposer.viewer.SimulationClockListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Timer;

public class SimulationClock {
    private final Timer timer;
    private final List<SimulationClockListener> listeners;
    private final int millisPerTick;
    private long startTime;
    private long lastTickTime;
    private int elapsedTicks;
    private long elapsedMillis;

    public SimulationClock(int millisPerTick) {
        this.millisPerTick = millisPerTick;
        this.timer = new Timer(millisPerTick, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimulationClock.this.update();
            }
        });
        this.listeners = new ArrayList<SimulationClockListener>();
    }

    public void start() {
        this.timer.start();
        this.startTime = System.currentTimeMillis();
        this.lastTickTime = System.currentTimeMillis();
        this.elapsedMillis = 0L;
        this.elapsedTicks = 0;
    }

    public void stop() {
        this.timer.stop();
    }

    public boolean isRunning() {
        return this.timer.isRunning();
    }

    public int getMillisPerTick() {
        return this.millisPerTick;
    }

    public int getElapsedTicks() {
        return this.elapsedTicks;
    }

    public long getElapsedMillis() {
        return this.elapsedMillis;
    }

    public void addListener(SimulationClockListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(SimulationClockListener listener) {
        this.listeners.remove(listener);
    }

    private void update() {
        long thisTickTime = System.currentTimeMillis();
        long elapsedTime = thisTickTime - this.lastTickTime;
        int ticks = (int)(elapsedTime / (long)this.millisPerTick);
        this.tick(ticks);
    }

    private void tick(int ticks) {
        this.elapsedTicks += ticks;
        this.lastTickTime = System.currentTimeMillis();
        this.elapsedMillis = this.lastTickTime - this.startTime;
        for (SimulationClockListener listener : new ArrayList<SimulationClockListener>(this.listeners)) {
            listener.tick(this.elapsedTicks, this.elapsedMillis);
        }
    }
}

